<?php
/**
 * Related Products
 * @author        WooThemes
 * @package       WooCommerce/Templates
 * @version       1.6.4
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}


$ruby_woo_product = innovation_ruby_woo_global_product();
if ( empty( $ruby_woo_product ) || ! $ruby_woo_product->exists() ) {
	return;
}


$ruby_related = $ruby_woo_product->get_related( $posts_per_page );
if ( sizeof( $ruby_related ) == 0 ) {
	return false;
}

$args = apply_filters( 'woocommerce_related_products_args', array(
	'post_type'           => 'product',
	'ignore_sticky_posts' => 1,
	'no_found_rows'       => 1,
	'posts_per_page'      => $posts_per_page,
	'orderby'             => $orderby,
	'post__in'            => $ruby_related,
	'post__not_in'        => array( $ruby_woo_product->id )
) );

$products = new WP_Query( $args );

//related column
innovation_ruby_related_woocommerce_loop( $columns );

if ( $products->have_posts() ) : ?>

	<div class="related products">

		<div class="widget-title">
			<h3><?php esc_attr_e( 'Related Products', 'innovation' ); ?></h3>
		</div>

		<?php woocommerce_product_loop_start(); ?>

		<?php while ( $products->have_posts() ) : $products->the_post(); ?>

			<?php wc_get_template_part( 'content', 'product' ); ?>

		<?php endwhile; // end of the loop. ?>

		<?php woocommerce_product_loop_end(); ?>

	</div>

<?php endif;

wp_reset_postdata();
