<?php
add_action('widgets_init', 'innovation_ruby_register_block_post_widget');

function innovation_ruby_register_block_post_widget()
{
    register_widget('innovation_ruby_block_post_widget');
}

class innovation_ruby_block_post_widget extends WP_Widget
{

	//register widget
    function __construct()
    {
        $widget_ops = array('classname' => 'block-post-widget', 'description' => esc_html__('[Sidebar Widget] Display posts with custom query in sidebar section','innovation'));
        parent::__construct('innovation_ruby_block_post_widget', esc_html__('[SIDEBAR] - Posts widget', 'innovation'), $widget_ops);
    }


	//render widget
    function widget($args, $instance)
    {
        extract($args);
	    $ruby_options                   = array();
	    $title                          = ! empty( $instance['title'] ) ? esc_attr( $instance['title'] ) : '';
	    $ruby_options['posts_per_page'] = ! empty( $instance['posts_per_page'] ) ? $instance['posts_per_page'] : 4;
	    $ruby_options['orderby']        = ! empty( $instance['orderby'] ) ? $instance['orderby'] : 'date_post';
	    $ruby_options['category_id']    = ! empty( $instance['cate'] ) ? $instance['cate'] : 0;
	    $ruby_options['category_ids']   = ! empty( $instance['cates'] ) ? $instance['cates'] : '';
	    $ruby_options['tags']           = ! empty( $instance['tags'] ) ? $instance['tags'] : '';
	    $ruby_options['offset']         = ! empty( $instance['offset'] ) ? $instance['offset'] : 0;
	    $style                          = ! empty( $instance['style'] ) ? $instance['style'] : 'style1';

		//query data
        $query_data = innovation_ruby_query::get_custom_query($ruby_options);

        echo $before_widget;

	    if ( ! empty( $title ) ) {
		    echo $before_title . esc_attr( $title ) . $after_title;
	    }

	    if ( $query_data->have_posts() ) {
		    echo '<div class="post-widget-inner">';

		    switch ( $style ) {

			    case 'style1' :
				    while ( $query_data->have_posts() ) {
					    $query_data->the_post();
					    get_template_part( 'templates/loop', 'small_list' );
				    };
				    break;

			    case 'style2' :

				    $ruby_counter = 1;

				    while ( $query_data->have_posts() ) {
					    $query_data->the_post();
					    echo '<div class="post-counter-style">';
					    echo '<div class="post-count-text post-meta-info"><span>' . esc_attr( $ruby_counter ) . '. </span></div>';
					    innovation_ruby_template_part::post_title( 'is-small-title' );
					    echo '</div><!--#post counter-->';

					    $ruby_counter ++;
				    };
				    break;

			    case 'style3' :

				    $ruby_flag = true;

				    if ( empty( $query_data->post_count ) || ( $query_data->post_count < 2 ) ) {
					    echo innovation_ruby_block::not_enough_post();
				    } else {
					    while ( $query_data->have_posts() ) {
						    $query_data->the_post();

						    if ( true === $ruby_flag ) {
							    echo '<div class="is-top-row">';
							    get_template_part( 'templates/loop', 'grid' );
							    echo '</div><!--#top row-->';
							    echo '<div class="is-bottom-row">';
							    $ruby_flag = false;
						    } else {
							    get_template_part( 'templates/loop', 'small_list' );
						    }
					    }
					    echo '</div><!--#bottom row-->';
				    };
				    break;

			    case 'style4' :

				    $ruby_flag = true;

				    if ( empty( $query_data->post_count ) || ( $query_data->post_count < 2 ) ) {
					    echo innovation_ruby_block::not_enough_post();
				    } else {
					    while ( $query_data->have_posts() ) {
						    $query_data->the_post();

						    if ( true === $ruby_flag ) {
							    echo '<div class="is-top-row">';
							    get_template_part( 'templates/loop', 'grid_overlay' );
							    echo '</div><!--#top row-->';
							    echo '<div class="is-bottom-row">';
							    $ruby_flag = false;
						    } else {
							    get_template_part( 'templates/loop', 'small_list' );
						    }
					    }
					    echo '</div><!--#bottom row-->';
				    };
				    break;

			    case 'style5' :

				    while ( $query_data->have_posts() ) {
					    $query_data->the_post();
					    echo '<div class="post-counter-style post-wrap-widget-style-5">';
					    innovation_ruby_template_part::post_title();
					    innovation_ruby_template_part::post_meta_info( array( 'date' => true ) );
					    echo '</div><!--#post-->';

				    };
				    break;

			    case 'style6' :

				    while ( $query_data->have_posts() ) {
					    $query_data->the_post();
					    get_template_part( 'templates/loop', 'small_grid' );

				    }
				    break;
		    }


		    echo '</div><!--#post widget inner -->';
        }

	    //reset post data
	    wp_reset_postdata();
        echo $after_widget;
    }


	//update forms
	function update( $new_instance, $old_instance ) {
		$instance                   = $old_instance;
		$instance['title']          = strip_tags( $new_instance['title'] );
		$instance['style']          = strip_tags( $new_instance['style'] );
		$instance['cate']           = strip_tags( $new_instance['cate'] );
		$instance['cates']          = strip_tags( $new_instance['cates'] );
		$instance['tags']           = strip_tags( $new_instance['tags'] );
		$instance['posts_per_page'] = absint( strip_tags( $new_instance['posts_per_page'] ) );
		$instance['offset']         = absint( strip_tags( $new_instance['offest'] ) );
		$instance['orderby']        = strip_tags( $new_instance['orderby'] );

		return $instance;
	}


	//form settinga
    function form($instance)
    {
	    $defaults = array(
		    'title'          => esc_html__( 'latest posts', 'innovation' ),
		    'style'          => '',
		    'orderby'        => 'date_post',
		    'posts_per_page' => 4,
		    'cate'           => '',
		    'cates'          => '',
		    'tags'           => '',
		    'offset'         => 0
	    );
	    $instance = wp_parse_args( (array) $instance, $defaults ); ?>

	    <p>
		    <label for="<?php echo esc_attr($this->get_field_id( 'title' )); ?>"><?php esc_attr_e('Title:','innovation') ?></label>
		    <input type="text" class="widefat" id="<?php echo esc_attr($this->get_field_id( 'title' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'title' )); ?>" value="<?php if(!empty($instance['title'])) echo esc_attr($instance['title']); ?>" />
	    </p>

	    <p>
		    <label for="<?php echo esc_attr($this->get_field_id( 'style' )); ?>"><?php esc_attr_e('Style:', 'innovation'); ?></label>
		    <select class="widefat" id="<?php echo esc_attr($this->get_field_id( 'style' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'style' )); ?>" >
			    <option value="style1" <?php if( !empty($instance['style']) && $instance['style'] == 'style1' ) echo "selected=\"selected\""; else echo ""; ?>><?php esc_attr_e('Style 1', 'innovation'); ?></option>
			    <option value="style2" <?php if( !empty($instance['style']) && $instance['style'] == 'style2' ) echo "selected=\"selected\""; else echo ""; ?>><?php esc_attr_e('Style 2', 'innovation'); ?></option>
			    <option value="style3" <?php if( !empty($instance['style']) && $instance['style'] == 'style3' ) echo "selected=\"selected\""; else echo ""; ?>><?php esc_attr_e('Style 3', 'innovation'); ?></option>
			    <option value="style4" <?php if( !empty($instance['style']) && $instance['style'] == 'style4' ) echo "selected=\"selected\""; else echo ""; ?>><?php esc_attr_e('Style 4', 'innovation'); ?></option>
			    <option value="style5" <?php if( !empty($instance['style']) && $instance['style'] == 'style5' ) echo "selected=\"selected\""; else echo ""; ?>><?php esc_attr_e('Style 5', 'innovation'); ?></option>
			    <option value="style6" <?php if( !empty($instance['style']) && $instance['style'] == 'style6' ) echo "selected=\"selected\""; else echo ""; ?>><?php esc_attr_e('Style 6', 'innovation'); ?></option>
		    </select>
	    </p>

	    <p>
		    <label for="<?php echo esc_attr($this->get_field_id('cate')); ?>"><strong><?php esc_attr_e('Category Filter:', 'innovation'); ?></strong></label>
		    <select class="widefat" id="<?php echo esc_attr($this->get_field_id('cate')); ?>" name="<?php echo esc_attr($this->get_field_name('cate')); ?>">
			    <option value='all' <?php if ($instance['cate'] == 'all') echo 'selected="selected"'; ?>><?php esc_attr_e('All Categories', 'innovation'); ?></option>
			    <?php $categories = get_categories('type=post'); foreach ($categories as $category) { ?><option  value='<?php echo esc_attr($category->term_id); ?>' <?php if ($instance['cate'] == $category->term_id) echo 'selected="selected"'; ?>><?php echo esc_attr($category->cat_name); ?></option><?php } ?>
		    </select>
	    </p>

	    <p>
		    <label for="<?php echo esc_attr($this->get_field_id( 'cates' )); ?>"><?php esc_attr_e('Multiple Category Filter (optional, Input category ids, Separate category ids with comma. e.g. 1,2):','innovation') ?></label>
		    <input type="text" class="widefat" id="<?php echo esc_attr($this->get_field_id( 'cates' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'cates' )); ?>" value="<?php if( !empty($instance['cates']) ) echo esc_attr($instance['cates']); ?>" />
	    </p>

	    <p>
		    <label for="<?php echo esc_attr($this->get_field_id( 'tags' )); ?>"><?php esc_attr_e('Tags (optional, Separate tags with comma. e.g. tag1,tag2):','innovation') ?></label>
		    <input type="text" class="widefat" id="<?php echo esc_attr($this->get_field_id( 'tags' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'tags' )); ?>" value="<?php if( !empty($instance['tags']) ) echo esc_attr($instance['tags']); ?>" />
	    </p>

	    <p>
		    <label for="<?php echo esc_attr($this->get_field_id( 'posts_per_page' )); ?>"><?php esc_attr_e('Limit Post Number (optional, default is 4):','innovation') ?></label>
		    <input type="text" class="widefat" id="<?php echo esc_attr($this->get_field_id( 'posts_per_page' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'posts_per_page' )); ?>" value="<?php if( !empty($instance['posts_per_page']) ) echo esc_attr($instance['posts_per_page']); ?>" />
	    </p>

	    <p>
		    <label for="<?php echo esc_attr($this->get_field_id( 'offset' )); ?>"><?php esc_attr_e('Post Offset (optional, default is 0):','innovation') ?></label>
		    <input type="text" class="widefat" id="<?php echo esc_attr($this->get_field_id( 'offset' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'offest' )); ?>" value="<?php if( !empty($instance['offset']) ) echo esc_attr($instance['offset']); ?>" />
	    </p>

	    <p>
		    <label for="<?php echo esc_attr($this->get_field_id( 'orderby' )); ?>"><?php esc_attr_e('Order By:', 'innovation'); ?></label>
		    <select class="widefat" id="<?php echo esc_attr($this->get_field_id( 'orderby' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'orderby' )); ?>" >
			    <option value="date_post" <?php if( !empty($instance['orderby']) && $instance['orderby'] == 'date' ) echo "selected=\"selected\""; else echo ""; ?>><?php esc_attr_e('Latest Post', 'innovation'); ?></option>
			    <option value="comment_count" <?php if( !empty($instance['orderby']) && $instance['orderby'] == 'comment_count' ) echo "selected=\"selected\""; else echo ""; ?>><?php esc_attr_e('Popular Post by Comments', 'innovation'); ?></option>
			    <option value="popular" <?php if( !empty($instance['orderby']) && $instance['orderby'] == 'popular' ) echo "selected=\"selected\""; else echo ""; ?>><?php esc_attr_e('Popular Post by Views', 'innovation'); ?></option>
			    <option value="top_review" <?php if( !empty($instance['orderby']) && $instance['orderby'] == 'top_review' ) echo "selected=\"selected\""; else echo ""; ?>><?php esc_attr_e('Best Review', 'innovation'); ?></option>
			    <option value="post_type" <?php if( !empty($instance['orderby']) && $instance['orderby'] == 'post_type' ) echo "selected=\"selected\""; else echo ""; ?>><?php esc_attr_e('Post Type', 'innovation'); ?></option>
			    <option value="rand" <?php if( !empty($instance['orderby']) && $instance['orderby'] == 'rand' ) echo "selected=\"selected\""; else echo ""; ?>><?php esc_attr_e('Random Post', 'innovation'); ?></option>
			    <option value="author" <?php if( !empty($instance['author']) && $instance['orderby'] == 'author' ) echo "selected=\"selected\""; else echo ""; ?>><?php esc_attr_e('Author', 'innovation'); ?></option>
			    <option value="alphabetical_order_asc" <?php if( !empty($instance['orderby']) && $instance['orderby'] == 'alphabetical_order_asc' ) echo "selected=\"selected\""; else echo ""; ?>><?php esc_attr_e('alphabetical A->Z Posts', 'innovation'); ?></option>
			    <option value="alphabetical_order_decs" <?php if( !empty($instance['orderby']) && $instance['orderby'] == 'alphabetical_order_decs' ) echo "selected=\"selected\""; else echo ""; ?>><?php esc_attr_e('alphabetical Z->A Posts', 'innovation'); ?></option>
		    </select>
	    </p>
    <?php
    }
}

?>