<?php
add_action( 'widgets_init', 'innovation_ruby_register_footer_social_counter' );

function innovation_ruby_register_footer_social_counter() {
	register_widget( 'innovation_ruby_footer_social_counter' );
}


class innovation_ruby_footer_social_counter extends WP_Widget {


	function __construct() {
		$widget_ops = array( 'classname'   => 'footer-social-counter-widget is-top-footer-widget', 'description' => esc_html__( '[Top Footer Widget] Display number of followers in top footer section', 'innovation'));
		parent::__construct( 'innovation_ruby_footer_social_counter_widget', esc_html__( '[TOP FOOTER] - Social Counter*', 'innovation' ), $widget_ops );
	}

	//Show widget
	function widget( $args, $instance ) {
		extract( $args );

		$facebook_page   = ( ! empty( $instance['facebook_page'] ) ) ? $instance['facebook_page'] : '';
		$youtube_user    = ( ! empty( $instance['youtube_user'] ) ) ? $instance['youtube_user'] : '';
		$youtube_channel = ( ! empty( $instance['youtube_channel'] ) ) ? $instance['youtube_channel'] : '';
		$dribbble_user   = ( ! empty( $instance['dribbble_user'] ) ) ? $instance['dribbble_user'] : '';
		$dribbble_token  = ( ! empty( $instance['dribbble_token'] ) ) ? $instance['dribbble_token'] : '';
		$soundcloud_user = ( ! empty( $instance['soundcloud_user'] ) ) ? $instance['soundcloud_user'] : '';
		$soundcloud_api  = ( ! empty( $instance['soundcloud_api'] ) ) ? $instance['soundcloud_api'] : '';
		$instagram_api   = ( ! empty( $instance['instagram_api'] ) ) ? $instance['instagram_api'] : '';
		$twitter_user    = ( ! empty( $instance['twitter_user'] ) ) ? $instance['twitter_user'] : '';
		$pinterest_user  = ( ! empty( $instance['pinterest_user'] ) ) ? $instance['pinterest_user'] : '';
		$vimeo_user      = ( ! empty( $instance['vimeo_user'] ) ) ? $instance['vimeo_user'] : '';
		$vk_user         = ( ! empty( $instance['vk_user'] ) ) ? $instance['vk_user'] : '';
		$google_user     = ( ! empty( $instance['google_user'] ) ) ? $instance['google_user'] : '';
		$google_api      = ( ! empty( $instance['google_api'] ) ) ? $instance['google_api'] : '';

		echo $before_widget;
		?>
		<div class="footer-social-counter social-counter-wrap">
			<div class="ruby-container">

				<?php
				//facebook counter
				if ( ! empty( $facebook_page ) ) :
					$option['facebook_page'] = $facebook_page;
					$facebook_count          = innovation_ruby_social_fan::get_footer_social_counter( 'facebook_page', $option );
					?>
					<div class="counter-element">
						<a target="_blank" href="https://facebook.com/<?php echo urlencode($facebook_page); ?>" class="facebook" title="facebook"><i class="fa fa-facebook"></i>
							<span class="num-count"><?php echo esc_attr(innovation_ruby_social_fan::show_over_100k($facebook_count)); ?></span>
						</a>
						<div class="text-count"><a target="_blank" href="https://facebook.com/<?php echo urlencode($facebook_page); ?>" class="facebook" title="facebook"><?php esc_html_e('followers', 'innovation'); ?></a></div>
					</div><!--facebook like count -->
				<?php  endif;

				//twitter counter
				if ( ! empty( $twitter_user ) ) :
					$option['twitter_user'] = $twitter_user;
					$twitter_count          = innovation_ruby_social_fan::get_footer_social_counter( 'twitter', $option );
					?>
					<div class="counter-element">
						<a target="_blank" href="https://twitter.com/<?php echo urlencode($twitter_user); ?>" class="twitter" title="twitter"><i class="fa fa-twitter"></i>
							<span class="num-count"><?php echo esc_attr(innovation_ruby_social_fan::show_over_100k($twitter_count)); ?></span>
						</a>
						<div class="text-count"><a target="_blank" href="https://twitter.com/<?php echo urlencode($twitter_user); ?>" class="twitter" title="twitter"><?php esc_html_e('followers', 'innovation'); ?></a></div>
					</div><!--twitter follower count -->
				<?php endif;


				//twitter counter
				if ( ! empty( $google_user ) ) :
					$option['google_user'] = $google_user;
					$option['google_api']  = $google_api;
					$google_count          = innovation_ruby_social_fan::get_footer_social_counter( 'google', $option );
					?>
					<div class="counter-element">
						<a target="_blank" href="https://plus.google.com/<?php echo urlencode( $google_user ); ?>" class="google-plus" title="google +"><i class="fa fa-google-plus"></i>
							<span class="num-count"><?php echo esc_attr( innovation_ruby_social_fan::show_over_100k( $google_count ) ); ?></span>
						</a>
						<div class="text-count"><a target="_blank" href="https://plus.google.com/<?php echo urlencode( $google_user ); ?>" class="google-plus" title="google +"><?php esc_html_e('followers', 'innovation'); ?></a></div>
					</div><!--google plus follower count -->
				<?php endif;

				if ( ! empty( $pinterest_user ) ) :
					$option['pinterest_user'] = $pinterest_user;
					$pinterest_count          = innovation_ruby_social_fan::get_footer_social_counter( 'pinterest', $option );
					?>
					<div class="counter-element">
						<a target="_blank" href="https://pinterest.com/<?php echo urlencode($pinterest_user); ?>" class="pinterest" title="pinterest"><i class="fa fa-pinterest"></i>
							<span class="num-count"><?php echo esc_attr(innovation_ruby_social_fan::show_over_100k($pinterest_count)); ?></span>
						</a>
						<div class="text-count"><a target="_blank" href="https://pinterest.com/<?php echo urlencode($pinterest_user); ?>" class="pinterest" title="pinterest"><?php esc_html_e('followers', 'innovation'); ?></a></div>
					</div><!--pinterest follower count -->
				<?php endif;

				//instagram counter
				if (!empty($instagram_api)):
					$option['instagram_api'] = $instagram_api;
					$data_instagram          = innovation_ruby_social_fan::get_footer_social_counter( 'instagram', $option );
					if ( empty( $data_instagram ) ) {
						$data_instagram = array(
							'count'     => 0,
							'user_name' => '',
							'url'       => '',
						);
					};
					?>
					<div class="counter-element">
						<a target="_blank" href="<?php echo esc_url($data_instagram['url']) ?>" title="instagram"><i class="fa fa-instagram"></i>
							<span class="num-count"><?php echo esc_attr(innovation_ruby_social_fan::show_over_100k($data_instagram['count'])); ?></span>
						</a>
						<div class="text-count"><a target="_blank" href="<?php echo esc_url($data_instagram['url']) ?>" title="instagram"><?php esc_html_e('followers', 'innovation'); ?></a></div>
					</div><!--instagram follower count -->
				<?php endif;

				//youtube counter
				if ( ! empty( $youtube_user ) || !empty($youtube_channel) ) :
					$option['youtube_user']    = $youtube_user;
					$option['youtube_channel'] = $youtube_channel;
					$youtube_count             = innovation_ruby_social_fan::get_footer_social_counter( 'youtube', $option );
					?>
					<div class="counter-element">
						<?php if ( !empty( $youtube_user ) ) : ?>
						<a target="_blank" href="https://www.youtube.com/user/<?php echo esc_attr($youtube_user); ?>" title="<?php esc_html_e('Youtube', 'innovation'); ?>">
						<?php else : ?>
						<a target="_blank" href="https://www.youtube.com/channel/<?php echo esc_attr($youtube_channel); ?>" title="<?php esc_html_e('Youtube', 'innovation'); ?>">
						<?php endif; ?>
							<i class="fa fa-youtube"></i>
							<span class="num-count"><?php echo esc_attr(innovation_ruby_social_fan::show_over_100k($youtube_count)); ?></span>
						</a>
						<div class="text-count">
							<?php if ( !empty( $youtube_user )) : ?>
							<a target="_blank" href="https://www.youtube.com/user/<?php echo esc_attr($youtube_user); ?>" title="<?php esc_html_e('Youtube', 'innovation'); ?>"><?php esc_html_e('Subscribers', 'innovation'); ?></a>
							<?php else : ?>
							<a target="_blank" href="https://www.youtube.com/channel/<?php echo esc_attr($youtube_channel); ?>" title="<?php esc_html_e('Youtube', 'innovation'); ?>"><?php esc_html_e('Subscribers', 'innovation'); ?></a>
							<?php endif; ?>
						</div>
					</div><!--youtube subscribers count -->
				<?php endif;

				//soundcloud counter
				if ( ! empty( $soundcloud_user ) && ! empty( $soundcloud_api ) ):
					$option['soundcloud_user'] = $soundcloud_user;
					$option['soundcloud_api']  = $soundcloud_api;
					$soundcloud_data           = innovation_ruby_social_fan::get_footer_social_counter( 'soundcloud', $option );
					if ( empty( $soundcloud_data ) ) {
						$soundcloud_data = array(
							'url'   => '',
							'count' => ''
						);
					}
					?>
					<div class="counter-element">
						<a target="_blank" href="<?php echo esc_url($soundcloud_data['url']); ?>" title="<?php esc_html_e('soundclound', 'innovation'); ?>"><i class="fa fa-soundcloud"></i>
							<span class="num-count"><?php echo esc_attr(innovation_ruby_social_fan::show_over_100k($soundcloud_data['count'])); ?></span>
						</a>
						<div class="text-count"><a target="_blank" href="<?php echo esc_url($soundcloud_data['url']); ?>" title="<?php esc_html_e('soundclound', 'innovation'); ?>"><?php esc_html_e('followers', 'innovation'); ?></a></div>
					</div><!--soundcloud follower count -->
				<?php endif;

				//vimeo counter
				if ( ! empty( $vimeo_user ) ) :
					$option['vimeo_user'] = $vimeo_user;
					$vimeo_count          = innovation_ruby_social_fan::get_footer_social_counter( 'vimeo', $option );
					?>
					<div class="counter-element">
						<a target="_blank" href="https://vimeo.com/<?php echo esc_attr($vimeo_user); ?>" title="vimeo"><i class="fa fa-vimeo"></i>
							<span class="num-count"><?php echo esc_attr(innovation_ruby_social_fan::show_over_100k($vimeo_count)); ?></span>
						</a>
						<div class="text-count">
							<a target="_blank" href="https://vimeo.com/<?php echo esc_attr($vimeo_user); ?>" title="vimeo"><?php esc_html_e('followers', 'innovation'); ?></a>
						</div>
					</div><!--vimeo follower count -->
				<?php endif;

				//dribbble counter
				if ( ! empty( $dribbble_user ) || !empty($dribbble_token) ) :
					$option['dribbble_user']  = $dribbble_user;
					$option['dribbble_token'] = $dribbble_token;
					$dribbble_count           = innovation_ruby_social_fan::get_footer_social_counter( 'dribbble', $option );
					?>
					<div class="counter-element">
						<a target="_blank" href="https://dribbble.com/<?php echo esc_attr($dribbble_user); ?>" title="<?php esc_html_e('dribbble', 'innovation'); ?>">
							<i class="fa fa-dribbble"></i>
							<span class="num-count"><?php echo esc_attr(innovation_ruby_social_fan::show_over_100k($dribbble_count)); ?></span>
						</a>
						<div class="text-count">
							<a target="_blank" href="https://dribbble.com/<?php echo esc_attr($dribbble_user); ?>" title="<?php esc_html_e('dribbble', 'innovation'); ?>"><?php esc_html_e('followers', 'innovation'); ?></a>
						</div>
					</div><!--dribbble follower count -->
				<?php endif;

				//vk counter
				if ( ! empty( $vk_user ) ) :
					$option['vk_user'] = $vk_user;
					$vk_count          = innovation_ruby_social_fan::get_footer_social_counter( 'vk', $option );
					?>
					<div class="counter-element">
						<a target="_blank" href="https://vimeo.com/<?php echo esc_attr($vk_user); ?>" title="Vkontakte"><i class="fa fa-vk"></i>
							<span class="num-count"><?php echo esc_attr(innovation_ruby_social_fan::show_over_100k($vk_count)); ?></span>
						</a>
						<div class="text-count">
							<a target="_blank" href="https://vimeo.com/<?php echo esc_attr($vk_user); ?>" title="Vkontakte"><?php esc_html_e('followers', 'innovation'); ?></a>
						</div>
					</div><!--vk follower count -->
				<?php endif; ?>

			</div><!--#ruby-container -->
		</div><!-- #social count wrap -->

		<?php
		echo $after_widget;
	}
	
	//update widget
	function update( $new_instance, $old_instance ) {
		$instance = $old_instance;
		//remove cache
		delete_transient( 'innovation_ruby_ft_social_fan_facebook_page' );
		delete_transient( 'innovation_ruby_ft_social_fan_twitter' );
		delete_transient( 'innovation_ruby_ft_social_google' );
		delete_transient( 'innovation_ruby_ft_social_fan_pinterest' );
		delete_transient( 'innovation_ruby_ft_social_fan_instagram' );
		delete_transient( 'innovation_ruby_ft_social_fan_youtube' );
		delete_transient( 'innovation_ruby_ft_social_fan_soundcloud' );
		delete_transient( 'innovation_ruby_ft_social_fan_vimeo' );
		delete_transient( 'innovation_ruby_ft_social_fan_dribbble' );
		delete_transient( 'innovation_ruby_ft_social_fan_vk' );

		$instance['facebook_page']   = strip_tags( $new_instance['facebook_page'] );
		$instance['twitter_user']    = strip_tags( $new_instance['twitter_user'] );
		$instance['google_user']     = strip_tags( $new_instance['google_user'] );
		$instance['google_api']      = strip_tags( $new_instance['google_api'] );
		$instance['youtube_user']    = strip_tags( $new_instance['youtube_user'] );
		$instance['youtube_channel'] = strip_tags( $new_instance['youtube_channel'] );
		$instance['dribbble_user']   = strip_tags( $new_instance['dribbble_user'] );
		$instance['dribbble_token']  = strip_tags( $new_instance['dribbble_token'] );
		$instance['soundcloud_user'] = strip_tags( $new_instance['soundcloud_user'] );
		$instance['soundcloud_api']  = strip_tags( $new_instance['soundcloud_api'] );
		$instance['instagram_api']   = strip_tags( $new_instance['instagram_api'] );
		$instance['pinterest_user']  = strip_tags( $new_instance['pinterest_user'] );
		$instance['vimeo_user']      = strip_tags( $new_instance['vimeo_user'] );
		$instance['vk_user']         = strip_tags( $new_instance['vk_user'] );

		return $instance;
	}

	//form setting
	function form( $instance ) {

		$defaults = array(
			'youtube_user'    => '',
			'youtube_channel' => '',
			'dribbble_user'   => '',
			'dribbble_token'  => '',
			'twitter_user'    => '',
			'facebook_page'   => '',
			'google_user'     => '',
			'google_api'      => '',
			'soundcloud_user' => '',
			'soundcloud_api'  => '',
			'pinterest_user'  => '',
			'instagram_api'   => '',
			'vimeo_user'      => '',
			'vk_user'         => '',

		);
		$instance = wp_parse_args( (array) $instance, $defaults ); ?>
		<!--facebook -->
		<p>
			<label for="<?php echo esc_attr($this->get_field_id( 'facebook_page' )); ?>"><strong><?php esc_attr_e('Facebook Page Name:', 'innovation');?></strong></label>
			<input type="text" class="widefat"   id="<?php echo esc_attr($this->get_field_id( 'facebook_page' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'facebook_page' )); ?>" value="<?php echo esc_attr($instance['facebook_page']); ?>" />
		</p>
		<!--twitter -->
		<p>
			<label for="<?php echo esc_attr($this->get_field_id( 'twitter_user' )); ?>"><strong><?php esc_attr_e('Twitter Name:', 'innovation');?></strong></label>
			<input type="text"  class="widefat"  id="<?php echo esc_attr($this->get_field_id( 'twitter_user' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'twitter_user' )); ?>" value="<?php echo esc_attr($instance['twitter_user']); ?>"/>
		</p>
		<!-- google plus-->
		<p>
			<label for="<?php echo esc_attr($this->get_field_id( 'google_user' )); ?>"><strong><?php esc_attr_e('Goolge+ ID:','innovation');?></strong> </label>
			<input type="text" class="widefat" id="<?php echo esc_attr($this->get_field_id( 'google_user' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'google_user' )); ?>" value="<?php echo esc_attr($instance['google_user']); ?>"/>
		</p>
		<p>
			<label for="<?php echo esc_attr($this->get_field_id( 'google_api' )); ?>"><?php esc_attr_e('Google API Key:','innovation') ?> </label>
			<input type="text" class="widefat" id="<?php echo esc_attr($this->get_field_id( 'google_api' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'google_api' )); ?>" value="<?php echo esc_attr($instance['google_api']); ?>"/>
		</p>
		<p><a target="_blank" href="https://console.developers.google.com/projectselector/apis/library/"><?php esc_attr_e('Click here to get Google API Key.','innovation') ?></a></p>

		<!--pinterest -->
		<p>
			<label for="<?php echo esc_attr($this->get_field_id( 'pinterest_user' )); ?>"><strong><?php esc_attr_e('Pinterest User Name:','innovation');?></strong> </label>
			<input type="text" class="widefat" id="<?php echo esc_attr($this->get_field_id( 'pinterest_user' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'pinterest_user' )); ?>" value="<?php echo esc_attr($instance['pinterest_user']); ?>"/>
		</p>
		<!--instagram -->
		<p>
			<label for="<?php echo esc_attr($this->get_field_id( 'instagram_api' )); ?>"><strong><?php esc_attr_e('Instagram Access Token Key:','innovation') ?></strong> </label>
			<input type="text" class="widefat" id="<?php echo esc_attr($this->get_field_id( 'instagram_api' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'instagram_api' )); ?>" value="<?php echo esc_textarea($instance['instagram_api']); ?>"/>
		</p>
		<p><?php echo html_entity_decode( esc_html__( 'How to Create an app and generate your Instagram access token on: <a target="_blank" href="https://instagram.themeruby.com/">Instagram access token tutorial</a> website</p>', 'innovation' ) ); ?>
		<!--youtube -->
		<p>
			<label for="<?php echo esc_attr($this->get_field_id( 'youtube_user' )); ?>"><strong><?php esc_attr_e('Youtube User Name:', 'innovation');?></strong></label>
			<input type="text"  class="widefat" id="<?php echo esc_attr($this->get_field_id( 'youtube_user' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'youtube_user' )); ?>" value="<?php echo esc_attr($instance['youtube_user']); ?>"/>
		</p>
		<p>
			<label for="<?php echo esc_attr($this->get_field_id( 'youtube_channel' )); ?>"><strong><?php esc_attr_e('Youtube Channel ID:', 'innovation');?></strong></label>
			<input type="text"  class="widefat" id="<?php echo esc_attr($this->get_field_id( 'youtube_channel' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'youtube_channel' )); ?>" value="<?php echo esc_attr($instance['youtube_channel']); ?>"/>
		</p>
		<p><?php esc_attr_e('Use channel ID if you can not enough subscriber to create username for channel. Make sure leave blank user name when input channel ID.','innovation') ?></p>
		<!--sound cloud-->
		<p>
			<label for="<?php echo esc_attr($this->get_field_id( 'soundcloud_user' )); ?>"><strong><?php esc_attr_e('SoundCloud User Name:','innovation');?></strong> </label>
			<input type="text" class="widefat" id="<?php echo esc_attr($this->get_field_id( 'soundcloud_user' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'soundcloud_user' )); ?>" value="<?php echo esc_attr($instance['soundcloud_user']); ?>"/>
		</p>
		<p>
			<label for="<?php echo esc_attr($this->get_field_id( 'soundcloud_api' )); ?>"><?php esc_attr_e('Soundcloud API Key(Client ID) :','innovation') ?> </label>
			<input type="text" class="widefat" id="<?php echo esc_attr($this->get_field_id( 'soundcloud_api' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'soundcloud_api' )); ?>" value="<?php echo esc_attr($instance['soundcloud_api']); ?>"/>
		</p>
		<p><a target="_blank" href="https://soundcloud.com/you/apps/"><?php esc_attr_e('Generate your soundcloud app','innovation') ?></a></p>
		<!--vimeo -->
		<p>
			<label for="<?php echo esc_attr($this->get_field_id( 'vimeo_user' )); ?>"><strong><?php esc_attr_e('Vimeo User Name:','innovation');?></strong> </label>
			<input type="text" class="widefat" id="<?php echo esc_attr($this->get_field_id( 'vimeo_user' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'vimeo_user' )); ?>" value="<?php echo esc_attr($instance['vimeo_user']); ?>"/>
		</p>
		<!--dribbble -->
		<p>
			<label for="<?php echo esc_attr($this->get_field_id( 'dribbble_user' )); ?>"><strong><?php esc_attr_e('Dribbble User Name:', 'innovation');?></strong></label>
			<input type="text"  class="widefat" id="<?php echo esc_attr($this->get_field_id( 'dribbble_user' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'dribbble_user' )); ?>" value="<?php echo esc_attr($instance['dribbble_user']); ?>" />
		</p>
		<p>
			<label for="<?php echo esc_attr($this->get_field_id( 'dribbble_token' )); ?>"><strong><?php esc_attr_e('Dribbble Token (Client Access Token):', 'innovation');?></strong></label>
			<input type="text"  class="widefat" id="<?php echo esc_attr($this->get_field_id( 'dribbble_token' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'dribbble_token' )); ?>" value="<?php echo esc_attr($instance['dribbble_token']); ?>" />
		</p>
		<p><a target="_blank" href="https://dribbble.com/account/applications/new"><?php esc_attr_e('Generate your dribbble app','innovation') ?></a></p>
		<p>
			<label for="<?php echo esc_attr($this->get_field_id( 'vk_user' )); ?>"><strong><?php esc_attr_e('VK User/ID:','innovation');?></strong> </label>
			<input type="text" class="widefat" id="<?php echo esc_attr($this->get_field_id( 'vk_user' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'vk_user' )); ?>" value="<?php echo esc_attr($instance['vk_user']); ?>"/>
		</p>
	<?php
	}
} 