<?php
/**
 * ReduxFramework Config File
 * For full documentation, please visit: http://docs.reduxframework.com/
 */

//load onclick
if ( class_exists( 'innovation_ruby_one_lick_to_import' ) ) {
	add_action( 'redux/extensions/innovation_ruby_theme_options/before', array(
			'innovation_ruby_one_lick_to_import',
			'innovation_ruby_register_extension_loader'
		), 0 );
}

require_once $ruby_template_directory . '/theme_options/ruby_imported.php';

if ( ! class_exists( 'Redux' ) ) {
	return false;
}

/**-------------------------------------------------------------------------------------------------------------------------
 * remove demo link
 */
if ( ! function_exists( 'innovation_ruby_redux_remove_demo_link' ) ) {
	function innovation_ruby_redux_remove_demo_link() {
		if ( class_exists( 'ReduxFrameworkPlugin' ) ) {
			remove_filter( 'plugin_row_meta', array(
				ReduxFrameworkPlugin::get_instance(),
				'plugin_metalinks'
			), null, 2 );
		}
		if ( class_exists( 'ReduxFrameworkPlugin' ) ) {
			remove_action( 'admin_notices', array( ReduxFrameworkPlugin::get_instance(), 'admin_notices' ) );
		}
	}

	add_action( 'init', 'innovation_ruby_redux_remove_demo_link', 1 );
}

//override textarea
if ( ! function_exists( 'overload_textarea_field_path' ) ) {
	add_filter( 'redux/innovation_ruby_theme_options/field/class/textarea', 'overload_textarea_field_path' );
	function overload_textarea_field_path( $field ) {
		return get_template_directory() . '/theme_options/redux_field_script.php';
	}
}


//including theme options panels
$ruby_template_directory = get_template_directory();

require_once $ruby_template_directory . '/theme_options/option_panels/panel_general.php';
require_once $ruby_template_directory . '/theme_options/option_panels/panel_header.php';
require_once $ruby_template_directory . '/theme_options/option_panels/panel_navigation.php';
require_once $ruby_template_directory . '/theme_options/option_panels/panel_sidebar.php';
require_once $ruby_template_directory . '/theme_options/option_panels/panel_footer.php';
require_once $ruby_template_directory . '/theme_options/option_panels/panel_featured.php';
require_once $ruby_template_directory . '/theme_options/option_panels/panel_design.php';
require_once $ruby_template_directory . '/theme_options/option_panels/panel_mic.php';
require_once $ruby_template_directory . '/theme_options/option_panels/panel_social.php';
require_once $ruby_template_directory . '/theme_options/option_panels/panel_typography.php';
require_once $ruby_template_directory . '/theme_options/option_panels/panel_typography_body.php';
require_once $ruby_template_directory . '/theme_options/option_panels/panel_typography_post.php';
require_once $ruby_template_directory . '/theme_options/option_panels/panel_typography_nav.php';
require_once $ruby_template_directory . '/theme_options/option_panels/panel_color.php';
require_once $ruby_template_directory . '/theme_options/option_panels/panel_home.php';
require_once $ruby_template_directory . '/theme_options/option_panels/panel_single.php';
require_once $ruby_template_directory . '/theme_options/option_panels/panel_category.php';
require_once $ruby_template_directory . '/theme_options/option_panels/panel_page.php';
require_once $ruby_template_directory . '/theme_options/option_panels/panel_woocommerce.php';

//including theme options style
require_once $ruby_template_directory . '/theme_options/ruby_redux_style.php';


// This is theme option name where all the Theme data is stored.
$ruby_theme    = wp_get_theme();
$ruby_opt_name = 'innovation_ruby_theme_options';

$ruby_args = array(
	'opt_name'             => $ruby_opt_name,
	'display_name'         => $ruby_theme->get( 'Name' ),
	'display_version'      => $ruby_theme->get( 'Version' ),
	'menu_type'            => 'menu',
	'allow_sub_menu'       => true,
	'menu_title'           => esc_html__( 'Innovation', 'innovation' ),
	'page_title'           => esc_html__( 'Innovation Options', 'innovation' ),
	'google_api_key'       => '',
	'google_update_weekly' => false,
	'async_typography'     => false,
	'admin_bar'            => true,
	'admin_bar_icon'       => 'dashicons-admin-generic',
	'admin_bar_priority'   => 50,
	'global_variable'      => $ruby_opt_name,
	'dev_mode'             => false,
	'update_notice'        => false,
	'customizer'           => true,
	'page_priority'        => 54,
	'page_parent'          => 'themes.php',
	'page_permissions'     => 'manage_options',
	'menu_icon'            => '',
	'last_tab'             => '',
	'page_icon'            => 'icon-themes',
	'page_slug'            => '',
	'save_defaults'        => true,
	'default_show'         => false,
	'default_mark'         => '',
	'show_import_export'   => true,
	'transient_time'       => 60 * MINUTE_IN_SECONDS,
	'use_cdn'              => true,
	'output'               => true,
	'output_tag'           => true,
	'disable_tracking'     => true,
	'database'             => '',
	'system_info'          => false,
	// HINTS
	'hints'                => array(
		'icon'          => 'el el-question-sign',
		'icon_position' => 'right',
		'icon_color'    => 'lightgray',
		'icon_size'     => 'normal',
		'tip_style'     => array(
			'color'   => 'light',
			'shadow'  => true,
			'rounded' => false,
			'style'   => '',
		),
		'tip_position'  => array(
			'my' => 'top left',
			'at' => 'bottom right',
		),
		'tip_effect'    => array(
			'show' => array(
				'effect'   => 'slide',
				'duration' => '400',
				'event'    => 'mouseover',
			),
			'hide' => array(
				'effect'   => 'slide',
				'duration' => '400',
				'event'    => 'click mouseleave',
			),
		),
	)
);


//Set arguments for framework
Redux::setArgs( $ruby_opt_name, $ruby_args );

// -> START THEME SETTINGS

// general
Redux::setSection( $ruby_opt_name, innovation_ruby_theme_options_general() );

//block design
Redux::setSection( $ruby_opt_name, innovation_ruby_theme_options_block_design() );

//navigation
Redux::setSection( $ruby_opt_name, innovation_ruby_theme_options_navigation() );

//header
Redux::setSection( $ruby_opt_name, innovation_ruby_theme_options_header() );

//sidebar
Redux::setSection( $ruby_opt_name, innovation_ruby_theme_options_sidebar() );

//footer
Redux::setSection( $ruby_opt_name, innovation_ruby_theme_options_footer() );

//featured post
Redux::setSection( $ruby_opt_name, innovation_ruby_theme_options_featured() );

//home layout
Redux::setSection( $ruby_opt_name, innovation_ruby_theme_options_home() );

//single configs
Redux::setSection( $ruby_opt_name, innovation_ruby_theme_options_single() );

//category configs
$ruby_all_categories = get_categories( array( 'hide_empty' => 0 ) );

Redux::setSection( $ruby_opt_name, innovation_ruby_theme_options_category() );
foreach ( $ruby_all_categories as $category ) {
	Redux::setSection( $ruby_opt_name, innovation_ruby_theme_options_one_cate( $category->term_id, esc_attr( $category->name ) ) );
}

//Pages
Redux::setSection( $ruby_opt_name, innovation_ruby_theme_options_page() );
Redux::setSection( $ruby_opt_name, innovation_ruby_default_page_config() );
Redux::setSection( $ruby_opt_name, innovation_ruby_author_page_config() );
Redux::setSection( $ruby_opt_name, innovation_ruby_search_page_config() );
Redux::setSection( $ruby_opt_name, innovation_ruby_archive_page_config() );
Redux::setSection( $ruby_opt_name, innovation_ruby_author_team_page_config() );


//social configs
Redux::setSection( $ruby_opt_name, innovation_ruby_theme_options_social() );
Redux::setSection( $ruby_opt_name, innovation_ruby_theme_options_share_post() );
Redux::setSection( $ruby_opt_name, innovation_ruby_theme_options_site_social() );

//typography configs
Redux::setSection( $ruby_opt_name, innovation_ruby_theme_options_typography() );
Redux::setSection( $ruby_opt_name, innovation_ruby_theme_options_typography_body() );
Redux::setSection( $ruby_opt_name, innovation_ruby_theme_options_typography_post() );
Redux::setSection( $ruby_opt_name, innovation_ruby_theme_options_typography_nav() );

//color configs
Redux::setSection( $ruby_opt_name, innovation_ruby_theme_options_color() );

//woocommerce
if ( class_exists( 'Woocommerce' ) ) {
	Redux::setSection( $ruby_opt_name, innovation_ruby_theme_options_woocommerce() );
}

//custom script configs
Redux::setSection( $ruby_opt_name, innovation_ruby_theme_options_custom_script() );

//import+export configs
Redux::setSection( $ruby_opt_name, innovation_ruby_theme_options_import_export() );
