<?php

/**-------------------------------------------------------------------------------------------------------------------------
 * @param $demo_active_import
 * setup menu & sidebar
 */
if ( ! function_exists( 'innovation_ruby_imported_demo' ) ) {
	function innovation_ruby_imported_demo( $demo_active_import ) {

		reset( $demo_active_import );
		$current_key = key( $demo_active_import );

		$ruby_menu_array = array(
			'default',
			'fashion',
			'travel',
			'lifestyle',
			'sport',
			'entertainment',
			'personal',
			'recipe',
			'gadgets',
			'news_tech',
			'news_fashion'
		);

		if ( isset( $demo_active_import[ $current_key ]['directory'] ) && ! empty( $demo_active_import[ $current_key ]['directory'] ) && in_array( $demo_active_import[ $current_key ]['directory'], $ruby_menu_array ) ) {
			$main_menu = get_term_by( 'name', 'Main Menu', 'nav_menu' );

			if ( isset( $main_menu->term_id ) ) {
				set_theme_mod( 'nav_menu_locations', array(
						'innovation_ruby_main_navigation' => $main_menu->term_id,
					)
				);
			}
		}


		/************************************************************************
		 * Set HomePage
		 *************************************************************************/

		$ruby_home_pages = array(
			'default'       => '',
			'fashion'       => '',
			'travel'        => '',
			'lifestyle'     => '',
			'sport'         => '',
			'entertainment' => '',
			'personal'      => '',
			'recipe'        => '',
			'gadgets'       => '',
			'news_tech'     => 'Home Page',
			'news_fashion'  => 'Home Page',
		);

		if ( isset( $demo_active_import[ $current_key ]['directory'] ) && ! empty( $demo_active_import[ $current_key ]['directory'] ) && array_key_exists( $demo_active_import[ $current_key ]['directory'], $ruby_home_pages ) ) {

			if ( ! empty( $ruby_home_pages[ $demo_active_import[ $current_key ]['directory'] ] ) ) {
				$page = get_page_by_title( $ruby_home_pages[ $demo_active_import[ $current_key ]['directory'] ] );
				if ( ! empty( $page->ID ) ) {
					update_option( 'page_on_front', $page->ID );
					update_option( 'show_on_front', 'page' );
				}
			} else {
				update_option( 'page_on_front', 0 );
				update_option( 'show_on_front', 'posts' );
			}
		}
	}

	//setup menu
	add_action( 'wbc_importer_after_content_import', 'innovation_ruby_imported_demo', 10, 2 );
}


if ( ! function_exists( 'innovation_ruby_remove_default_widget' ) ) {
	function innovation_ruby_remove_default_widget() {

		//clear widgets
		$sidebars_widgets['innovation_ruby_sidebar_off_canvas']       = array();
		$sidebars_widgets['innovation_ruby_sidebar_default']          = array();
		$sidebars_widgets['innovation_ruby_home_column_1']            = array();
		$sidebars_widgets['innovation_ruby_home_column_2']            = array();
		$sidebars_widgets['innovation_ruby_home_column_3']            = array();
		$sidebars_widgets['innovation_ruby_sidebar_footer_fullwidth'] = array();
		$sidebars_widgets['innovation_ruby_sidebar_footer_1']         = array();
		$sidebars_widgets['innovation_ruby_sidebar_footer_2']         = array();
		$sidebars_widgets['innovation_ruby_sidebar_footer_3']         = array();
		$sidebars_widgets['innovation_ruby_sidebar_footer_4']         = array();

		//clear social cache
		delete_transient( 'innovation_ruby_footer_instagram_cache' );
		delete_transient( 'innovation_ruby_sb_instagram_cache' );

		update_option( 'sidebars_widgets', $sidebars_widgets );

		//register home sidebar
		register_sidebar(
			array(
				'name'          => 'HomeSb1',
				'id'            => 'innovation_ruby_sidebar_multi_homesb1',
				'before_widget' => '<aside class="widget %2$s">',
				'after_widget'  => '</aside>',
				'before_title'  => '<div class="widget-title"><h3>',
				'after_title'   => '</h3></div>',
			)
		);
		register_sidebar(
			array(
				'name'          => 'HomeSb2',
				'id'            => 'innovation_ruby_sidebar_multi_homesb2',
				'before_widget' => '<aside class="widget %2$s">',
				'after_widget'  => '</aside>',
				'before_title'  => '<div class="widget-title"><h3>',
				'after_title'   => '</h3></div>',
			)
		);

	}

	//remove widget
	add_action( 'wbc_importer_before_widget_import', 'innovation_ruby_remove_default_widget', 10, 2 );
}
