<?php
/**
 * Class innovation_ruby_thumbnail
 * this file handle thumbnail for theme
 */
if ( ! class_exists( 'innovation_ruby_thumbnail' ) ) {
	class innovation_ruby_thumbnail {

		static function render( $size, $class = '', $link_to_attachment = false ) {

			$ruby_enable_thumb_holder = innovation_ruby_util::get_theme_option( 'thumb_holder' );
			$ruby_post_id             = get_the_ID();

			//create class
			$ruby_class   = array();
			$ruby_class[] = $class;
			$ruby_class[] = 'post-thumb';
			$ruby_class[] = 'is-image';
			if ( ! empty( $ruby_enable_thumb_holder ) ) {
				$ruby_class[] = 'ruby-holder';
			}
			$ruby_class = implode( ' ', $ruby_class );

			//render
			$str = '';
			$str .= '<div class="' . $ruby_class . '">';

			if ( has_post_thumbnail() ) {
				$featured_title      = get_the_title( get_post_thumbnail_id( $ruby_post_id ) );
				$featured_attachment = wp_get_attachment_image_src( get_post_thumbnail_id( $ruby_post_id ), $size );

				if ( ! empty( $featured_attachment[0] ) ) {
					$width  = 0;
					$height = 0;

					//check
					if ( ! empty( $featured_attachment[1] ) ) {
						$width = 'width="' . $featured_attachment[1] . '"';
					}
					if ( ! empty( $featured_attachment[2] ) ) {
						$height = 'height="' . $featured_attachment[2] . '"';
					}
					//render
					if ( false === $link_to_attachment ) {
						$str .= '<a href="' . get_permalink() . '" title="' . esc_attr( strip_tags( get_the_title() ) ) . '" rel="bookmark">';
						$str .= '<img ' . $width . ' ' . $height . ' src="' . $featured_attachment[0] . '"  alt="' . $featured_title . '"/>';
						$str .= '</a>';
					} else {
						$ruby_full_image_attachment = wp_get_attachment_image_src( get_post_thumbnail_id( $ruby_post_id ), 'full' );
						$str .= '<a href="' . $ruby_full_image_attachment[0] . '" title="' . esc_attr( strip_tags( get_the_title() ) ) . '" rel="bookmark">';
						$str .= '<img ' . $width . ' ' . $height . ' src="' . $featured_attachment[0] . '"  alt="' . $featured_title . '"/>';
						$str .= '</a>';
					}

				} else {
					$str .= self::render_block_no_thumb( $size );
				}
			} else {
				$str .= self::render_block_no_thumb( $size );
			}

			$str .= '</div><!--#thumb wrap-->';

			return $str;
		}


		/**-------------------------------------------------------------------------------------------------------------------------
		 * @param      $size
		 *
		 * @return string
		 * render no thumb
		 */
		static function render_block_no_thumb( $size ) {

			//check attachment page
			if ( is_attachment() ) {
				return false;
			}

			$str = '';
			$str .= '<div class="post-no-thumb">';
			$str .= self::render_no_thumb_image( $size );
			$str .= '</div>';

			return $str;
		}


		/**-------------------------------------------------------------------------------------------------------------------------
		 * @param $size
		 *
		 * @return string
		 * render no thumb image
		 */
		static function render_no_thumb_image( $size ) {
			$str = '';
			$url = get_template_directory_uri() . '/assets/images/no-thumb-' . $size . '.jpg';
			$str .= '<img src="' . $url . '" alt="no thumb"/>';

			return $str;
		}


		/**-------------------------------------------------------------------------------------------------------------------------
		 * render feat credit text
		 */
		static function render_feat_credit() {
			$ruby_credit_text = get_post_meta( get_the_ID(), 'innovation_ruby_credit_text', true );
			if ( ! empty( $ruby_credit_text ) ) {
				return '<span class="thumb-caption">' . esc_html( $ruby_credit_text ) . '</span>';
			} else {
				return false;
			}
		}


		/**-------------------------------------------------------------------------------------------------------------------------
		 * @return string
		 * render pattern
		 */
		static function render_pattern() {
			//thumb pattern
			$ruby_enable_thumb_pattern = innovation_ruby_util::get_theme_option( 'thumb_pattern' );

			if ( ! empty( $ruby_enable_thumb_pattern ) ) {
				return '<div class="thumb-pattern"></div><!--#thumb pattern-->';
			} else {
				return false;
			}
		}

	}
}