<?php
//get twitter user
$twitter_user = get_the_author_meta( 'ruby_twitter' );
if ( empty( $twitter_user ) ) {
	$twitter_user = innovation_ruby_util::get_theme_option( 'innovation_ruby_twitter' );
}
if ( ! empty( $twitter_user ) ) {
	$pos = strpos( $twitter_user, 'twitter.com/' );
	if ( false === $pos ) {
		$twitter_user = get_bloginfo( 'name' );
	} else {
		$twitter_user = substr( $twitter_user, intval( $pos ) + 12 );
		$twitter_user = str_replace( '/', '', $twitter_user );
	}
} else {
	$twitter_user = get_bloginfo( 'name' );
}

$ruby_html = 'http';
if ( is_ssl() ) {
	$ruby_html = 'https';
}
?>

<div class="like-box-wrap">
	<ul class="like-box-inner">
		<li class="like-el">
			<a href="https://twitter.com/share" class="twitter-share-button" data-url="<?php echo get_permalink() ?>"
			   data-text="<?php echo esc_attr( strip_tags( get_the_title() ) ) ?>"
			   data-via="<?php echo urlencode( $twitter_user ); ?>"
			   data-lang="en"></a>
			<script>!function(d, s, id) {
					var js, fjs = d.getElementsByTagName(s)[0];
					if (!d.getElementById(id)) {
						js = d.createElement(s);
						js.id = id;
						js.src = "//platform.twitter.com/widgets.js";
						fjs.parentNode.insertBefore(js, fjs);
					}
				}(document, "script", "twitter-wjs");
			</script>
		</li>
		<li class="like-el">
			<iframe
				src="<?php echo $ruby_html; ?>://www.facebook.com/plugins/like.php?href=<?php echo get_permalink() ?>&amp;layout=button_count&amp;show_faces=false&amp;width=105&amp;action=like&amp;colorscheme=light&amp;height=21"
				style="border:none; overflow:hidden; width:105px; height:21px; background-color:transparent;"></iframe>
		</li>
		<li class="like-el">
			<div class="g-plusone" data-size="medium" data-href="<?php echo get_permalink() ?>"></div>
			<script type="text/javascript">
				(function() {
					var po = document.createElement("script");
					po.type = "text/javascript";
					po.async = true;
					po.src = "https://apis.google.com/js/plusone.js";
					var s = document.getElementsByTagName("script")[0];
					s.parentNode.insertBefore(po, s);
				})();
			</script>
		</li>
	</ul>
</div>
