<?php

/**-------------------------------------------------------------------------------------------------------------------------
 * Class innovation_ruby_layout
 * This file render layout for page
 */

if ( ! class_exists( 'innovation_ruby_blog_layout' ) ) {
	class innovation_ruby_blog_layout {

		//render
		static function render( $ruby_options ) {

			//check page layout
			if ( empty( $ruby_options['page_layout'] ) ) {
				$ruby_options['page_layout'] = 'classic-layout';
			}

			//create class
			$class   = array();
			$class[] = 'page-layout-wrap';
			$class[] = 'is-' . esc_attr( $ruby_options['page_layout'] );
			if ( ! empty( $ruby_options['big_first'] ) ) {
				$class[] = 'has-big-first';
			} else {
				$class[] = 'no-big-first';
			}
			$class = implode( ' ', $class );

			//render
			if ( have_posts() ) {

				innovation_ruby_template_part::open_page_wrap( $class, $ruby_options['sidebar_position'] );

				switch ( $ruby_options['page_layout'] ) {
					case 'list-sgrid-layout' :
						innovation_ruby_list_sgrid_layout::render( $ruby_options );
						break;
					case 'list-grid-layout' :
						innovation_ruby_list_grid_layout::render( $ruby_options );
						break;
					case 'classic-grid-layout' :
						innovation_ruby_classic_grid_layout::render( $ruby_options );
						break;
					case 'classic-sgrid-layout' :
						innovation_ruby_classic_sgrid_layout::render( $ruby_options );
						break;
					case 'sgrid-layout' :
						innovation_ruby_sgrid_layout::render( $ruby_options );
						break;
					case 'grid-layout' :
						innovation_ruby_grid_layout::render( $ruby_options );
						break;
					case 'list-layout' :
						innovation_ruby_list_layout::render( $ruby_options );
						break;
					default :
						innovation_ruby_classic_layout::render( $ruby_options );
						break;
				}

				//render sidebar
				if ( ! empty( $ruby_options['sidebar_position'] ) && 'none' != $ruby_options['sidebar_position'] ) {
					innovation_ruby_template_part::sidebar( $ruby_options['sidebar_name'] );
				}

				innovation_ruby_template_part::close_page_wrap();
			} else {
				get_template_part( 'templates/section', 'no_content' );
			}
		}
	}
}