<?php
/**
 * this file config meta boxes for theme
 */
// Re-define meta box path and URL
$ruby_template_directory = get_template_directory();

require_once $ruby_template_directory . '/metaboxes/meta_box/meta-box.php';

//including config file
require_once $ruby_template_directory . '/metaboxes/metabox_panels/panel_audio.php';
require_once $ruby_template_directory . '/metaboxes/metabox_panels/panel_gallery.php';
require_once $ruby_template_directory . '/metaboxes/metabox_panels/panel_video.php';
require_once $ruby_template_directory . '/metaboxes/metabox_panels/panel_post.php';
require_once $ruby_template_directory . '/metaboxes/metabox_panels/panel_page.php';
require_once $ruby_template_directory . '/metaboxes/metabox_panels/panel_review.php';
require_once $ruby_template_directory . '/metaboxes/metabox_panels/panel_sidebar.php';
require_once $ruby_template_directory . '/metaboxes/metabox_panels/panel_comment.php';
require_once $ruby_template_directory . '/metaboxes/metabox_panels/panel_credit.php';
require_once $ruby_template_directory . '/metaboxes/metabox_panels/panel_composer.php';

if ( ! function_exists( 'innovation_ruby_theme_meta_boxes_config' ) ) {

	//initialize the meta-box class
	add_filter( 'rwmb_meta_boxes', 'innovation_ruby_theme_meta_boxes_config' );

	/**-------------------------------------------------------------------------------------------------------------------------
	 * @return array
	 * meta box config
	 */
	function innovation_ruby_theme_meta_boxes_config() {

		//check
		if ( ! class_exists( 'RW_Meta_Box' ) ) {
			return false;
		}

		$ruby_meta_boxes = array();

		//single options
		$ruby_meta_boxes[] = innovation_ruby_metabox_single_post();
		$ruby_meta_boxes[] = innovation_ruby_metabox_single_page();
		$ruby_meta_boxes[] = innovation_ruby_metabox_composer();

		//featured credit text
		$ruby_meta_boxes[] = innovation_ruby_metabox_credit_text();

		//single post review
		$ruby_meta_boxes[] = innovation_ruby_metabox_post_review();

		//media post
		$ruby_meta_boxes[] = innovation_ruby_metabox_post_audio();
		$ruby_meta_boxes[] = innovation_ruby_metabox_post_video();
		$ruby_meta_boxes[] = innovation_ruby_metabox_post_gallery();

		//mic
		$ruby_meta_boxes[] = innovation_ruby_metabox_sidebar();
		$ruby_meta_boxes[] = innovation_ruby_metabox_comment_box();

		return $ruby_meta_boxes;
	}
};




