<?php
if ( ! class_exists( 'innovation_ruby_social_share_post' ) ) {
	class innovation_ruby_social_share_post {

		/**-------------------------------------------------------------------------------------------------------------------------
		 * @param string $ruby_class
		 *
		 * @return string
		 * render social share post
		 */
		static function render( $ruby_class = '' ) {

			//create class
			$ruby_social_color = innovation_ruby_util::get_theme_option( 'social_icon_color' );
			$class             = array();
			$class[]           = $ruby_class;
			$class[]           = 'box-share';
			if ( ! empty( $ruby_social_color ) ) {
				$class[] = 'is-color-icon';
			}
			$class = implode( ' ', $class );

			//get data
			$enable_facebook    = innovation_ruby_util::get_theme_option( 'share_to_facebook' );
			$enable_twitter     = innovation_ruby_util::get_theme_option( 'share_to_twitter' );
			$enable_google_plus = innovation_ruby_util::get_theme_option( 'share_to_google_plus' );
			$enable_linkedin    = innovation_ruby_util::get_theme_option( 'share_to_linkedin' );
			$enable_pinterest   = innovation_ruby_util::get_theme_option( 'share_to_pinterest' );
			$enable_tumblr      = innovation_ruby_util::get_theme_option( 'share_to_tumblr' );
			$enable_vk          = innovation_ruby_util::get_theme_option( 'share_to_vk' );
			$enable_reddit      = innovation_ruby_util::get_theme_option( 'share_to_reddit' );
			$enable_email       = innovation_ruby_util::get_theme_option( 'share_to_email' );

			//get twitter user
			$twitter_user = get_the_author_meta( 'ruby_twitter' );
			if ( empty( $twitter_user ) ) {
				$twitter_user = innovation_ruby_util::get_theme_option( 'innovation_ruby_twitter' );
			}
			if ( ! empty( $twitter_user ) ) {
				$pos = strpos( $twitter_user, 'twitter.com/' );
				if ( false === $pos ) {
					$twitter_user = get_bloginfo( 'name' );
				} else {
					$twitter_user = substr( $twitter_user, intval( $pos ) + 12 );
					$twitter_user = str_replace( '/', '', $twitter_user );
				}
			} else {
				$twitter_user = get_bloginfo( 'name' );
			}

			$ruby_html = 'http';
			if ( is_ssl() ) {
				$ruby_html = 'https';
			}

			$image = wp_get_attachment_image_src( get_post_thumbnail_id( get_the_ID() ), 'innovation_ruby_840x500' );
			if ( is_plugin_active( 'wordpress-seo/wp-seo.php' ) and get_post_meta( get_the_ID(), '_yoast_wpseo_metadesc', true ) != '' ) {
				$pinterest_description = get_post_meta( get_the_ID(), '_yoast_wpseo_metadesc', true );
			} else {
				$pinterest_description = htmlspecialchars( urlencode( html_entity_decode( get_the_title(), ENT_COMPAT, 'UTF-8' ) ), ENT_COMPAT, 'UTF-8' );
			}

			//render
			$str = '';
			$str .= '<div class="' . $class . '">';
			$str .= '<ul class="box-share-inner">';
			//facebook
			if ( ! empty( $enable_facebook ) ) {
				$str .= '<li class="box-share-el facebook-button">';
				$str .= '<a href="' . $ruby_html . '://www.facebook.com/sharer.php?u=' . urlencode( get_permalink() ) . '" onclick="window.open(this.href, \'mywin\',\'left=50,top=50,width=600,height=350,toolbar=0\'); return false;"><i class="fa fa-facebook color-facebook"></i><span class="social-text">facebook</span></a>';
				$str .= '</li>';
			}
			//twitter
			if ( ! empty( $enable_twitter ) ) {
				$str .= '<li class="box-share-el twitter-button">';
				$str .= '<a class="share-to-social" href="https://twitter.com/intent/tweet?text=' . htmlspecialchars( urlencode( html_entity_decode( get_the_title(), ENT_COMPAT, 'UTF-8' ) ), ENT_COMPAT, 'UTF-8' ) . '&amp;url=' . urlencode( get_permalink() ) . '&amp;via=' . urlencode( $twitter_user ) . '" onclick="window.open(this.href, \'mywin\',\'left=50,top=50,width=600,height=350,toolbar=0\'); return false;"><i class="fa fa-twitter color-twitter"></i><span class="social-text">Twitter</span></a>';
				$str .= '</li>';
			}
			//google plus
			if ( ! empty( $enable_google_plus ) ) {
				$str .= '<li class="box-share-el google-button">';
				$str .= ' <a href="' . $ruby_html . '://plus.google.com/share?url=' . urlencode( get_permalink() ) . '" onclick="window.open(this.href, \'mywin\',\'left=50,top=50,width=600,height=350,toolbar=0\'); return false;"><i class="fa fa-google color-google"></i><span class="social-text">Google +</span></a>';
				$str .= '</li>';
			}
			//pinterest
			if ( ! empty( $enable_pinterest ) ) {
				$str .= '<li class="box-share-el pinterest-button">';
				$str .= '<a href="' . $ruby_html . '://pinterest.com/pin/create/button/?url=' . urlencode( get_permalink() ) . '&amp;media=' . ( ! empty( $image[0] ) ? $image[0] : '' ) . '&description=' . $pinterest_description . '" onclick="window.open(this.href, \'mywin\',\'left=50,top=50,width=600,height=350,toolbar=0\'); return false;"><i class="fa fa-pinterest"></i><span class="social-text">Pinterest</span></a>';
				$str .= '</li>';
			}
			//linkedin
			if ( ! empty ( $enable_linkedin ) ) {
				$str .= '<li class="box-share-el linkedin-button">';
				$str .= '<a href="' . $ruby_html . '://linkedin.com/shareArticle?mini=true&amp;url=' . urlencode( get_permalink() ) . '&amp;title=' . htmlspecialchars( urlencode( html_entity_decode( get_the_title(), ENT_COMPAT, 'UTF-8' ) ), ENT_COMPAT, 'UTF-8' ) . '" onclick="window.open(this.href, \'mywin\',\'left=50,top=50,width=600,height=350,toolbar=0\'); return false;"><i class="fa fa-linkedin"></i><span class="social-text">LinkedIn</span></a>';
				$str .= '</li>';
			}
			//tumblr
			if ( ! empty( $enable_tumblr ) ) {
				$str .= '<li class="box-share-el tumblr-button">';
				$str .= ' <a href="' . $ruby_html . '://www.tumblr.com/share/link?url=' . urlencode( get_permalink() ) . '&amp;name=' . htmlspecialchars( urlencode( html_entity_decode( get_the_title(), ENT_COMPAT, 'UTF-8' ) ), ENT_COMPAT, 'UTF-8' ) . '&amp;description=' . htmlspecialchars( urlencode( html_entity_decode( get_the_title(), ENT_COMPAT, 'UTF-8' ) ), ENT_COMPAT, 'UTF-8' ) . '" onclick="window.open(this.href, \'mywin\',\'left=50,top=50,width=600,height=350,toolbar=0\'); return false;"><i class="fa fa-tumblr"></i><span class="social-text">Tumblr</span></a>';
				$str .= '</li>';
			}
			//vk
			if ( ! empty( $enable_vk ) ) {
				$str .= '<li class="box-share-el vk-button">';
				$str .= '<a href="' . $ruby_html . '://vkontakte.ru/share.php?url=' . urldecode( get_permalink() ) . '" onclick="window.open(this.href, \'mywin\',\'left=50,top=50,width=600,height=350,toolbar=0\'); return false;"><i class="fa fa-vk"></i><span class="social-text">VKontakte</span></a>';
				$str .= '</li>';
			}

			//reddit
			if ( ! empty( $enable_reddit ) ) {
				$str .= '<li class="box-share-el reddit-button">';
				$str .= '<a href="' . $ruby_html . '://www.reddit.com/submit?url=' . urlencode( get_permalink() ) . '&title=' . htmlspecialchars( urlencode( html_entity_decode( get_the_title(), ENT_COMPAT, 'UTF-8' ) ), ENT_COMPAT, 'UTF-8' ) . '" onclick="window.open(this.href, \'mywin\',\'left=50,top=50,width=600,height=350,toolbar=0\'); return false;"><i class="fa fa-reddit"></i><span class="social-text">Reddit</span></a>';
				$str .= '</li>';
			}
			//email
			if ( ! empty( $enable_email ) ) {
				$str .= '<li class="box-share-el email-button">';
				$str .= '<a href="mailto:?subject=' . htmlspecialchars( urlencode( html_entity_decode( get_the_title(), ENT_COMPAT, 'UTF-8' ) ), ENT_COMPAT, 'UTF-8' ) . '&BODY=' . esc_attr__( 'I found this article interesting and thought of sharing it with you. Check it out:', 'innovation' ) . urlencode( get_permalink() ) . '"><i class="fa fa-envelope-o"></i><span class="social-text">Email</span></a>';
				$str .= '</li>';
			}

			$str .= '</ul>';
			$str .= '</div>';

			return $str;
		}

		/**-------------------------------------------------------------------------------------------------------------------------
		 * @return string
		 * render post share bar social
		 */
		static function render_post_share_bar() {

			//get twitter user
			$twitter_user = get_the_author_meta( 'ruby_twitter' );
			if ( empty( $twitter_user ) ) {
				$twitter_user = innovation_ruby_util::get_theme_option( 'innovation_ruby_twitter' );
			}
			if ( ! empty( $twitter_user ) ) {
				$pos = strpos( $twitter_user, 'twitter.com/' );
				if ( false === $pos ) {
					$twitter_user = get_bloginfo( 'name' );
				} else {
					$twitter_user = substr( $twitter_user, intval( $pos ) + 12 );
					$twitter_user = str_replace( '/', '', $twitter_user );
				}
			} else {
				$twitter_user = get_bloginfo( 'name' );
			}

			$ruby_html = 'http';
			if ( is_ssl() ) {
				$ruby_html = 'https';
			}

			$enable_facebook    = innovation_ruby_util::get_theme_option( 'share_to_facebook' );
			$enable_twitter     = innovation_ruby_util::get_theme_option( 'share_to_twitter' );
			$enable_google_plus = innovation_ruby_util::get_theme_option( 'share_to_google_plus' );
			$enable_linkedin    = innovation_ruby_util::get_theme_option( 'share_to_linkedin' );
			$enable_pinterest   = innovation_ruby_util::get_theme_option( 'share_to_pinterest' );
			$enable_tumblr      = innovation_ruby_util::get_theme_option( 'share_to_tumblr' );
			$enable_vk          = innovation_ruby_util::get_theme_option( 'share_to_vk' );
			$enable_reddit      = innovation_ruby_util::get_theme_option( 'share_to_reddit' );
			$enable_email       = innovation_ruby_util::get_theme_option( 'share_to_email' );

			$image = wp_get_attachment_image_src( get_post_thumbnail_id( get_the_ID() ), 'innovation_ruby_840x500' );
			if ( is_plugin_active( 'wordpress-seo/wp-seo.php' ) and get_post_meta( get_the_ID(), '_yoast_wpseo_metadesc', true ) != '' ) {
				$pinterest_description = get_post_meta( get_the_ID(), '_yoast_wpseo_metadesc', true );
			} else {
				$pinterest_description = htmlspecialchars( urlencode( html_entity_decode( get_the_title(), ENT_COMPAT, 'UTF-8' ) ), ENT_COMPAT, 'UTF-8' );
			}

			//render
			$str = '';
			$str .= '<div class="share-bar-icon">';
			if ( ! empty( $enable_facebook ) ) {
				$str .= '<a href="' . $ruby_html . '://www.facebook.com/sharer.php?u=' . urlencode( get_permalink() ) . '" onclick="window.open(this.href, \'mywin\',\'left=50,top=50,width=600,height=350,toolbar=0\'); return false;"><i class="fa fa-facebook color-facebook"></i></a>';
			}

			if ( ! empty( $enable_twitter ) ) {
				$str .= '<a class="share-to-social" href="https://twitter.com/intent/tweet?text=' . htmlspecialchars( urlencode( html_entity_decode( get_the_title(), ENT_COMPAT, 'UTF-8' ) ), ENT_COMPAT, 'UTF-8' ) . '&amp;url=' . urlencode( get_permalink() ) . '&amp;via=' . urlencode( $twitter_user ? $twitter_user : get_bloginfo( 'name' ) ) . '" onclick="window.open(this.href, \'mywin\',\'left=50,top=50,width=600,height=350,toolbar=0\'); return false;"><i class="fa fa-twitter color-twitter"></i></a>';
			}

			if ( ! empty( $enable_google_plus ) ) {
				$str .= ' <a href="' . $ruby_html . '://plus.google.com/share?url=' . urlencode( get_permalink() ) . '" onclick="window.open(this.href, \'mywin\',\'left=50,top=50,width=600,height=350,toolbar=0\'); return false;"><i class="fa fa-google-plus color-google"></i></a>';
			}
			//pinterest
			if ( ! empty( $enable_pinterest ) ) {
				$str .= '<a href="' . $ruby_html . '://pinterest.com/pin/create/button/?url=' . urlencode( get_permalink() ) . '&amp;media=' . ( ! empty( $image[0] ) ? $image[0] : '' ) . '&description=' . $pinterest_description . '" onclick="window.open(this.href, \'mywin\',\'left=50,top=50,width=600,height=350,toolbar=0\'); return false;"><i class="fa fa-pinterest"></i></a>';
			}
			//linkedin
			if ( ! empty ( $enable_linkedin ) ) {
				$str .= '<a href="' . $ruby_html . '://linkedin.com/shareArticle?mini=true&amp;url=' . urlencode( get_permalink() ) . '&amp;title=' . htmlspecialchars( urlencode( html_entity_decode( get_the_title(), ENT_COMPAT, 'UTF-8' ) ), ENT_COMPAT, 'UTF-8' ) . '" onclick="window.open(this.href, \'mywin\',\'left=50,top=50,width=600,height=350,toolbar=0\'); return false;"><i class="fa fa-linkedin"></i></a>';
			}
			//tumblr
			if ( ! empty( $enable_tumblr ) ) {
				$str .= ' <a href="' . $ruby_html . '://www.tumblr.com/share/link?url=' . urlencode( get_permalink() ) . '&amp;name=' . htmlspecialchars( urlencode( html_entity_decode( get_the_title(), ENT_COMPAT, 'UTF-8' ) ), ENT_COMPAT, 'UTF-8' ) . '&amp;description=' . htmlspecialchars( urlencode( html_entity_decode( get_the_title(), ENT_COMPAT, 'UTF-8' ) ), ENT_COMPAT, 'UTF-8' ) . '" onclick="window.open(this.href, \'mywin\',\'left=50,top=50,width=600,height=350,toolbar=0\'); return false;"><i class="fa fa-tumblr"></i></a>';
			}
			//vk
			if ( ! empty( $enable_vk ) ) {
				$str .= '<a href="' . $ruby_html . '://vkontakte.ru/share.php?url=' . urldecode( get_permalink() ) . '" onclick="window.open(this.href, \'mywin\',\'left=50,top=50,width=600,height=350,toolbar=0\'); return false;"><i class="fa fa-vk"></i></a>';
			}
			//reddit
			if ( ! empty( $enable_reddit ) ) {
				$str .= '<a href="' . $ruby_html . '://www.reddit.com/submit?url=' . urlencode( get_permalink() ) . '&title=' . htmlspecialchars( urlencode( html_entity_decode( get_the_title(), ENT_COMPAT, 'UTF-8' ) ), ENT_COMPAT, 'UTF-8' ) . '" onclick="window.open(this.href, \'mywin\',\'left=50,top=50,width=600,height=350,toolbar=0\'); return false;"><i class="fa fa-reddit"></i></a>';
			}
			//email
			if ( ! empty( $enable_email ) ) {
				$str .= '<a href="mailto:?subject=' . htmlspecialchars( urlencode( html_entity_decode( get_the_title(), ENT_COMPAT, 'UTF-8' ) ), ENT_COMPAT, 'UTF-8' ) . '&BODY=' . esc_attr__( 'I found this article interesting and thought of sharing it with you. Check it out:', 'innovation' ) . urlencode( get_permalink() ) . '"><i class="fa fa-envelope-o"></i></a>';
			}

			$str .= '</div>';

			return $str;
		}
	}
}

