<?php

if ( ! class_exists( 'innovation_ruby_social_data' ) ) {
	class innovation_ruby_social_data {

		/**
		 * @param $author_id
		 *
		 * @return array
		 * get author social data
		 */
		static function author_data( $author_id ) {
			$social_data                = array();
			$social_data['website']     = get_the_author_meta( 'user_url', $author_id );
			$social_data['facebook']    = get_the_author_meta( 'facebook', $author_id );
			$social_data['twitter']     = get_the_author_meta( 'ruby_twitter', $author_id );
			$social_data['google_plus'] = get_the_author_meta( 'google_plus', $author_id );
			$social_data['youtube']     = get_the_author_meta( 'youtube', $author_id );
			$social_data['pinterest']   = get_the_author_meta( 'pinterest', $author_id );
			$social_data['linkedin']    = get_the_author_meta( 'linkedin', $author_id );
			$social_data['flickr']      = get_the_author_meta( 'flickr', $author_id );
			$social_data['skype']       = get_the_author_meta( 'skype', $author_id );
			$social_data['tumblr']      = get_the_author_meta( 'tumblr', $author_id );
			$social_data['vimeo']       = get_the_author_meta( 'vimeo', $author_id );
			$social_data['rss']         = get_the_author_meta( 'rss', $author_id );

			return $social_data;
		}


		static function web_data() {
			$social_data = array();

			if ( 1 == innovation_ruby_util::get_theme_option( 'site_social' ) ) {
				$social_data['facebook']    = innovation_ruby_util::get_theme_option( 'innovation_ruby_facebook' );
				$social_data['twitter']     = innovation_ruby_util::get_theme_option( 'innovation_ruby_twitter' );
				$social_data['google_plus'] = innovation_ruby_util::get_theme_option( 'innovation_ruby_google_plus' );
				$social_data['pinterest']   = innovation_ruby_util::get_theme_option( 'innovation_ruby_pinterest' );
				$social_data['bloglovin']   = innovation_ruby_util::get_theme_option( 'innovation_ruby_bloglovin' );
				$social_data['instagram']   = innovation_ruby_util::get_theme_option( 'innovation_ruby_instagram' );
				$social_data['youtube']     = innovation_ruby_util::get_theme_option( 'innovation_ruby_youtube' );
				$social_data['vimeo']       = innovation_ruby_util::get_theme_option( 'innovation_ruby_vimeo' );
				$social_data['flickr']      = innovation_ruby_util::get_theme_option( 'innovation_ruby_flickr' );
				$social_data['linkedin']    = innovation_ruby_util::get_theme_option( 'innovation_ruby_linkedin' );
				$social_data['tumblr']      = innovation_ruby_util::get_theme_option( 'innovation_ruby_tumblr' );
				$social_data['vkontakte']   = innovation_ruby_util::get_theme_option( 'innovation_ruby_vkontakte' );
				$social_data['skype']       = innovation_ruby_util::get_theme_option( 'innovation_ruby_skype' );
				$social_data['snapchat']    = innovation_ruby_util::get_theme_option( 'innovation_ruby_snapchat' );
				$social_data['viadeo']      = innovation_ruby_util::get_theme_option( 'innovation_ruby_viadeo' );
				$social_data['reddit']      = innovation_ruby_util::get_theme_option( 'innovation_ruby_reddit' );
				$social_data['rss']         = innovation_ruby_util::get_theme_option( 'innovation_ruby_rss' );
			}

			return $social_data;
		}

	}
}