<?php

//registering sidebar sections
if ( get_option( 'innovation_ruby_custom_multi_sidebars', false ) ) {
	$ruby_theme_current_sidebars = get_option( 'innovation_ruby_custom_multi_sidebars', '' );
	if ( ! empty( $ruby_theme_current_sidebars ) && is_array( $ruby_theme_current_sidebars ) ) {
		foreach ( $ruby_theme_current_sidebars as $ruby_current_sidebar ) {
			register_sidebar(
				array(
					'name'          => $ruby_current_sidebar['name'],
					'id'            => $ruby_current_sidebar['id'],
					'before_widget' => '<aside class="widget %2$s">',
					'after_widget'  => '</aside>',
					'before_title'  => '<div class="widget-title"><h3>',
					'after_title'   => '</h3></div>',
				)
			); //#foreach
		};
	};
};

register_sidebar(
	array(
		'id'            => 'innovation_ruby_sidebar_off_canvas',
		'name'          => esc_attr__( 'Off Canvas Section', 'innovation' ),
		'description'   => esc_attr__( 'Off canvas section', 'innovation' ),
		'before_widget' => '<aside class="widget %2$s">',
		'after_widget'  => '</aside>',
		'before_title'  => '<div class="widget-title"><h3>',
		'after_title'   => '</h3></div>'
	)
);

//blog home section
register_sidebar(
	array(
		'id'            => 'innovation_ruby_home_column_1',
		'name'          => esc_attr__( 'Blog Page First Column', 'innovation' ),
		'description'   => esc_attr__( 'One of column at top of latest blog page', 'innovation' ),
		'before_widget' => '<aside class="widget %2$s">',
		'after_widget'  => '</aside>',
		'before_title'  => '<div class="widget-title"><h3>',
		'after_title'   => '</h3></div>'
	)
);

register_sidebar(
	array(
		'id'            => 'innovation_ruby_home_column_2',
		'name'          => esc_attr__( 'Blog Page Second Column', 'innovation' ),
		'description'   => esc_attr__( 'One of column at top of latest last blog page', 'innovation' ),
		'before_widget' => '<aside class="widget %2$s">',
		'after_widget'  => '</aside>',
		'before_title'  => '<div class="widget-title"><h3>',
		'after_title'   => '</h3></div>'
	)
);

register_sidebar(
	array(
		'id'            => 'innovation_ruby_home_column_3',
		'name'          => esc_attr__( 'Blog Page Third Column', 'innovation' ),
		'description'   => esc_attr__( 'One of column at top of home page', 'innovation' ),
		'before_widget' => '<aside class="widget %2$s">',
		'after_widget'  => '</aside>',
		'before_title'  => '<div class="widget-title"><h3>',
		'after_title'   => '</h3></div>'
	)
);


//footer sections
register_sidebar(
	array(
		'id'            => 'innovation_ruby_sidebar_footer_fullwidth',
		'name'          => esc_attr__( 'Full Width Top Footer', 'innovation' ),
		'description'   => esc_attr__( 'Full width area at top of footer area. Allow [TOP FOOTER] Widget as instagram grid & and social counter widgets', 'innovation' ),
		'before_widget' => '<aside class="widget %2$s">',
		'after_widget'  => '</aside>',
		'before_title'  => '<div class="widget-title"><h3>',
		'after_title'   => '</h3></div>'
	)
);

register_sidebar(
	array(
		'id'            => 'innovation_ruby_sidebar_footer_1',
		'name'          => esc_attr__( 'Footer 1', 'innovation' ),
		'description'   => esc_attr__( 'One of column of footer area', 'innovation' ),
		'before_widget' => '<aside class="widget %2$s">',
		'after_widget'  => '</aside>',
		'before_title'  => '<div class="widget-title"><h3>',
		'after_title'   => '</h3></div>'
	)
);

register_sidebar(
	array(
		'id'            => 'innovation_ruby_sidebar_footer_2',
		'name'          => esc_attr__( 'Footer 2', 'innovation' ),
		'description'   => esc_attr__( 'One of column of footer area', 'innovation' ),
		'before_widget' => '<aside class="widget %2$s">',
		'after_widget'  => '</aside>',
		'before_title'  => '<div class="widget-title"><h3>',
		'after_title'   => '</h3></div>'
	)
);

register_sidebar(
	array(
		'id'            => 'innovation_ruby_sidebar_footer_3',
		'name'          => esc_attr__( 'Footer 3', 'innovation' ),
		'description'   => esc_attr__( 'One of column of footer area', 'innovation' ),
		'before_widget' => '<aside class="widget %2$s">',
		'after_widget'  => '</aside>',
		'before_title'  => '<div class="widget-title"><h3>',
		'after_title'   => '</h3></div>'
	)
);

register_sidebar(
	array(
		'id'            => 'innovation_ruby_sidebar_footer_4',
		'name'          => esc_attr__( 'Footer 4', 'innovation' ),
		'description'   => esc_attr__( 'One of column of footer area', 'innovation' ),
		'before_widget' => '<aside class="widget %2$s">',
		'after_widget'  => '</aside>',
		'before_title'  => '<div class="widget-title"><h3>',
		'after_title'   => '</h3></div>'
	)
);

