<?php

/**
 * @return mixed
 * theme wrapper
 * @link http://scribu.net/wordpress/theme-wrappers.html
 */
if ( ! class_exists( 'innovation_ruby_template_wrapper' ) ) {
	class innovation_ruby_template_wrapper {

		static $main_template;
		static $base;

		static function innovation_ruby_wrap( $template ) {
			self::$main_template = $template;

			self::$base = substr( basename( self::$main_template ), 0, - 4 );

			if ( 'index' == self::$base ) {
				self::$base = false;
			}

			$templates = array( 'base.php' );
			if ( self::$base ) {
				array_unshift( $templates, sprintf( 'base-%s.php', self::$base ) );
			}

			return locate_template( $templates );
		}
	}


	function innovation_ruby_template_path() {
		return innovation_ruby_template_wrapper::$main_template;
	}

	function innovation_ruby_template_base() {
		return innovation_ruby_template_wrapper::$base;
	}

	//template wrapping
	add_filter( 'template_include', array( 'innovation_ruby_template_wrapper', 'innovation_ruby_wrap' ), 99 );
}
