<?php
/**
 * Innovation functions and definitions
 * @package innovation
 */

//theme version
define( 'INNOVATION_THEME_VERSION', '3.3' );

//set the content width based on the theme's design and stylesheet.
if ( ! isset( $content_width ) ) {
	$content_width = 1170;
}

//make theme can be translated
load_theme_textdomain( 'innovation', get_template_directory() . '/languages' );

//including theme components
require_once get_template_directory() . '/includes/ruby_includes.php';


// Add default posts and comments RSS feed links to head.
add_theme_support( 'automatic-feed-links' );

//title tag
add_theme_support( 'title-tag' );

// html5 support
add_theme_support( 'html5', array( 'search-form', 'comment-form', 'comment-list', 'gallery', 'caption' ) );

//post format support
add_theme_support( 'post-formats', array( 'image', 'gallery', 'video', 'audio' ) );

//featured image
add_theme_support( 'post-thumbnails' );

//Woocommerce support
add_theme_support( 'woocommerce' );


//registering theme navigation
register_nav_menu( 'innovation_ruby_main_navigation', esc_html( 'Main Navigation', 'innovation' ) );
register_nav_menu( 'innovation_ruby_top_navigation', esc_html( 'Top Navigation', 'innovation' ) );


//registering theme thumbnail sizes
add_image_size( 'innovation_ruby_105x105', 105, 105, array( 'center', 'top' ) );
add_image_size( 'innovation_ruby_1400x840', 1400, 840, array( 'center', 'top' ) );
add_image_size( 'innovation_ruby_840x500', 840, 500, array( 'center', 'top' ) );
add_image_size( 'innovation_ruby_350x200', 350, 200, array( 'center', 'top' ) );
add_image_size( 'innovation_ruby_350x350', 350, 350, array( 'center', 'top' ) );
add_image_size( 'innovation_ruby_300x450', 300, 450, array( 'center', 'top' ) );

