<?php
/*******************************************************
	Plugin Name: Tweets Widget
	Description: Tweets Widget will display your Latest tweets
	Author: Raja CRN
	Author URI: http://themepacific.com												
************************************************************************/
/**
 * Add function to widgets_init that'll load our widget.
 * @since 0.1
 */

add_action('widgets_init', 'imagmag_themepacific_latest_tweets');
/**
 * Register our widget.
 * 'Example_Widget' is the widget class used below.
 *
 * @since 0.1
 */

function imagmag_themepacific_latest_tweets()

{

	register_widget('imagmag_themepacific_latest_tweets_widget');

}
/**
 * imagmag_themepacific_latest_tweets_widget  class.
 * This class handles everything that needs to be handled with the widget:
 * the settings, form, display, and update.  Nice!
 */


class imagmag_themepacific_latest_tweets_widget extends WP_Widget {
/**
* Widget setup.
*/
	function imagmag_themepacific_latest_tweets_widget()
	{ 			/* Widget settings. */
		$widget_ops = array('classname' => 'imagmag_themepacific_tweets', 'description' => 'To show latest Tweets.');
				/* Widget control settings. */
		$control_ops = array('id_base' => 'imagmag_themepacific_tweets_widget');
				/* Create the widget. */
		$this->WP_Widget('imagmag_themepacific_tweets_widget', 'ThemePacific: Tweets Widget', $widget_ops, $control_ops);
	}
/**
* Display the widget 
*/		
function widget($args, $instance)
	{
		extract($args);
		$title = apply_filters('widget_title', $instance['title']);
		$twit_id = $instance['twit_id'];
		$twitposts = $instance['twitposts'];		
		 
        echo $before_widget;
		/* Display the widget title if it has*/
		if($title) {
			echo $before_title.$title.$after_title;
		}
 		if($twit_id): ?>
			<ul id="twitter_update_list"><li><?php _e( 'Loading Tweets', 'imagmag' ); ?></li></ul>

		<script type="text/javascript" src="http://twitter.com/javascripts/blogger.js"></script>
			<script type="text/javascript" src="http://api.twitter.com/1/statuses/user_timeline/<?php echo $twit_id; ?>.json?callback=twitterCallback2&amp;count=<?php echo $twitposts; ?>"></script>	

		<?php endif;
 		echo $after_widget;

	}

/**
* Update the widget settings.
*/	

function update($new_instance, $old_instance)
	{
		$instance = $old_instance;
 		$instance['title'] = strip_tags($new_instance['title']);

		$instance['twit_id'] = $new_instance['twit_id'];

		$instance['twitposts'] = $new_instance['twitposts'];
	
 		return $instance;
 	}
/**
* Displays the widget settings controls on the widget panel.
**/
function form($instance)
	{
	$defaults = array('title' => 'Latest Tweets', 'twit_id' => '', 'twitposts' => '5');
 		$instance = wp_parse_args((array) $instance, $defaults); ?>
 		<p>
 			<label for="<?php echo $this->get_field_id('title'); ?>">Title:</label>
 			<input class="widefat" style="width: 216px;" id="<?php echo $this->get_field_id('title'); ?>" name="<?php echo $this->get_field_name('title'); ?>" value="<?php echo $instance['title']; ?>" />
 		</p>

  		<p>
 			<label for="<?php echo $this->get_field_id('twit_id'); ?>">Entet Twitter Username:</label>

			<input class="widefat" style="width: 216px;" id="<?php echo $this->get_field_id('twit_id'); ?>" name="<?php echo $this->get_field_name('twit_id'); ?>" value="<?php echo $instance['twit_id']; ?>" />
 		</p>
 		<p>
 			<label for="<?php echo $this->get_field_id('twitposts'); ?>">Enter the N.O of Tweets:</label>
 			<input class="widefat" style="width: 30px;" id="<?php echo $this->get_field_id('twitposts'); ?>" name="<?php echo $this->get_field_name('twitposts'); ?>" value="<?php echo $instance['twitposts']; ?>" />
 		</p>
		
 		 
 	<?php
 	}
 }

?>