<?php

function msp_get_slider_starter_sections () {

    $sections = array(
        array(
            'id' 	=> 'main_types',
            'title' => __( 'Slider Types', MSWP_TEXT_DOMAIN ),
            'desc'  => ''
        ),
        array(
            'id' 	=> 'masterslider_samples_group1',
            'title' => __( 'Sample Sliders', MSWP_TEXT_DOMAIN ),
            'desc'  => ''
        ),
        array(
            'id' 	=> 'masterslider_dynamic_group',
            'title' => __( 'Dynamic Sliders', MSWP_TEXT_DOMAIN ),
            'desc'  => ''
        )
    );

    return apply_filters( 'masterslider_starter_sections', $sections );
}


function msp_get_slider_starter_fields () {
	
	$wc_not_installed = msp_is_plugin_active( 'woocommerce/woocommerce.php' ) ? 'false' : 'true';

	$starters = array();

	$starters['main_types'] = array(

		array(
			'label' 	=> __( 'Custom Slider', MSWP_TEXT_DOMAIN ),
			'id' 		=> 'custom-slider',
			'slidertype'=> 'custom',
			'importdata'=> '',
			'image_dir' => '',
			'selected' 	=> 'true',
			'screenshot'=> MSWP_AVERTA_ADMIN_URL . '/assets/images/slider-types/pt_custom.png'
		),
		array(
			'label' 	=> __( 'Post Slider', MSWP_TEXT_DOMAIN ),
			'id' 		=> 'post-slider',
			'slidertype'=> 'post',
			'importdata'=> '',
			'image_dir' => '',
			'selected' 	=> 'false',
			'disable'   => 'false',
			'screenshot'=> MSWP_AVERTA_ADMIN_URL . '/assets/images/slider-types/pt_post.png'
		),
		array(
			'label' 	=> __( 'Flickr Slider', MSWP_TEXT_DOMAIN ),
			'id' 		=> 'flickr-slider',
			'slidertype'=> 'flickr',
			'importdata'=> '',
			'image_dir' => '',
			'selected' 	=> 'false',
			'screenshot'=> MSWP_AVERTA_ADMIN_URL . '/assets/images/slider-types/pt_flickr.png'
		),
		array(
			'label' 	=> __( 'Facebook Slider', MSWP_TEXT_DOMAIN ),
			'id' 		=> 'facebook-slider',
			'slidertype'=> 'facebook',
			'importdata'=> '',
			'image_dir' => '',
			'selected' 	=> 'false',
			'disable'   => 'false',
			'screenshot'=> MSWP_AVERTA_ADMIN_URL . '/assets/images/slider-types/pt_facebook.png'
		),
		array(
			'label' 	=> __( 'WooCommerce Product Slider', MSWP_TEXT_DOMAIN ),
			'id' 		=> 'wc-product-slider',
			'slidertype'=> 'wc-product',
			'importdata'=> '',
			'image_dir' => '',
			'selected' 	=> 'false',
			'disable'   => $wc_not_installed,
			'disabled_msg' => __( 'Please install and activate WooCommerce plugin to enable this feature.', MSWP_TEXT_DOMAIN ),
			'screenshot'=> MSWP_AVERTA_ADMIN_URL . '/assets/images/slider-types/pt_woocommerce.png'
		),
		array(
			'label' 	=> __( 'Instagram Slider', MSWP_TEXT_DOMAIN ),
			'id' 		=> 'instagram-slider',
			'slidertype'=> 'instagram',
			'importdata'=> '',
			'image_dir' => '',
			'selected' 	=> 'false',
			'disable'   => 'true',
			'screenshot'=> MSWP_AVERTA_ADMIN_URL . '/assets/images/slider-types/pt_instagram.png'
		)

	);

	$starters['masterslider_samples_group1'] = array(

		array(
			'label' 	=> __( 'Sample Slider 1', MSWP_TEXT_DOMAIN ),
			'id' 		=> 'sample-slider1',
			'slidertype'=> 'custom',
			'importdata'=> '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',
			'image_dir' => '',
			'selected' 	=> '',
			'screenshot'=> MSWP_AVERTA_ADMIN_URL . '/assets/images/starters/sample-slider-1.jpg'
		),
		array(
			'label' 	=> __( 'Sample Slider 2', MSWP_TEXT_DOMAIN ),
			'id' 		=> 'sample-slider2',
			'slidertype'=> 'custom',
			'importdata'=> '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',
			'image_dir' => '',
			'selected' 	=> '',
			'screenshot'=> MSWP_AVERTA_ADMIN_URL . '/assets/images/starters/sample-slider-2.jpg'
		),
		array(
			'label' 	=> __( 'Sample Image Gallery', MSWP_TEXT_DOMAIN ),
			'id' 		=> 'sample-image-gallery',
			'slidertype'=> 'custom',
			'importdata'=> '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',
			'image_dir' => '',
			'selected' 	=> '',
			'screenshot'=> MSWP_AVERTA_ADMIN_URL . '/assets/images/starters/sample-image-gallery.jpg'
		),
		array(
			'label' 	=> __( 'Sample 3D Flow Carousel', MSWP_TEXT_DOMAIN ),
			'id' 		=> 'sample-3d-flow-carousel',
			'slidertype'=> 'custom',
			'importdata'=> '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',
			'image_dir' => '',
			'selected' 	=> '',
			'screenshot'=> MSWP_AVERTA_ADMIN_URL . '/assets/images/starters/sample-3d-flow-carousel.jpg'
		),
		array(
			'label' 	=> __( 'Creative Agency', MSWP_TEXT_DOMAIN ),
			'id' 		=> 'creative-agency',
			'slidertype'=> 'custom',
			'importdata'=> 'eyJzbGlkZXJzX2RhdGEiOnsiMTkiOnsidGl0bGUiOiJDcmVhdGl2ZSBBZ2VuY3kiLCJwYXJhbXMiOiJleUp0WlhSaElqcDdJbE5sZEhScGJtZHpJV2xrY3lJNklqRWlMQ0pUWlhSMGFXNW5jeUZ1WlhoMFNXUWlPaklzSWxOc2FXUmxJV2xrY3lJNklqRXNNaXd6SWl3aVUyeHBaR1VoYm1WNGRFbGtJam8wTENKVGRIbHNaU0ZwWkhNaU9pSXhMRElzTXl3MExEZ3NPU3d4TUN3eE1Td3hNaXd4TXl3eE5DSXNJbE4wZVd4bElXNWxlSFJKWkNJNk1UVXNJa1ZtWm1WamRDRnBaSE1pT2lJeExESXNNeXcwTERVc05pdzNMRGdzTVRVc01UWXNNVGNzTVRnc01Ua3NNakFzTWpFc01qSXNNak1zTWpRc01qVXNNallzTWpjc01qZ2lMQ0pGWm1abFkzUWhibVY0ZEVsa0lqb3lPU3dpVEdGNVpYSWhhV1J6SWpvaU1Td3lMRE1zTkN3NExEa3NNVEFzTVRFc01USXNNVE1zTVRRaUxDSk1ZWGxsY2lGdVpYaDBTV1FpT2pFMUxDSkRiMjUwY205c0lXbGtjeUk2SWpFc01pd3pMRFFpTENKRGIyNTBjbTlzSVc1bGVIUkpaQ0k2Tlgwc0lrMVRVR0Z1Wld3dVUyVjBkR2x1WjNNaU9uc2lNU0k2SW50Y0ltbGtYQ0k2WENJeFhDSXNYQ0p6Ym1Gd2NHbHVaMXdpT25SeWRXVXNYQ0p1WVcxbFhDSTZYQ0pEY21WaGRHbDJaU0JCWjJWdVkzbGNJaXhjSW5kcFpIUm9YQ0k2TVRBd01DeGNJbWhsYVdkb2RGd2lPalV3TUN4Y0luZHlZWEJ3WlhKWGFXUjBhRndpT2pFd01DeGNJbmR5WVhCd1pYSlhhV1IwYUZWdWFYUmNJanBjSWlWY0lpeGNJbUYxZEc5RGNtOXdYQ0k2Wm1Gc2MyVXNYQ0pzWVhsdmRYUmNJanBjSW1aMWJHeDNhV1IwYUZ3aUxGd2lZWFYwYjBobGFXZG9kRndpT21aaGJITmxMRndpZEhKV2FXVjNYQ0k2WENKaVlYTnBZMXdpTEZ3aWMzQmxaV1JjSWpveU1DeGNJbk53WVdObFhDSTZNQ3hjSW5OMFlYSjBYQ0k2TVN4Y0ltZHlZV0pEZFhKemIzSmNJanAwY25WbExGd2ljM2RwY0dWY0lqcDBjblZsTEZ3aWJXOTFjMlZjSWpwMGNuVmxMRndpZDJobFpXeGNJanBtWVd4elpTeGNJbUYxZEc5d2JHRjVYQ0k2ZEhKMVpTeGNJbXh2YjNCY0lqcDBjblZsTEZ3aWMyaDFabVpzWlZ3aU9tWmhiSE5sTEZ3aWNISmxiRzloWkZ3aU9qRXNYQ0p2ZG1WeVVHRjFjMlZjSWpwMGNuVmxMRndpWlc1a1VHRjFjMlZjSWpwbVlXeHpaU3hjSW1ocFpHVk1ZWGxsY25OY0lqcG1ZV3h6WlN4Y0ltUnBjbHdpT2x3aWFGd2lMRndpWTJWdWRHVnlRMjl1ZEhKdmJITmNJanBtWVd4elpTeGNJbWx1YzNSaGJuUlRhRzkzVEdGNVpYSnpYQ0k2Wm1Gc2MyVXNYQ0p6YTJsdVhDSTZYQ0p0Y3kxemEybHVMV3hwWjJoMExUTmNJaXhjSW0xelZHVnRjR3hoZEdWY0lqcGNJbU4xYzNSdmJWd2lMRndpYlhOVVpXMXdiR0YwWlVOc1lYTnpYQ0k2WENKY0lpeGNJblZ6WldSR2IyNTBjMXdpT2x3aVRHRjBiem96TURBc2NtVm5kV3hoY2x3aWZTSjlMQ0pOVTFCaGJtVnNMbE5zYVdSbElqcDdJakVpT2lKN1hDSnBaRndpT2x3aU1Wd2lMRndpZEdsdFpXeHBibVZmYUZ3aU9qSXdNQ3hjSW1KblZHaDFiV0pjSWpwY0lpOHlNREUwTHpBMEwyTnBkSGt0TVRVd2VERTFNQzVxY0dkY0lpeGNJbTl5WkdWeVhDSTZNQ3hjSW1KblhDSTZYQ0l2TWpBeE5DOHdOQzlqYVhSNUxtcHdaMXdpTEZ3aVpIVnlZWFJwYjI1Y0lqbzFMRndpWm1sc2JFMXZaR1ZjSWpwY0ltWnBiR3hjSWl4Y0ltSm5kbDltYVd4c2JXOWtaVndpT2x3aVptbHNiRndpTEZ3aVltZDJYMnh2YjNCY0lqcDBjblZsTEZ3aVltZDJYMjExZEdWY0lqcDBjblZsTEZ3aVltZDJYMkYxZEc5d1lYVnpaVndpT21aaGJITmxMRndpYkdGNVpYSmZhV1J6WENJNlcxd2lNVndpTERJc00xMTlJaXdpTWlJNkludGNJbWxrWENJNk1peGNJblJwYldWc2FXNWxYMmhjSWpveU1EQXNYQ0ppWjFSb2RXMWlYQ0k2WENJdk1qQXhOQzh3TkM5aVp6RXhMVEUxTUhneE5UQXVhbkJuWENJc1hDSnZjbVJsY2x3aU9qRXNYQ0ppWjF3aU9sd2lMekl3TVRRdk1EUXZZbWN4TVM1cWNHZGNJaXhjSW1SMWNtRjBhVzl1WENJNk5peGNJbVpwYkd4TmIyUmxYQ0k2WENKbWFXeHNYQ0lzWENKaVozWmZabWxzYkcxdlpHVmNJanBjSW1acGJHeGNJaXhjSW1KbmRsOXNiMjl3WENJNmRISjFaU3hjSW1KbmRsOXRkWFJsWENJNmRISjFaU3hjSW1KbmRsOWhkWFJ2Y0dGMWMyVmNJanBtWVd4elpTeGNJbXhoZVdWeVgybGtjMXdpT2xzMExEZ3NPU3d4TUN3eE5GMTlJaXdpTXlJNkludGNJbWxrWENJNk15eGNJblJwYldWc2FXNWxYMmhjSWpveU1EQXNYQ0ppWjFSb2RXMWlYQ0k2WENJdk1qQXhOQzh3TkM5aVp6SXRNVFV3ZURFMU1DNXFjR2RjSWl4Y0ltOXlaR1Z5WENJNk1peGNJbUpuWENJNlhDSXZNakF4TkM4d05DOWlaekl1YW5CblhDSXNYQ0prZFhKaGRHbHZibHdpT2pZc1hDSm1hV3hzVFc5a1pWd2lPbHdpWm1sc2JGd2lMRndpWW1kMlgyWnBiR3h0YjJSbFhDSTZYQ0ptYVd4c1hDSXNYQ0ppWjNaZmJHOXZjRndpT25SeWRXVXNYQ0ppWjNaZmJYVjBaVndpT25SeWRXVXNYQ0ppWjNaZllYVjBiM0JoZFhObFhDSTZabUZzYzJVc1hDSnNZWGxsY2w5cFpITmNJanBiTVRFc01USXNNVE5kZlNKOUxDSk5VMUJoYm1Wc0xsTjBlV3hsSWpwN0lqRWlPaUo3WENKcFpGd2lPbHdpTVZ3aUxGd2lkSGx3WlZ3aU9sd2lZM1Z6ZEc5dFhDSXNYQ0pqYkdGemMwNWhiV1ZjSWpwY0ltMXpjQzFqYmkweE56SXRNVndpTEZ3aVltRmphMmR5YjNWdVpFTnZiRzl5WENJNlhDSWpabVptWm1abVhDSXNYQ0p3WVdSa2FXNW5WRzl3WENJNk1UQXNYQ0p3WVdSa2FXNW5VbWxuYUhSY0lqb3hOU3hjSW5CaFpHUnBibWRDYjNSMGIyMWNJam94TUN4Y0luQmhaR1JwYm1kTVpXWjBYQ0k2TVRVc1hDSm1iMjUwUm1GdGFXeDVYQ0k2WENKTVlYUnZYQ0lzWENKbWIyNTBWMlZwWjJoMFhDSTZYQ0l6TURCY0lpeGNJbVp2Ym5SVGFYcGxYQ0k2TlRBc1hDSnNhVzVsU0dWcFoyaDBYQ0k2WENKdWIzSnRZV3hjSWl4Y0ltTnZiRzl5WENJNlhDSWpORFEwTkRRMFhDSjlJaXdpTWlJNkludGNJbWxrWENJNk1peGNJbVp2Ym5SWFpXbG5hSFJjSWpwY0ltNXZjbTFoYkZ3aUxGd2liR2x1WlVobGFXZG9kRndpT2x3aWJtOXliV0ZzWENKOUlpd2lNeUk2SW50Y0ltbGtYQ0k2TXl4Y0luUjVjR1ZjSWpwY0ltTjFjM1J2YlZ3aUxGd2lZMnhoYzNOT1lXMWxYQ0k2WENKdGMzQXRZMjR0TVRjeUxUTmNJaXhjSW1admJuUkdZVzFwYkhsY0lqcGNJa3hoZEc5Y0lpeGNJbVp2Ym5SWFpXbG5hSFJjSWpwY0ltNXZjbTFoYkZ3aUxGd2labTl1ZEZOcGVtVmNJam94TkN4Y0lteHBibVZJWldsbmFIUmNJanBjSW01dmNtMWhiRndpZlNJc0lqUWlPaUo3WENKcFpGd2lPalFzWENKbWIyNTBWMlZwWjJoMFhDSTZYQ0p1YjNKdFlXeGNJaXhjSW14cGJtVklaV2xuYUhSY0lqcGNJbTV2Y20xaGJGd2lmU0lzSWpnaU9pSjdYQ0pwWkZ3aU9qZ3NYQ0owZVhCbFhDSTZYQ0pqZFhOMGIyMWNJaXhjSW1Oc1lYTnpUbUZ0WlZ3aU9sd2liWE53TFdOdUxURTNNaTA0WENJc1hDSmlZV05yWjNKdmRXNWtRMjlzYjNKY0lqcGNJaU5tWm1abVptWmNJaXhjSW5CaFpHUnBibWRVYjNCY0lqbzFMRndpY0dGa1pHbHVaMUpwWjJoMFhDSTZNVEFzWENKd1lXUmthVzVuUW05MGRHOXRYQ0k2TlN4Y0luQmhaR1JwYm1kTVpXWjBYQ0k2TVRBc1hDSm1iMjUwVjJWcFoyaDBYQ0k2WENKdWIzSnRZV3hjSWl4Y0lteHBibVZJWldsbmFIUmNJanBjSW01dmNtMWhiRndpZlNJc0lqa2lPaUo3WENKcFpGd2lPamtzWENKbWIyNTBWMlZwWjJoMFhDSTZYQ0p1YjNKdFlXeGNJaXhjSW14cGJtVklaV2xuYUhSY0lqcGNJbTV2Y20xaGJGd2lmU0lzSWpFd0lqb2llMXdpYVdSY0lqb3hNQ3hjSW5SNWNHVmNJanBjSW1OMWMzUnZiVndpTEZ3aVkyeGhjM05PWVcxbFhDSTZYQ0p0YzNBdFkyNHRPUzB4TUZ3aUxGd2lZbUZqYTJkeWIzVnVaRU52Ykc5eVhDSTZiblZzYkN4Y0luQmhaR1JwYm1kVWIzQmNJam94TUN4Y0luQmhaR1JwYm1kU2FXZG9kRndpT2pFMUxGd2ljR0ZrWkdsdVowSnZkSFJ2YlZ3aU9qRXdMRndpY0dGa1pHbHVaMHhsWm5SY0lqb3hOU3hjSW1admJuUkdZVzFwYkhsY0lqcGNJa3hoZEc5Y0lpeGNJbVp2Ym5SWFpXbG5hSFJjSWpwY0lqTXdNRndpTEZ3aVptOXVkRk5wZW1WY0lqbzFNQ3hjSW14cGJtVklaV2xuYUhSY0lqcGNJbTV2Y20xaGJGd2lMRndpWTI5c2IzSmNJanBjSWlNME5EUTBORFJjSW4waUxDSXhNU0k2SW50Y0ltbGtYQ0k2TVRFc1hDSm1iMjUwVjJWcFoyaDBYQ0k2WENKdWIzSnRZV3hjSWl4Y0lteHBibVZJWldsbmFIUmNJanBjSW01dmNtMWhiRndpZlNJc0lqRXlJam9pZTF3aWFXUmNJam94TWl4Y0ltWnZiblJYWldsbmFIUmNJanBjSW01dmNtMWhiRndpTEZ3aWJHbHVaVWhsYVdkb2RGd2lPbHdpYm05eWJXRnNYQ0o5SWl3aU1UTWlPaUo3WENKcFpGd2lPakV6TEZ3aWRIbHdaVndpT2x3aVkzVnpkRzl0WENJc1hDSmpiR0Z6YzA1aGJXVmNJanBjSW0xemNDMWpiaTA1TFRFelhDSXNYQ0ptYjI1MFJtRnRhV3g1WENJNlhDSk1ZWFJ2WENJc1hDSm1iMjUwVjJWcFoyaDBYQ0k2WENJek1EQmNJaXhjSW1admJuUlRhWHBsWENJNk16QXNYQ0pzYVc1bFNHVnBaMmgwWENJNlhDSnViM0p0WVd4Y0lpeGNJbU52Ykc5eVhDSTZYQ0lqWm1abVptWm1YQ0o5SWl3aU1UUWlPaUo3WENKcFpGd2lPakUwTEZ3aWRIbHdaVndpT2x3aVkzVnpkRzl0WENJc1hDSmpiR0Z6YzA1aGJXVmNJanBjSW0xemNDMWpiaTB4TnpJdE1UUmNJaXhjSW1KaFkydG5jbTkxYm1SRGIyeHZjbHdpT201MWJHd3NYQ0p3WVdSa2FXNW5WRzl3WENJNk1UQXNYQ0p3WVdSa2FXNW5VbWxuYUhSY0lqb3hOU3hjSW5CaFpHUnBibWRDYjNSMGIyMWNJam94TUN4Y0luQmhaR1JwYm1kTVpXWjBYQ0k2TVRVc1hDSm1iMjUwUm1GdGFXeDVYQ0k2WENKTVlYUnZYQ0lzWENKbWIyNTBWMlZwWjJoMFhDSTZYQ0l6TURCY0lpeGNJbVp2Ym5SVGFYcGxYQ0k2TlRBc1hDSnNhVzVsU0dWcFoyaDBYQ0k2WENKdWIzSnRZV3hjSWl4Y0ltTnZiRzl5WENJNlhDSWpORFEwTkRRMFhDSjlJbjBzSWsxVFVHRnVaV3d1UldabVpXTjBJanA3SWpFaU9pSjdYQ0pwWkZ3aU9sd2lNVndpTEZ3aVptRmtaVndpT25SeWRXVXNYQ0owY21GdWMyeGhkR1ZZWENJNk1DeGNJblJ5WVc1emJHRjBaVmxjSWpvdE5qQXdMRndpYzJOaGJHVllYQ0k2TVN4Y0luTmpZV3hsV1Z3aU9qRXNYQ0p5YjNSaGRHVmNJam90TWpBc1hDSnphMlYzV0Z3aU9qQXNYQ0p6YTJWM1dWd2lPaTAxTUgwaUxDSXlJam9pZTF3aWFXUmNJam95TEZ3aVptRmtaVndpT25SeWRXVjlJaXdpTXlJNkludGNJbWxrWENJNk15eGNJbVpoWkdWY0lqcDBjblZsTEZ3aWRISmhibk5zWVhSbFdGd2lPakFzWENKMGNtRnVjMnhoZEdWWlhDSTZNakF3TEZ3aWNtOTBZWFJsWENJNk1UQXNYQ0p6YTJWM1dGd2lPakFzWENKemEyVjNXVndpT2pJd2ZTSXNJalFpT2lKN1hDSnBaRndpT2pRc1hDSm1ZV1JsWENJNmRISjFaWDBpTENJMUlqb2llMXdpYVdSY0lqbzFMRndpWm1Ga1pWd2lPblJ5ZFdVc1hDSjBjbUZ1YzJ4aGRHVllYQ0k2TVRVd0xGd2ljbTkwWVhSbFhDSTZMVE1zWENKemEyVjNXRndpT2pVc1hDSnphMlYzV1Z3aU9qQjlJaXdpTmlJNkludGNJbWxrWENJNk5peGNJbVpoWkdWY0lqcDBjblZsZlNJc0lqY2lPaUo3WENKcFpGd2lPamNzWENKbVlXUmxYQ0k2Wm1Gc2MyVXNYQ0owY21GdWMyeGhkR1ZZWENJNk5EQXdmU0lzSWpnaU9pSjdYQ0pwWkZ3aU9qZ3NYQ0ptWVdSbFhDSTZkSEoxWlgwaUxDSXhOU0k2SW50Y0ltbGtYQ0k2TVRVc1hDSm1ZV1JsWENJNmRISjFaU3hjSW5OallXeGxXRndpT2pFdU5TeGNJbk5qWVd4bFdWd2lPakV1TlgwaUxDSXhOaUk2SW50Y0ltbGtYQ0k2TVRZc1hDSm1ZV1JsWENJNmRISjFaWDBpTENJeE55STZJbnRjSW1sa1hDSTZNVGNzWENKbVlXUmxYQ0k2ZEhKMVpTeGNJbk5qWVd4bFdGd2lPakF1Tnl4Y0luTmpZV3hsV1Z3aU9qQXVOeXhjSW5KdmRHRjBaVndpT2kweWZTSXNJakU0SWpvaWUxd2lhV1JjSWpveE9DeGNJbVpoWkdWY0lqcDBjblZsZlNJc0lqRTVJam9pZTF3aWFXUmNJam94T1N4Y0ltWmhaR1ZjSWpwMGNuVmxMRndpYzJOaGJHVllYQ0k2TVM0MUxGd2ljMk5oYkdWWlhDSTZNUzQxZlNJc0lqSXdJam9pZTF3aWFXUmNJam95TUN4Y0ltWmhaR1ZjSWpwMGNuVmxmU0lzSWpJeElqb2llMXdpYVdSY0lqb3lNU3hjSW1aaFpHVmNJanAwY25WbExGd2lkSEpoYm5Oc1lYUmxXVndpT2pFMU1IMGlMQ0l5TWlJNkludGNJbWxrWENJNk1qSXNYQ0ptWVdSbFhDSTZkSEoxWlgwaUxDSXlNeUk2SW50Y0ltbGtYQ0k2TWpNc1hDSm1ZV1JsWENJNmRISjFaWDBpTENJeU5DSTZJbnRjSW1sa1hDSTZNalFzWENKbVlXUmxYQ0k2ZEhKMVpYMGlMQ0l5TlNJNkludGNJbWxrWENJNk1qVXNYQ0ptWVdSbFhDSTZkSEoxWlN4Y0luUnlZVzV6YkdGMFpWbGNJam90TVRVd2ZTSXNJakkySWpvaWUxd2lhV1JjSWpveU5peGNJbVpoWkdWY0lqcDBjblZsZlNJc0lqSTNJam9pZTF3aWFXUmNJam95Tnl4Y0ltWmhaR1ZjSWpwMGNuVmxMRndpYzJOaGJHVllYQ0k2TVM0MUxGd2ljMk5oYkdWWlhDSTZNUzQxZlNJc0lqSTRJam9pZTF3aWFXUmNJam95T0N4Y0ltWmhaR1ZjSWpwMGNuVmxmU0o5TENKTlUxQmhibVZzTGt4aGVXVnlJanA3SWpFaU9pSjdYQ0pwWkZ3aU9sd2lNVndpTEZ3aWJtRnRaVndpT2x3aWRHbDBiR1ZjSWl4Y0ltbHpURzlqYTJWa1hDSTZabUZzYzJVc1hDSnBjMGhwWkdWa1hDSTZabUZzYzJVc1hDSnBjMU52Ykc5bFpGd2lPbVpoYkhObExGd2ljMmh2ZDFSeVlXNXpabTl5YlZ3aU9sd2ljR1Z5YzNCbFkzUnBkbVVvTWpBd01IQjRLU0IwY21GdWMyeGhkR1ZZS0RCd2VDa2dkSEpoYm5Oc1lYUmxXU2d0TmpBd2NIZ3BJSEp2ZEdGMFpTZ3RNakJrWldjcElITnJaWGRZS0RCa1pXY3BJSE5yWlhkWktDMDFNR1JsWnlrZ2MyTmhiR1ZZS0RFcElITmpZV3hsV1NneEtTQmNJaXhjSW5Ob2IzZFBjbWxuYVc1Y0lqcGNJalV3SlNBMU1DVWdNSEI0WENJc1hDSnphRzkzUm1Ga1pWd2lPblJ5ZFdVc1hDSm9hV1JsVkhKaGJuTm1iM0p0WENJNlhDSmNJaXhjSW1ocFpHVlBjbWxuYVc1Y0lqcGNJbHdpTEZ3aWFHbGtaVVpoWkdWY0lqcDBjblZsTEZ3aWIzSmtaWEpjSWpveUxGd2lkSGx3WlZ3aU9sd2lkR1Y0ZEZ3aUxGd2lZMjl1ZEdWdWRGd2lPbHdpVEU5U1JVMGdTVkJUVlUwZ1JFOU1UMUpjSWl4Y0luWnBaR1Z2WENJNlhDSm9kSFJ3T2k4dmNHeGhlV1Z5TG5acGJXVnZMbU52YlM5MmFXUmxieTh4TVRjeU1USTBNbHdpTEZ3aVlXeHBaMjVjSWpwY0luUnZjRndpTEZ3aWIyWm1jMlYwV0Z3aU9qSXlNaTQxTEZ3aWIyWm1jMlYwV1Z3aU9qRTFOaTQxTEZ3aWNtVnphWHBsWENJNmRISjFaU3hjSW5kcFpIUm9iR2x0YVhSY0lqcGNJakJjSWl4Y0ltTnNZWE56VG1GdFpWd2lPbHdpYlhOd0xXTnVMVEUzTWkweFhDSXNYQ0p6YUc5M1JIVnlZWFJwYjI1Y0lqb3lMalVzWENKemFHOTNSR1ZzWVhsY0lqb3dMRndpYzJodmQwVmhjMlZjSWpwY0ltVmhjMlZQZFhSRmVIQnZYQ0lzWENKemFHOTNSV1ptUm5WdVkxd2lPbHdpZENoMGNuVmxMREFzTFRZd01DeHVMQzB5TUN4dUxHNHNiaXd4TERFc01Dd3ROVEFzYml4dUxHNHBYQ0lzWENKMWMyVklhV1JsWENJNlptRnNjMlVzWENKb2FXUmxSSFZ5WVhScGIyNWNJam94TEZ3aWFHbGtaVVJsYkdGNVhDSTZNU3hjSW1ocFpHVkZZWE5sWENJNlhDSmxZWE5sVDNWMFVYVnBiblJjSWl4Y0luTnNhV1JsWENJNlhDSXhYQ0lzWENKemRIbHNaVTF2WkdWc1hDSTZYQ0l4WENJc1hDSnphRzkzUldabVpXTjBYQ0k2WENJeFhDSXNYQ0pvYVdSbFJXWm1aV04wWENJNk1uMGlMQ0l5SWpvaWUxd2lhV1JjSWpveUxGd2libUZ0WlZ3aU9sd2lZblJ1WENJc1hDSnBjMHh2WTJ0bFpGd2lPbVpoYkhObExGd2lhWE5JYVdSbFpGd2lPbVpoYkhObExGd2lhWE5UYjJ4dlpXUmNJanBtWVd4elpTeGNJbk5vYjNkVWNtRnVjMlp2Y20xY0lqcGNJbkJsY25Od1pXTjBhWFpsS0RJd01EQndlQ2tnZEhKaGJuTnNZWFJsV0Nnd2NIZ3BJSFJ5WVc1emJHRjBaVmtvTWpBd2NIZ3BJSEp2ZEdGMFpTZ3hNR1JsWnlrZ2MydGxkMWdvTUdSbFp5a2djMnRsZDFrb01qQmtaV2NwSUZ3aUxGd2ljMmh2ZDA5eWFXZHBibHdpT2x3aU5UQWxJRFV3SlNBd2NIaGNJaXhjSW5Ob2IzZEdZV1JsWENJNmRISjFaU3hjSW1ocFpHVlVjbUZ1YzJadmNtMWNJanBjSWx3aUxGd2lhR2xrWlU5eWFXZHBibHdpT2x3aVhDSXNYQ0pvYVdSbFJtRmtaVndpT25SeWRXVXNYQ0pwYldkVWFIVnRZbHdpT2x3aUx6SXdNVFF2TURRdlluUnVMWEpsWkM1d2JtZGNJaXhjSW05eVpHVnlYQ0k2TUN4Y0luUjVjR1ZjSWpwY0ltbHRZV2RsWENJc1hDSmpiMjUwWlc1MFhDSTZYQ0pNYjNKbGJTQkpjSE4xYlZ3aUxGd2lhVzFuWENJNlhDSXZNakF4TkM4d05DOWlkRzR0Y21Wa0xuQnVaMXdpTEZ3aWRtbGtaVzljSWpwY0ltaDBkSEE2THk5d2JHRjVaWEl1ZG1sdFpXOHVZMjl0TDNacFpHVnZMekV4TnpJeE1qUXlYQ0lzWENKaGJHbG5ibHdpT2x3aWRHOXdYQ0lzWENKdlptWnpaWFJZWENJNk5EUXpMalVzWENKdlptWnpaWFJaWENJNk16RTBMRndpY21WemFYcGxYQ0k2ZEhKMVpTeGNJbmRwWkhSb2JHbHRhWFJjSWpwY0lqQmNJaXhjSW5Ob2IzZEVkWEpoZEdsdmJsd2lPakl1TlN4Y0luTm9iM2RFWld4aGVWd2lPakF1T1RFeU5TeGNJbk5vYjNkRllYTmxYQ0k2WENKbFlYTmxUM1YwVVhWcGJuUmNJaXhjSW5Ob2IzZEZabVpHZFc1alhDSTZYQ0owS0hSeWRXVXNNQ3d5TURBc2Jpd3hNQ3h1TEc0c2JpeHVMRzRzTUN3eU1DeHVMRzRzYmlsY0lpeGNJblZ6WlVocFpHVmNJanBtWVd4elpTeGNJbWhwWkdWRWRYSmhkR2x2Ymx3aU9qRXNYQ0pvYVdSbFJHVnNZWGxjSWpveExGd2lhR2xrWlVWaGMyVmNJanBjSW1WaGMyVlBkWFJSZFdsdWRGd2lMRndpYzJ4cFpHVmNJanBjSWpGY0lpeGNJbk4wZVd4bFRXOWtaV3hjSWpveUxGd2ljMmh2ZDBWbVptVmpkRndpT2pNc1hDSm9hV1JsUldabVpXTjBYQ0k2TkgwaUxDSXpJam9pZTF3aWFXUmNJam96TEZ3aWJtRnRaVndpT2x3aWRHVjRkRndpTEZ3aWFYTk1iMk5yWldSY0lqcG1ZV3h6WlN4Y0ltbHpTR2xrWldSY0lqcG1ZV3h6WlN4Y0ltbHpVMjlzYjJWa1hDSTZabUZzYzJVc1hDSnphRzkzVkhKaGJuTm1iM0p0WENJNlhDSndaWEp6Y0dWamRHbDJaU2d5TURBd2NIZ3BJSFJ5WVc1emJHRjBaVmdvTVRVd2NIZ3BJSEp2ZEdGMFpTZ3RNMlJsWnlrZ2MydGxkMWdvTldSbFp5a2djMnRsZDFrb01HUmxaeWtnWENJc1hDSnphRzkzVDNKcFoybHVYQ0k2WENJMU1DVWdOVEFsSURCd2VGd2lMRndpYzJodmQwWmhaR1ZjSWpwMGNuVmxMRndpYUdsa1pWUnlZVzV6Wm05eWJWd2lPbHdpWENJc1hDSm9hV1JsVDNKcFoybHVYQ0k2WENKY0lpeGNJbWhwWkdWR1lXUmxYQ0k2ZEhKMVpTeGNJbTl5WkdWeVhDSTZNU3hjSW5SNWNHVmNJanBjSW5SbGVIUmNJaXhjSW1OdmJuUmxiblJjSWpwY0lqeHdJSE4wZVd4bFBWeGNYQ0owWlhoMExXRnNhV2R1T2lCalpXNTBaWEk3WEZ4Y0lqNU1iM0psYlNCcGNITjFiU0JrYjJ4dmNpQnphWFFnWVcxbGRDd2dZMjl1YzJWamRHVjBkV1Z5SUdGa2FYQnBjMk5wYm1jZ1pXeHBkQ3dnYzJWa0lHUnBZVzBnUEdKeUlDOCtibTl1ZFcxdGVTQnVhV0pvSUdWMWFYTnRiMlFnZEdsdVkybGtkVzUwSUhWMElHeGhiM0psWlhRZ1pHOXNiM0psSUcxaFoyNWhMand2Y0Q1Y0lpeGNJblpwWkdWdlhDSTZYQ0pvZEhSd09pOHZjR3hoZVdWeUxuWnBiV1Z2TG1OdmJTOTJhV1JsYnk4eE1UY3lNVEkwTWx3aUxGd2lZV3hwWjI1Y0lqcGNJblJ2Y0Z3aUxGd2liMlptYzJWMFdGd2lPakk1TlN4Y0ltOW1abk5sZEZsY0lqb3lORFlzWENKeVpYTnBlbVZjSWpwMGNuVmxMRndpZDJsa2RHaHNhVzFwZEZ3aU9sd2lNRndpTEZ3aVkyeGhjM05PWVcxbFhDSTZYQ0p0YzNBdFkyNHRNVGN5TFROY0lpeGNJbk5vYjNkRWRYSmhkR2x2Ymx3aU9qSXNYQ0p6YUc5M1JHVnNZWGxjSWpvd0xqY3NYQ0p6YUc5M1JXRnpaVndpT2x3aVpXRnpaVTkxZEZGMWFXNTBYQ0lzWENKemFHOTNSV1ptUm5WdVkxd2lPbHdpZENoMGNuVmxMREUxTUN4dUxHNHNMVE1zYml4dUxHNHNiaXh1TERVc01DeHVMRzRzYmlsY0lpeGNJblZ6WlVocFpHVmNJanBtWVd4elpTeGNJbWhwWkdWRWRYSmhkR2x2Ymx3aU9qRXNYQ0pvYVdSbFJHVnNZWGxjSWpveExGd2lhR2xrWlVWaGMyVmNJanBjSW1WaGMyVlBkWFJSZFdsdWRGd2lMRndpYzJ4cFpHVmNJanBjSWpGY0lpeGNJbk4wZVd4bFRXOWtaV3hjSWpvekxGd2ljMmh2ZDBWbVptVmpkRndpT2pVc1hDSm9hV1JsUldabVpXTjBYQ0k2Tm4waUxDSTBJam9pZTF3aWFXUmNJam8wTEZ3aWJtRnRaVndpT2x3aWQyOXRZVzVjSWl4Y0ltbHpURzlqYTJWa1hDSTZabUZzYzJVc1hDSnBjMGhwWkdWa1hDSTZabUZzYzJVc1hDSnBjMU52Ykc5bFpGd2lPbVpoYkhObExGd2ljMmh2ZDFSeVlXNXpabTl5YlZ3aU9sd2ljR1Z5YzNCbFkzUnBkbVVvTWpBd01IQjRLU0IwY21GdWMyeGhkR1ZZS0RRd01IQjRLU0JjSWl4Y0luTm9iM2RQY21sbmFXNWNJanBjSWpVd0pTQTFNQ1VnTUhCNFhDSXNYQ0p6YUc5M1JtRmtaVndpT21aaGJITmxMRndpYUdsa1pWUnlZVzV6Wm05eWJWd2lPbHdpWENJc1hDSm9hV1JsVDNKcFoybHVYQ0k2WENKY0lpeGNJbWhwWkdWR1lXUmxYQ0k2ZEhKMVpTeGNJbWx0WjFSb2RXMWlYQ0k2WENJdk1qQXhOQzh3TkM5M2IyMWhiaTB4TlRCNE1UVXdMbkJ1WjF3aUxGd2liM0prWlhKY0lqb3hMRndpZEhsd1pWd2lPbHdpYVcxaFoyVmNJaXhjSW1OdmJuUmxiblJjSWpwY0lreHZjbVZ0SUVsd2MzVnRYQ0lzWENKcGJXZGNJanBjSWk4eU1ERTBMekEwTDNkdmJXRnVMbkJ1WjF3aUxGd2lkbWxrWlc5Y0lqcGNJbWgwZEhBNkx5OXdiR0Y1WlhJdWRtbHRaVzh1WTI5dEwzWnBaR1Z2THpFeE56SXhNalF5WENJc1hDSmhiR2xuYmx3aU9sd2lkRzl3WENJc1hDSnZabVp6WlhSWVhDSTZOVGd3TEZ3aWIyWm1jMlYwV1Z3aU9qa3dMRndpY21WemFYcGxYQ0k2ZEhKMVpTeGNJbmRwWkhSb2JHbHRhWFJjSWpwY0lqQmNJaXhjSW5Ob2IzZEVkWEpoZEdsdmJsd2lPaklzWENKemFHOTNSR1ZzWVhsY0lqb3dMRndpYzJodmQwVmhjMlZjSWpwY0ltVmhjMlZQZFhSRmVIQnZYQ0lzWENKemFHOTNSV1ptUm5WdVkxd2lPbHdpZENobVlXeHpaU3cwTURBc2JpeHVMRzRzYml4dUxHNHNiaXh1TEc0c2JpeHVMRzRzYmlsY0lpeGNJblZ6WlVocFpHVmNJanBtWVd4elpTeGNJbWhwWkdWRWRYSmhkR2x2Ymx3aU9qRXNYQ0pvYVdSbFJHVnNZWGxjSWpveExGd2lhR2xrWlVWaGMyVmNJanBjSW1WaGMyVlBkWFJSZFdsdWRGd2lMRndpYzJ4cFpHVmNJam95TEZ3aWMzUjViR1ZOYjJSbGJGd2lPalFzWENKemFHOTNSV1ptWldOMFhDSTZOeXhjSW1ocFpHVkZabVpsWTNSY0lqbzRmU0lzSWpnaU9pSjdYQ0pwWkZ3aU9qZ3NYQ0p1WVcxbFhDSTZYQ0owWlhoMFhDSXNYQ0pwYzB4dlkydGxaRndpT21aaGJITmxMRndpYVhOSWFXUmxaRndpT21aaGJITmxMRndpYVhOVGIyeHZaV1JjSWpwbVlXeHpaU3hjSW5Ob2IzZFVjbUZ1YzJadmNtMWNJanBjSW5CbGNuTndaV04wYVhabEtESXdNREJ3ZUNrZ2MyTmhiR1ZZS0RFdU5Ta2djMk5oYkdWWktERXVOU2tnWENJc1hDSnphRzkzVDNKcFoybHVYQ0k2WENJMU1DVWdOVEFsSURCd2VGd2lMRndpYzJodmQwWmhaR1ZjSWpwMGNuVmxMRndpYUdsa1pWUnlZVzV6Wm05eWJWd2lPbHdpWENJc1hDSm9hV1JsVDNKcFoybHVYQ0k2WENKY0lpeGNJbWhwWkdWR1lXUmxYQ0k2ZEhKMVpTeGNJbTl5WkdWeVhDSTZOQ3hjSW5SNWNHVmNJanBjSW5SbGVIUmNJaXhjSW1OdmJuUmxiblJjSWpwY0lrRjBJSFpsY204Z1pXOXpJR1YwSUdGalkzVnpZVzBnWlhRZ2FuVnpkRzhnWkhWdklHUnZiRzl5WlhNZ1pYUWdaV0VnY21WaWRXMDhZbklnTHo1RWRXbHpJR0YxZEdWdElIWmxiQ0JsZFcwZ2FYSnBkWEpsSUdSdmJHOXlJR2x1SUdobGJtUnlaWEpwZE1LZ1RHOXlaVzBnYVhCemRXMGdQR0p5SUM4K1pHOXNiM0lnYzJsMElHRnRaWFFzSUdOdmJuTmxkR1YwZFhJZ2MyRmthWEJ6WTJsdVp5QmxiR2wwY2x3aUxGd2lkbWxrWlc5Y0lqcGNJbWgwZEhBNkx5OXdiR0Y1WlhJdWRtbHRaVzh1WTI5dEwzWnBaR1Z2THpFeE56SXhNalF5WENJc1hDSmhiR2xuYmx3aU9sd2lkRzl3WENJc1hDSnZabVp6WlhSWVhDSTZNVGd4TEZ3aWIyWm1jMlYwV1Z3aU9qSTFNaXhjSW5KbGMybDZaVndpT25SeWRXVXNYQ0ozYVdSMGFHeHBiV2wwWENJNlhDSXdYQ0lzWENKamJHRnpjMDVoYldWY0lqcGNJbTF6Y0MxamJpMHhOekl0T0Z3aUxGd2ljMmh2ZDBSMWNtRjBhVzl1WENJNk1TeGNJbk5vYjNkRVpXeGhlVndpT2pFdU56YzFMRndpYzJodmQwVmhjMlZjSWpwY0ltVmhjMlZQZFhSQ1lXTnJYQ0lzWENKemFHOTNSV1ptUm5WdVkxd2lPbHdpZENoMGNuVmxMRzRzYml4dUxHNHNiaXh1TEc0c01TNDFMREV1TlN4dUxHNHNiaXh1TEc0cFhDSXNYQ0oxYzJWSWFXUmxYQ0k2Wm1Gc2MyVXNYQ0pvYVdSbFJIVnlZWFJwYjI1Y0lqb3hMRndpYUdsa1pVUmxiR0Y1WENJNk1TeGNJbWhwWkdWRllYTmxYQ0k2WENKbFlYTmxUM1YwVVhWcGJuUmNJaXhjSW5Oc2FXUmxYQ0k2TWl4Y0luTjBlV3hsVFc5a1pXeGNJam80TEZ3aWMyaHZkMFZtWm1WamRGd2lPakUxTEZ3aWFHbGtaVVZtWm1WamRGd2lPakUyZlNJc0lqa2lPaUo3WENKcFpGd2lPamtzWENKdVlXMWxYQ0k2WENKaWRHNWNJaXhjSW1selRHOWphMlZrWENJNlptRnNjMlVzWENKcGMwaHBaR1ZrWENJNlptRnNjMlVzWENKcGMxTnZiRzlsWkZ3aU9tWmhiSE5sTEZ3aWMyaHZkMVJ5WVc1elptOXliVndpT2x3aWNHVnljM0JsWTNScGRtVW9NakF3TUhCNEtTQnliM1JoZEdVb0xUSmtaV2NwSUhOallXeGxXQ2d3TGpjcElITmpZV3hsV1Nnd0xqY3BJRndpTEZ3aWMyaHZkMDl5YVdkcGJsd2lPbHdpTlRBbElEVXdKU0F3Y0hoY0lpeGNJbk5vYjNkR1lXUmxYQ0k2ZEhKMVpTeGNJbWhwWkdWVWNtRnVjMlp2Y20xY0lqcGNJbHdpTEZ3aWFHbGtaVTl5YVdkcGJsd2lPbHdpWENJc1hDSm9hV1JsUm1Ga1pWd2lPblJ5ZFdVc1hDSnBiV2RVYUhWdFlsd2lPbHdpTHpJd01UUXZNRFF2WW5SdUxXSnNkV1V1Y0c1blhDSXNYQ0p2Y21SbGNsd2lPalVzWENKMGVYQmxYQ0k2WENKcGJXRm5aVndpTEZ3aVkyOXVkR1Z1ZEZ3aU9sd2lURzl5WlcwZ1NYQnpkVzFjSWl4Y0ltbHRaMXdpT2x3aUx6SXdNVFF2TURRdlluUnVMV0pzZFdVdWNHNW5YQ0lzWENKMmFXUmxiMXdpT2x3aWFIUjBjRG92TDNCc1lYbGxjaTUyYVcxbGJ5NWpiMjB2ZG1sa1pXOHZNVEUzTWpFeU5ESmNJaXhjSW1Gc2FXZHVYQ0k2WENKMGIzQmNJaXhjSW05bVpuTmxkRmhjSWpveE9ERXNYQ0p2Wm1aelpYUlpYQ0k2TXpNMkxGd2ljbVZ6YVhwbFhDSTZkSEoxWlN4Y0luZHBaSFJvYkdsdGFYUmNJanBjSWpCY0lpeGNJbk5vYjNkRWRYSmhkR2x2Ymx3aU9qRXNYQ0p6YUc5M1JHVnNZWGxjSWpveUxqVXNYQ0p6YUc5M1JXRnpaVndpT2x3aVpXRnpaVTkxZEZGMWFXNTBYQ0lzWENKemFHOTNSV1ptUm5WdVkxd2lPbHdpZENoMGNuVmxMRzRzYml4dUxDMHlMRzRzYml4dUxEQXVOeXd3TGpjc2JpeHVMRzRzYml4dUtWd2lMRndpZFhObFNHbGtaVndpT21aaGJITmxMRndpYUdsa1pVUjFjbUYwYVc5dVhDSTZNU3hjSW1ocFpHVkVaV3hoZVZ3aU9qRXNYQ0pvYVdSbFJXRnpaVndpT2x3aVpXRnpaVTkxZEZGMWFXNTBYQ0lzWENKemJHbGtaVndpT2pJc1hDSnpkSGxzWlUxdlpHVnNYQ0k2T1N4Y0luTm9iM2RGWm1abFkzUmNJam94Tnl4Y0ltaHBaR1ZGWm1abFkzUmNJam94T0gwaUxDSXhNQ0k2SW50Y0ltbGtYQ0k2TVRBc1hDSnVZVzFsWENJNlhDSjBhWFJzWlZ3aUxGd2lhWE5NYjJOclpXUmNJanBtWVd4elpTeGNJbWx6U0dsa1pXUmNJanBtWVd4elpTeGNJbWx6VTI5c2IyVmtYQ0k2Wm1Gc2MyVXNYQ0p6YUc5M1ZISmhibk5tYjNKdFhDSTZYQ0p3WlhKemNHVmpkR2wyWlNneU1EQXdjSGdwSUhOallXeGxXQ2d4TGpVcElITmpZV3hsV1NneExqVXBJRndpTEZ3aWMyaHZkMDl5YVdkcGJsd2lPbHdpTlRBbElEVXdKU0F3Y0hoY0lpeGNJbk5vYjNkR1lXUmxYQ0k2ZEhKMVpTeGNJbWhwWkdWVWNtRnVjMlp2Y20xY0lqcGNJbHdpTEZ3aWFHbGtaVTl5YVdkcGJsd2lPbHdpWENJc1hDSm9hV1JsUm1Ga1pWd2lPblJ5ZFdVc1hDSnZjbVJsY2x3aU9qSXNYQ0owZVhCbFhDSTZYQ0owWlhoMFhDSXNYQ0pqYjI1MFpXNTBYQ0k2WENKTVQxSkZUU0JKVUZOVlRWd2lMRndpZG1sa1pXOWNJanBjSW1oMGRIQTZMeTl3YkdGNVpYSXVkbWx0Wlc4dVkyOXRMM1pwWkdWdkx6RXhOekl4TWpReVhDSXNYQ0poYkdsbmJsd2lPbHdpZEc5d1hDSXNYQ0p2Wm1aelpYUllYQ0k2TVRZd0xGd2liMlptYzJWMFdWd2lPakV6TVN4Y0luSmxjMmw2WlZ3aU9uUnlkV1VzWENKM2FXUjBhR3hwYldsMFhDSTZYQ0l3WENJc1hDSmpiR0Z6YzA1aGJXVmNJanBjSW0xemNDMWpiaTA1TFRFd1hDSXNYQ0p6YUc5M1JIVnlZWFJwYjI1Y0lqb3hMRndpYzJodmQwUmxiR0Y1WENJNk1TNHpNVEkxTEZ3aWMyaHZkMFZoYzJWY0lqcGNJbVZoYzJWUGRYUkNZV05yWENJc1hDSnphRzkzUldabVJuVnVZMXdpT2x3aWRDaDBjblZsTEc0c2JpeHVMRzRzYml4dUxHNHNNUzQxTERFdU5TeHVMRzRzYml4dUxHNHBYQ0lzWENKMWMyVklhV1JsWENJNlptRnNjMlVzWENKb2FXUmxSSFZ5WVhScGIyNWNJam94TEZ3aWFHbGtaVVJsYkdGNVhDSTZNU3hjSW1ocFpHVkZZWE5sWENJNlhDSmxZWE5sVDNWMFVYVnBiblJjSWl4Y0luTnNhV1JsWENJNk1peGNJbk4wZVd4bFRXOWtaV3hjSWpveE1DeGNJbk5vYjNkRlptWmxZM1JjSWpveE9TeGNJbWhwWkdWRlptWmxZM1JjSWpveU1IMGlMQ0l4TVNJNkludGNJbWxrWENJNk1URXNYQ0p1WVcxbFhDSTZYQ0pzWVhCMGIzQmNJaXhjSW1selRHOWphMlZrWENJNlptRnNjMlVzWENKcGMwaHBaR1ZrWENJNlptRnNjMlVzWENKcGMxTnZiRzlsWkZ3aU9tWmhiSE5sTEZ3aWMyaHZkMVJ5WVc1elptOXliVndpT2x3aWNHVnljM0JsWTNScGRtVW9NakF3TUhCNEtTQjBjbUZ1YzJ4aGRHVlpLREUxTUhCNEtTQmNJaXhjSW5Ob2IzZFBjbWxuYVc1Y0lqcGNJalV3SlNBMU1DVWdNSEI0WENJc1hDSnphRzkzUm1Ga1pWd2lPblJ5ZFdVc1hDSm9hV1JsVkhKaGJuTm1iM0p0WENJNlhDSmNJaXhjSW1ocFpHVlBjbWxuYVc1Y0lqcGNJbHdpTEZ3aWFHbGtaVVpoWkdWY0lqcDBjblZsTEZ3aWFXMW5WR2gxYldKY0lqcGNJaTh5TURFMEx6QTBMMnhoY0hSdmNDMHhOVEI0TVRVd0xuQnVaMXdpTEZ3aWIzSmtaWEpjSWpvd0xGd2lkSGx3WlZ3aU9sd2lhVzFoWjJWY0lpeGNJbU52Ym5SbGJuUmNJanBjSWt4dmNtVnRJRWx3YzNWdFhDSXNYQ0pwYldkY0lqcGNJaTh5TURFMEx6QTBMMnhoY0hSdmNDNXdibWRjSWl4Y0luWnBaR1Z2WENJNlhDSm9kSFJ3T2k4dmNHeGhlV1Z5TG5acGJXVnZMbU52YlM5MmFXUmxieTh4TVRjeU1USTBNbHdpTEZ3aVlXeHBaMjVjSWpwY0luUnZjRndpTEZ3aWIyWm1jMlYwV0Z3aU9qQXNYQ0p2Wm1aelpYUlpYQ0k2TUN4Y0luSmxjMmw2WlZ3aU9uUnlkV1VzWENKM2FXUjBhR3hwYldsMFhDSTZYQ0l3WENJc1hDSnphRzkzUkhWeVlYUnBiMjVjSWpveUxGd2ljMmh2ZDBSbGJHRjVYQ0k2TUN4Y0luTm9iM2RGWVhObFhDSTZYQ0psWVhObFQzVjBVWFZwYm5SY0lpeGNJbk5vYjNkRlptWkdkVzVqWENJNlhDSjBLSFJ5ZFdVc2Jpd3hOVEFzYml4dUxHNHNiaXh1TEc0c2JpeHVMRzRzYml4dUxHNHBYQ0lzWENKMWMyVklhV1JsWENJNlptRnNjMlVzWENKb2FXUmxSSFZ5WVhScGIyNWNJam94TEZ3aWFHbGtaVVJsYkdGNVhDSTZNU3hjSW1ocFpHVkZZWE5sWENJNlhDSmxZWE5sVDNWMFVYVnBiblJjSWl4Y0luTnNhV1JsWENJNk15eGNJbk4wZVd4bFRXOWtaV3hjSWpveE1TeGNJbk5vYjNkRlptWmxZM1JjSWpveU1TeGNJbWhwWkdWRlptWmxZM1JjSWpveU1uMGlMQ0l4TWlJNkludGNJbWxrWENJNk1USXNYQ0p1WVcxbFhDSTZYQ0oyYVdSbGIxd2lMRndpYVhOTWIyTnJaV1JjSWpwbVlXeHpaU3hjSW1selNHbGtaV1JjSWpwbVlXeHpaU3hjSW1selUyOXNiMlZrWENJNlptRnNjMlVzWENKemFHOTNWSEpoYm5ObWIzSnRYQ0k2WENKY0lpeGNJbk5vYjNkUGNtbG5hVzVjSWpwY0lsd2lMRndpYzJodmQwWmhaR1ZjSWpwMGNuVmxMRndpYUdsa1pWUnlZVzV6Wm05eWJWd2lPbHdpWENJc1hDSm9hV1JsVDNKcFoybHVYQ0k2WENKY0lpeGNJbWhwWkdWR1lXUmxYQ0k2ZEhKMVpTeGNJbTl5WkdWeVhDSTZNU3hjSW5SNWNHVmNJanBjSW5acFpHVnZYQ0lzWENKamIyNTBaVzUwWENJNlhDSk1iM0psYlNCSmNITjFiVndpTEZ3aWRtbGtaVzljSWpwY0ltaDBkSEE2THk5d2JHRjVaWEl1ZG1sdFpXOHVZMjl0TDNacFpHVnZMelk0TWpBNE9EY3hYQ0lzWENKaGJHbG5ibHdpT2x3aWRHOXdYQ0lzWENKdlptWnpaWFJZWENJNk1qWXhMRndpYjJabWMyVjBXVndpT2pFeE1TeGNJbmRwWkhSb1hDSTZORGM0TEZ3aWFHVnBaMmgwWENJNk1qazVMRndpY21WemFYcGxYQ0k2ZEhKMVpTeGNJbmRwWkhSb2JHbHRhWFJjSWpwY0lqQmNJaXhjSW5Ob2IzZEVkWEpoZEdsdmJsd2lPakVzWENKemFHOTNSR1ZzWVhsY0lqb3hMamszTlN4Y0luTm9iM2RGWVhObFhDSTZYQ0psWVhObFQzVjBVWFZwYm5SY0lpeGNJblZ6WlVocFpHVmNJanBtWVd4elpTeGNJbWhwWkdWRWRYSmhkR2x2Ymx3aU9qRXNYQ0pvYVdSbFJHVnNZWGxjSWpveExGd2lhR2xrWlVWaGMyVmNJanBjSW1WaGMyVlBkWFJSZFdsdWRGd2lMRndpYzJ4cFpHVmNJam96TEZ3aWMzUjViR1ZOYjJSbGJGd2lPakV5TEZ3aWMyaHZkMFZtWm1WamRGd2lPakl6TEZ3aWFHbGtaVVZtWm1WamRGd2lPakkwZlNJc0lqRXpJam9pZTF3aWFXUmNJam94TXl4Y0ltNWhiV1ZjSWpwY0luUnBkR3hsWENJc1hDSnBjMHh2WTJ0bFpGd2lPbVpoYkhObExGd2lhWE5JYVdSbFpGd2lPbVpoYkhObExGd2lhWE5UYjJ4dlpXUmNJanBtWVd4elpTeGNJbk5vYjNkVWNtRnVjMlp2Y20xY0lqcGNJbkJsY25Od1pXTjBhWFpsS0RJd01EQndlQ2tnZEhKaGJuTnNZWFJsV1NndE1UVXdjSGdwSUZ3aUxGd2ljMmh2ZDA5eWFXZHBibHdpT2x3aU5UQWxJRFV3SlNBd2NIaGNJaXhjSW5Ob2IzZEdZV1JsWENJNmRISjFaU3hjSW1ocFpHVlVjbUZ1YzJadmNtMWNJanBjSWx3aUxGd2lhR2xrWlU5eWFXZHBibHdpT2x3aVhDSXNYQ0pvYVdSbFJtRmtaVndpT25SeWRXVXNYQ0p2Y21SbGNsd2lPaklzWENKMGVYQmxYQ0k2WENKMFpYaDBYQ0lzWENKamIyNTBaVzUwWENJNlhDSk1UMUpGVFNCSlVGTlZUU0JFVDB4UFVpQlRTVlJjSWl4Y0luWnBaR1Z2WENJNlhDSm9kSFJ3T2k4dmNHeGhlV1Z5TG5acGJXVnZMbU52YlM5MmFXUmxieTh4TVRjeU1USTBNbHdpTEZ3aVlXeHBaMjVjSWpwY0luUnZjRndpTEZ3aWIyWm1jMlYwV0Z3aU9qTXhPUzQxTEZ3aWIyWm1jMlYwV1Z3aU9qSTRMRndpY21WemFYcGxYQ0k2ZEhKMVpTeGNJbmRwWkhSb2JHbHRhWFJjSWpwY0lqQmNJaXhjSW1Oc1lYTnpUbUZ0WlZ3aU9sd2liWE53TFdOdUxUa3RNVE5jSWl4Y0luTm9iM2RFZFhKaGRHbHZibHdpT2pFdU5TeGNJbk5vYjNkRVpXeGhlVndpT2pBc1hDSnphRzkzUldGelpWd2lPbHdpWldGelpVOTFkRkYxYVc1MFhDSXNYQ0p6YUc5M1JXWm1SblZ1WTF3aU9sd2lkQ2gwY25WbExHNHNMVEUxTUN4dUxHNHNiaXh1TEc0c2JpeHVMRzRzYml4dUxHNHNiaWxjSWl4Y0luVnpaVWhwWkdWY0lqcG1ZV3h6WlN4Y0ltaHBaR1ZFZFhKaGRHbHZibHdpT2pFc1hDSm9hV1JsUkdWc1lYbGNJam94TEZ3aWFHbGtaVVZoYzJWY0lqcGNJbVZoYzJWUGRYUlJkV2x1ZEZ3aUxGd2ljMnhwWkdWY0lqb3pMRndpYzNSNWJHVk5iMlJsYkZ3aU9qRXpMRndpYzJodmQwVm1abVZqZEZ3aU9qSTFMRndpYUdsa1pVVm1abVZqZEZ3aU9qSTJmU0lzSWpFMElqb2llMXdpYVdSY0lqb3hOQ3hjSW01aGJXVmNJanBjSW5ScGRHeGxYQ0lzWENKcGMweHZZMnRsWkZ3aU9tWmhiSE5sTEZ3aWFYTklhV1JsWkZ3aU9tWmhiSE5sTEZ3aWFYTlRiMnh2WldSY0lqcG1ZV3h6WlN4Y0luTm9iM2RVY21GdWMyWnZjbTFjSWpwY0luQmxjbk53WldOMGFYWmxLREl3TURCd2VDa2djMk5oYkdWWUtERXVOU2tnYzJOaGJHVlpLREV1TlNrZ1hDSXNYQ0p6YUc5M1QzSnBaMmx1WENJNlhDSTFNQ1VnTlRBbElEQndlRndpTEZ3aWMyaHZkMFpoWkdWY0lqcDBjblZsTEZ3aWFHbGtaVlJ5WVc1elptOXliVndpT2x3aVhDSXNYQ0pvYVdSbFQzSnBaMmx1WENJNlhDSmNJaXhjSW1ocFpHVkdZV1JsWENJNmRISjFaU3hjSW05eVpHVnlYQ0k2TXl4Y0luUjVjR1ZjSWpwY0luUmxlSFJjSWl4Y0ltTnZiblJsYm5SY0lqcGNJa1JQVEU5U0lGTkpWQ0JCVFVWVVhDSXNYQ0oyYVdSbGIxd2lPbHdpYUhSMGNEb3ZMM0JzWVhsbGNpNTJhVzFsYnk1amIyMHZkbWxrWlc4dk1URTNNakV5TkRKY0lpeGNJbUZzYVdkdVhDSTZYQ0owYjNCY0lpeGNJbTltWm5ObGRGaGNJam94TmpBc1hDSnZabVp6WlhSWlhDSTZNVGd4TEZ3aWNtVnphWHBsWENJNmRISjFaU3hjSW5kcFpIUm9iR2x0YVhSY0lqcGNJakJjSWl4Y0ltTnNZWE56VG1GdFpWd2lPbHdpYlhOd0xXTnVMVEUzTWkweE5Gd2lMRndpYzJodmQwUjFjbUYwYVc5dVhDSTZNU3hjSW5Ob2IzZEVaV3hoZVZ3aU9qRXVOVEkxTEZ3aWMyaHZkMFZoYzJWY0lqcGNJbVZoYzJWUGRYUkNZV05yWENJc1hDSnphRzkzUldabVJuVnVZMXdpT2x3aWRDaDBjblZsTEc0c2JpeHVMRzRzYml4dUxHNHNNUzQxTERFdU5TeHVMRzRzYml4dUxHNHBYQ0lzWENKMWMyVklhV1JsWENJNlptRnNjMlVzWENKb2FXUmxSSFZ5WVhScGIyNWNJam94TEZ3aWFHbGtaVVJsYkdGNVhDSTZNU3hjSW1ocFpHVkZZWE5sWENJNlhDSmxZWE5sVDNWMFVYVnBiblJjSWl4Y0luTnNhV1JsWENJNk1peGNJbk4wZVd4bFRXOWtaV3hjSWpveE5DeGNJbk5vYjNkRlptWmxZM1JjSWpveU55eGNJbWhwWkdWRlptWmxZM1JjSWpveU9IMGlmU3dpVFZOUVlXNWxiQzVEYjI1MGNtOXNJanA3SWpFaU9pSjdYQ0pwWkZ3aU9sd2lNVndpTEZ3aWJHRmlaV3hjSWpwY0lrRnljbTkzYzF3aUxGd2libUZ0WlZ3aU9sd2lZWEp5YjNkelhDSXNYQ0poZFhSdlNHbGtaVndpT25SeWRXVXNYQ0p2ZG1WeVZtbGtaVzljSWpwMGNuVmxMRndpYVc1elpYUmNJanAwY25WbGZTSXNJaklpT2lKN1hDSnBaRndpT2pJc1hDSnNZV0psYkZ3aU9sd2lUR2x1WlNCVWFXMWxjbHdpTEZ3aWJtRnRaVndpT2x3aWRHbHRaV0poY2x3aUxGd2lZWFYwYjBocFpHVmNJanBtWVd4elpTeGNJbTkyWlhKV2FXUmxiMXdpT25SeWRXVXNYQ0pqYjJ4dmNsd2lPbHdpSXpSak5HTTBZMXdpTEZ3aWQybGtkR2hjSWpveUxGd2lZV3hwWjI1Y0lqcGNJbUp2ZEhSdmJWd2lMRndpYVc1elpYUmNJanAwY25WbGZTSXNJak1pT2lKN1hDSnBaRndpT2pNc1hDSnNZV0psYkZ3aU9sd2lRblZzYkdWMGMxd2lMRndpYm1GdFpWd2lPbHdpWW5Wc2JHVjBjMXdpTEZ3aVlYVjBiMGhwWkdWY0lqcDBjblZsTEZ3aWIzWmxjbFpwWkdWdlhDSTZkSEoxWlN4Y0ltMWhjbWRwYmx3aU9qRXdMRndpWkdseVhDSTZYQ0pvWENJc1hDSmhiR2xuYmx3aU9sd2lZbTkwZEc5dFhDSXNYQ0pwYm5ObGRGd2lPblJ5ZFdWOUlpd2lOQ0k2SW50Y0ltbGtYQ0k2TkN4Y0lteGhZbVZzWENJNlhDSkRhWEpqYkdVZ1ZHbHRaWEpjSWl4Y0ltNWhiV1ZjSWpwY0ltTnBjbU5zWlhScGJXVnlYQ0lzWENKaGRYUnZTR2xrWlZ3aU9tWmhiSE5sTEZ3aWIzWmxjbFpwWkdWdlhDSTZkSEoxWlN4Y0ltTnZiRzl5WENJNlhDSWpNamN5TnpJM1hDSXNYQ0p5WVdScGRYTmNJam94TUN4Y0luTjBjbTlyWlZ3aU9qSXNYQ0pwYm5ObGRGd2lPblJ5ZFdWOUluMTkiLCJ0eXBlIjoiY3VzdG9tIiwic2xpZGVzX251bSI6IjMifX0sIm9yaWdpbl91cGxvYWRzX3VybCI6Imh0dHA6XC9cL2RlbW8uYXZlcnRhLm5ldFwvdGhlbWVzXC9sb3R1c1wvZHVtbXktYWdlbmN5XC93cC1jb250ZW50XC91cGxvYWRzIiwicHJlc2V0X3N0eWxlcyI6IiIsInByZXNldF9lZmZlY3RzIjoiIn0=',
			'image_dir' => '',
			'selected' 	=> '',
			'screenshot'=> MSWP_AVERTA_ADMIN_URL . '/assets/images/starters/creative-agency.jpg'
		),
		array(
			'label' 	=> __( 'Showcase', MSWP_TEXT_DOMAIN ),
			'id' 		=> 'showcase1',
			'slidertype'=> 'custom',
			'importdata'=> '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',
			'image_dir' => '',
			'selected' 	=> '',
			'screenshot'=> MSWP_AVERTA_ADMIN_URL . '/assets/images/starters/showcase.jpg'
		),
		array(
			'label' 	=> __( 'Slider in Display', MSWP_TEXT_DOMAIN ),
			'id' 		=> 'slider-in-display',
			'slidertype'=> 'custom',
			'importdata'=> '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',
			'image_dir' => '',
			'selected' 	=> '',
			'screenshot'=> MSWP_AVERTA_ADMIN_URL . '/assets/images/starters/slider-in-display.jpg'
		),
		array(
			'label' 	=> __( 'Slider in Laptop', MSWP_TEXT_DOMAIN ),
			'id' 		=> 'slider-in-laptop',
			'slidertype'=> 'custom',
			'importdata'=> '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',
			'image_dir' => '',
			'selected' 	=> '',
			'screenshot'=> MSWP_AVERTA_ADMIN_URL . '/assets/images/starters/slider-in-laptop.jpg'
		),
		array(
			'label' 	=> __( 'Slider With Horizontal Tabs', MSWP_TEXT_DOMAIN ),
			'id' 		=> 'slider-with-horizontal-tabs',
			'slidertype'=> 'custom',
			'importdata'=> 'eyJzbGlkZXJzX2RhdGEiOnsiMTMiOnsidGl0bGUiOiJTbGlkZXIgd2l0aCBIb3Jpem9udGFsIFRhYnMiLCJwYXJhbXMiOiJleUp0WlhSaElqcDdJbE5sZEhScGJtZHpJV2xrY3lJNklqRWlMQ0pUWlhSMGFXNW5jeUZ1WlhoMFNXUWlPaklzSWxOc2FXUmxJV2xrY3lJNklqRXNOQ3cxTERZc055dzRJaXdpVTJ4cFpHVWhibVY0ZEVsa0lqbzVMQ0pEYjI1MGNtOXNJV2xrY3lJNklqRXNNaXd6SWl3aVEyOXVkSEp2YkNGdVpYaDBTV1FpT2pSOUxDSk5VMUJoYm1Wc0xsTmxkSFJwYm1keklqcDdJakVpT2lKN1hDSnBaRndpT2x3aU1Wd2lMRndpYzI1aGNIQnBibWRjSWpwMGNuVmxMRndpYm1GdFpWd2lPbHdpVTJ4cFpHVnlJSGRwZEdnZ1NHOXlhWHB2Ym5SaGJDQlVZV0p6WENJc1hDSjNhV1IwYUZ3aU9qRXdNREFzWENKb1pXbG5hSFJjSWpvMU1EQXNYQ0ozY21Gd2NHVnlWMmxrZEdoY0lqb3hNREF3TEZ3aWQzSmhjSEJsY2xkcFpIUm9WVzVwZEZ3aU9sd2ljSGhjSWl4Y0ltRjFkRzlEY205d1hDSTZabUZzYzJVc1hDSnNZWGx2ZFhSY0lqcGNJbUp2ZUdWa1hDSXNYQ0poZFhSdlNHVnBaMmgwWENJNlptRnNjMlVzWENKMGNsWnBaWGRjSWpwY0ltSmhjMmxqWENJc1hDSnpjR1ZsWkZ3aU9qSXdMRndpYzNCaFkyVmNJam93TEZ3aWMzUmhjblJjSWpveExGd2laM0poWWtOMWNuTnZjbHdpT25SeWRXVXNYQ0p6ZDJsd1pWd2lPblJ5ZFdVc1hDSnRiM1Z6WlZ3aU9uUnlkV1VzWENKM2FHVmxiRndpT21aaGJITmxMRndpWVhWMGIzQnNZWGxjSWpwbVlXeHpaU3hjSW14dmIzQmNJanBtWVd4elpTeGNJbk5vZFdabWJHVmNJanBtWVd4elpTeGNJbkJ5Wld4dllXUmNJam94TEZ3aWIzWmxjbEJoZFhObFhDSTZkSEoxWlN4Y0ltVnVaRkJoZFhObFhDSTZabUZzYzJVc1hDSm9hV1JsVEdGNVpYSnpYQ0k2Wm1Gc2MyVXNYQ0prYVhKY0lqcGNJbWhjSWl4Y0ltTmxiblJsY2tOdmJuUnliMnh6WENJNmRISjFaU3hjSW1sdWMzUmhiblJUYUc5M1RHRjVaWEp6WENJNlptRnNjMlVzWENKemEybHVYQ0k2WENKdGN5MXphMmx1TFd4cFoyaDBMVEpjSWl4Y0ltMXpWR1Z0Y0d4aGRHVmNJanBjSW5Oc2FXUmxjaTFvYjNKcGVtOXVkR0ZzTFhSaFluTmNJaXhjSW0xelZHVnRjR3hoZEdWRGJHRnpjMXdpT2x3aWJYTXRkR0ZpY3kxMFpXMXdiR0YwWlZ3aUxGd2lkWE5sWkVadmJuUnpYQ0k2WENKY0luMGlmU3dpVFZOUVlXNWxiQzVUYkdsa1pTSTZleUl4SWpvaWUxd2lhV1JjSWpwY0lqRmNJaXhjSW5ScGJXVnNhVzVsWDJoY0lqb3lNREFzWENKaVoxUm9kVzFpWENJNlhDSXZNakF4TkM4d05DODJPRGMyTXpnMU5UVTFYemMwWVRCa04yUTNaV1ZmWWkweE5UQjRNVFV3TG1wd1oxd2lMRndpYjNKa1pYSmNJam93TEZ3aVltZGNJanBjSWk4eU1ERTBMekEwTHpZNE56WXpPRFUxTlRWZk56UmhNR1EzWkRkbFpWOWlMbXB3WjF3aUxGd2laSFZ5WVhScGIyNWNJam96TEZ3aVptbHNiRTF2WkdWY0lqcGNJbVpwYkd4Y0lpeGNJbWx1Wm05Y0lqcGNJanh3UGp4emRISnZibWMrVTBGTlVFeEZJRlJKVkV4RlBDOXpkSEp2Ym1jK1BHSnlJQzgrVEc5eVpXMGdhWEJ6ZFcwZ1pHOXNiM0lnYzJsMElHRnRaWFFzSUdOdmJuTmxZM1JsZEhWbGNpQmxiR2wwUEdKeUlDOCtVMnhwWkdWeUlIZHBkR2dnU0c5eWFYcHZiblJoYkNCVVlXSnpQQzl3UGx3aUxGd2lZbWQyWDJacGJHeHRiMlJsWENJNlhDSm1hV3hzWENJc1hDSmlaM1pmYkc5dmNGd2lPblJ5ZFdVc1hDSmlaM1pmYlhWMFpWd2lPblJ5ZFdVc1hDSmlaM1pmWVhWMGIzQmhkWE5sWENJNlptRnNjMlVzWENKc1lYbGxjbDlwWkhOY0lqcGJYWDBpTENJMElqb2llMXdpYVdSY0lqbzBMRndpZEdsdFpXeHBibVZmYUZ3aU9qSXdNQ3hjSW1KblZHaDFiV0pjSWpwY0lpOHlNREUwTHpBMEx6WTROell6T1RFeU1UZGZZV0l5WldaaE9XTXpPVjlpTFRFMU1IZ3hOVEF1YW5CblhDSXNYQ0p2Y21SbGNsd2lPalVzWENKaVoxd2lPbHdpTHpJd01UUXZNRFF2TmpnM05qTTVNVEl4TjE5aFlqSmxabUU1WXpNNVgySXVhbkJuWENJc1hDSmtkWEpoZEdsdmJsd2lPak1zWENKbWFXeHNUVzlrWlZ3aU9sd2labWxzYkZ3aUxGd2lhVzVtYjF3aU9sd2lQSEErUEhOMGNtOXVaejVUUVUxUVRFVWdWRWxVVEVVOEwzTjBjbTl1Wno0OFluSWdMejVNYjNKbGJTQnBjSE4xYlNCa2IyeHZjaUJ6YVhRZ1lXMWxkQ3dnWTI5dWMyVmpkR1YwZFdWeUlHVnNhWFE4WW5JZ0x6NVRiR2xrWlhJZ2QybDBhQ0JJYjNKcGVtOXVkR0ZzSUZSaFluTThMM0ErWENJc1hDSmlaM1pmWm1sc2JHMXZaR1ZjSWpwY0ltWnBiR3hjSWl4Y0ltSm5kbDlzYjI5d1hDSTZkSEoxWlN4Y0ltSm5kbDl0ZFhSbFhDSTZkSEoxWlN4Y0ltSm5kbDloZFhSdmNHRjFjMlZjSWpwbVlXeHpaU3hjSW14aGVXVnlYMmxrYzF3aU9sdGRmU0lzSWpVaU9pSjdYQ0pwWkZ3aU9qVXNYQ0owYVcxbGJHbHVaVjlvWENJNk1qQXdMRndpWW1kVWFIVnRZbHdpT2x3aUx6SXdNVFF2TURRdk5qZzNOak01TURNek9WOHlaVFJrWkRsa1ltSmlYMkl0TVRVd2VERTFNQzVxY0dkY0lpeGNJbTl5WkdWeVhDSTZOQ3hjSW1KblhDSTZYQ0l2TWpBeE5DOHdOQzgyT0RjMk16a3dNek01WHpKbE5HUmtPV1JpWW1KZllpNXFjR2RjSWl4Y0ltUjFjbUYwYVc5dVhDSTZNeXhjSW1acGJHeE5iMlJsWENJNlhDSm1hV3hzWENJc1hDSnBibVp2WENJNlhDSThjRDQ4YzNSeWIyNW5QbE5CVFZCTVJTQlVTVlJNUlR3dmMzUnliMjVuUGp4aWNpQXZQa3h2Y21WdElHbHdjM1Z0SUdSdmJHOXlJSE5wZENCaGJXVjBMQ0JqYjI1elpXTjBaWFIxWlhJZ1pXeHBkRHhpY2lBdlBsTnNhV1JsY2lCM2FYUm9JRWh2Y21sNmIyNTBZV3dnVkdGaWN6d3ZjRDVjSWl4Y0ltSm5kbDltYVd4c2JXOWtaVndpT2x3aVptbHNiRndpTEZ3aVltZDJYMnh2YjNCY0lqcDBjblZsTEZ3aVltZDJYMjExZEdWY0lqcDBjblZsTEZ3aVltZDJYMkYxZEc5d1lYVnpaVndpT21aaGJITmxMRndpYkdGNVpYSmZhV1J6WENJNlcxMTlJaXdpTmlJNkludGNJbWxrWENJNk5peGNJblJwYldWc2FXNWxYMmhjSWpveU1EQXNYQ0ppWjFSb2RXMWlYQ0k2WENJdk1qQXhOQzh3TkM4Mk9EYzJNemc1TkRZelgyUmlNamRoTXpjM1pURmZZaTB4TlRCNE1UVXdMbXB3WjF3aUxGd2liM0prWlhKY0lqb3pMRndpWW1kY0lqcGNJaTh5TURFMEx6QTBMelk0TnpZek9EazBOak5mWkdJeU4yRXpOemRsTVY5aUxtcHdaMXdpTEZ3aVpIVnlZWFJwYjI1Y0lqb3pMRndpWm1sc2JFMXZaR1ZjSWpwY0ltWnBiR3hjSWl4Y0ltbHVabTljSWpwY0lqeHdQanh6ZEhKdmJtYytVMEZOVUV4RklGUkpWRXhGUEM5emRISnZibWMrUEdKeUlDOCtURzl5WlcwZ2FYQnpkVzBnWkc5c2IzSWdjMmwwSUdGdFpYUXNJR052Ym5ObFkzUmxkSFZsY2lCbGJHbDBQR0p5SUM4K1UyeHBaR1Z5SUhkcGRHZ2dTRzl5YVhwdmJuUmhiQ0JVWVdKelBDOXdQbHdpTEZ3aVltZDJYMlpwYkd4dGIyUmxYQ0k2WENKbWFXeHNYQ0lzWENKaVozWmZiRzl2Y0Z3aU9uUnlkV1VzWENKaVozWmZiWFYwWlZ3aU9uUnlkV1VzWENKaVozWmZZWFYwYjNCaGRYTmxYQ0k2Wm1Gc2MyVXNYQ0pzWVhsbGNsOXBaSE5jSWpwYlhYMGlMQ0kzSWpvaWUxd2lhV1JjSWpvM0xGd2lkR2x0Wld4cGJtVmZhRndpT2pJd01DeGNJbUpuVkdoMWJXSmNJanBjSWk4eU1ERTBMekEwTHpZNE56WXpPRGcxTVRGZlpEWXhPR1ExTXpRMU5WOWlMVEUxTUhneE5UQXVhbkJuWENJc1hDSnZjbVJsY2x3aU9qSXNYQ0ppWjF3aU9sd2lMekl3TVRRdk1EUXZOamczTmpNNE9EVXhNVjlrTmpFNFpEVXpORFUxWDJJdWFuQm5YQ0lzWENKa2RYSmhkR2x2Ymx3aU9qTXNYQ0ptYVd4c1RXOWtaVndpT2x3aVptbHNiRndpTEZ3aWFXNW1iMXdpT2x3aVBIQStQSE4wY205dVp6NVRRVTFRVEVVZ1ZFbFVURVU4TDNOMGNtOXVaejQ4WW5JZ0x6NU1iM0psYlNCcGNITjFiU0JrYjJ4dmNpQnphWFFnWVcxbGRDd2dZMjl1YzJWamRHVjBkV1Z5SUdWc2FYUThZbklnTHo1VGJHbGtaWElnZDJsMGFDQkliM0pwZW05dWRHRnNJRlJoWW5NOEwzQStYQ0lzWENKaVozWmZabWxzYkcxdlpHVmNJanBjSW1acGJHeGNJaXhjSW1KbmRsOXNiMjl3WENJNmRISjFaU3hjSW1KbmRsOXRkWFJsWENJNmRISjFaU3hjSW1KbmRsOWhkWFJ2Y0dGMWMyVmNJanBtWVd4elpTeGNJbXhoZVdWeVgybGtjMXdpT2x0ZGZTSXNJamdpT2lKN1hDSnBaRndpT2pnc1hDSjBhVzFsYkdsdVpWOW9YQ0k2TWpBd0xGd2lZbWRVYUhWdFlsd2lPbHdpTHpJd01UUXZNRFF2TmpnM05qTTROelF6TVY5a09EWTROamRoTTJRNVgySXRNVFV3ZURFMU1DNXFjR2RjSWl4Y0ltOXlaR1Z5WENJNk1TeGNJbUpuWENJNlhDSXZNakF4TkM4d05DODJPRGMyTXpnM05ETXhYMlE0TmpnMk4yRXpaRGxmWWk1cWNHZGNJaXhjSW1SMWNtRjBhVzl1WENJNk15eGNJbVpwYkd4TmIyUmxYQ0k2WENKbWFXeHNYQ0lzWENKcGJtWnZYQ0k2WENJOGNENDhjM1J5YjI1blBsTkJUVkJNUlNCVVNWUk1SVHd2YzNSeWIyNW5QanhpY2lBdlBreHZjbVZ0SUdsd2MzVnRJR1J2Ykc5eUlITnBkQ0JoYldWMExDQmpiMjV6WldOMFpYUjFaWElnWld4cGREeGljaUF2UGxOc2FXUmxjaUIzYVhSb0lFaHZjbWw2YjI1MFlXd2dWR0ZpY3p3dmNENWNJaXhjSW1KbmRsOW1hV3hzYlc5a1pWd2lPbHdpWm1sc2JGd2lMRndpWW1kMlgyeHZiM0JjSWpwMGNuVmxMRndpWW1kMlgyMTFkR1ZjSWpwMGNuVmxMRndpWW1kMlgyRjFkRzl3WVhWelpWd2lPbVpoYkhObExGd2liR0Y1WlhKZmFXUnpYQ0k2VzExOUluMHNJazFUVUdGdVpXd3VRMjl1ZEhKdmJDSTZleUl4SWpvaWUxd2lhV1JjSWpwY0lqRmNJaXhjSW14aFltVnNYQ0k2WENKQmNuSnZkM05jSWl4Y0ltNWhiV1ZjSWpwY0ltRnljbTkzYzF3aUxGd2lZWFYwYjBocFpHVmNJanAwY25WbExGd2liM1psY2xacFpHVnZYQ0k2ZEhKMVpTeGNJbWx1YzJWMFhDSTZkSEoxWlgwaUxDSXlJam9pZTF3aWFXUmNJam95TEZ3aWJHRmlaV3hjSWpwY0lrTnBjbU5zWlNCVWFXMWxjbHdpTEZ3aWJtRnRaVndpT2x3aVkybHlZMnhsZEdsdFpYSmNJaXhjSW1GMWRHOUlhV1JsWENJNlptRnNjMlVzWENKdmRtVnlWbWxrWlc5Y0lqcDBjblZsTEZ3aVkyOXNiM0pjSWpwY0lpTkdSa1pHUmtaY0lpeGNJbkpoWkdsMWMxd2lPalFzWENKemRISnZhMlZjSWpvNUxGd2lhVzV6WlhSY0lqcDBjblZsZlNJc0lqTWlPaUo3WENKcFpGd2lPak1zWENKc1lXSmxiRndpT2x3aVZHaDFiV0pzYVhOMEwxUmhZbk5jSWl4Y0ltNWhiV1ZjSWpwY0luUm9kVzFpYkdsemRGd2lMRndpWVhWMGIwaHBaR1ZjSWpwbVlXeHpaU3hjSW05MlpYSldhV1JsYjF3aU9uUnlkV1VzWENKdFlYSm5hVzVjSWpvdE1USXNYQ0prYVhKY0lqcGNJbWhjSWl4Y0luTndZV05sWENJNk1DeGNJblI1Y0dWY0lqcGNJblJoWW5OY0lpeGNJbmRwWkhSb1hDSTZNalF3TEZ3aWFHVnBaMmgwWENJNk1USXdMRndpWVd4cFoyNWNJanBjSW1KdmRIUnZiVndpTEZ3aWFXNXpaWFJjSWpwbVlXeHpaU3hjSW1ocFpHVlZibVJsY2x3aU9qUXdNSDBpZlgwPSIsInR5cGUiOiJjdXN0b20iLCJzbGlkZXNfbnVtIjoiNiJ9fSwib3JpZ2luX3VwbG9hZHNfdXJsIjoiaHR0cDpcL1wvZGVtby5hdmVydGEubmV0XC90aGVtZXNcL2xvdHVzXC9kdW1teS1hZ2VuY3lcL3dwLWNvbnRlbnRcL3VwbG9hZHMiLCJwcmVzZXRfc3R5bGVzIjoiIiwicHJlc2V0X2VmZmVjdHMiOiIifQ==',
			'image_dir' => '',
			'selected' 	=> '',
			'screenshot'=> MSWP_AVERTA_ADMIN_URL . '/assets/images/starters/slider-with-horizontal-tabs.jpg'
		),
		array(
			'label' 	=> __( 'Slider With Vertical Thumbs', MSWP_TEXT_DOMAIN ),
			'id' 		=> 'slider-with-vertical-thumbs',
			'slidertype'=> 'custom',
			'importdata'=> 'eyJzbGlkZXJzX2RhdGEiOnsiMTciOnsidGl0bGUiOiJTbGlkZXIgd2l0aCBWZXJ0aWNhbCBUaHVtYnMiLCJwYXJhbXMiOiJleUp0WlhSaElqcDdJbE5sZEhScGJtZHpJV2xrY3lJNklqRWlMQ0pUWlhSMGFXNW5jeUZ1WlhoMFNXUWlPaklzSWxOc2FXUmxJV2xrY3lJNklqRXNNaXd6TERRc05TdzJMRGNzT0N3NUxERXdMREV4TERFeklpd2lVMnhwWkdVaGJtVjRkRWxrSWpveE5Dd2lRMjl1ZEhKdmJDRnBaSE1pT2lJeExESXNNeUlzSWtOdmJuUnliMndoYm1WNGRFbGtJam8wZlN3aVRWTlFZVzVsYkM1VFpYUjBhVzVuY3lJNmV5SXhJam9pZTF3aWFXUmNJanBjSWpGY0lpeGNJbk51WVhCd2FXNW5YQ0k2ZEhKMVpTeGNJbTVoYldWY0lqcGNJbE5zYVdSbGNpQjNhWFJvSUZabGNuUnBZMkZzSUZSb2RXMWljMXdpTEZ3aWQybGtkR2hjSWpveE1EQXdMRndpYUdWcFoyaDBYQ0k2TlRBd0xGd2lkM0poY0hCbGNsZHBaSFJvWENJNk1UQXdNQ3hjSW5keVlYQndaWEpYYVdSMGFGVnVhWFJjSWpwY0luQjRYQ0lzWENKaGRYUnZRM0p2Y0Z3aU9tWmhiSE5sTEZ3aWJHRjViM1YwWENJNlhDSmliM2hsWkZ3aUxGd2lZWFYwYjBobGFXZG9kRndpT25SeWRXVXNYQ0owY2xacFpYZGNJanBjSW1KaGMybGpYQ0lzWENKemNHVmxaRndpT2pJd0xGd2ljM0JoWTJWY0lqb3dMRndpYzNSaGNuUmNJam94TEZ3aVozSmhZa04xY25OdmNsd2lPblJ5ZFdVc1hDSnpkMmx3WlZ3aU9uUnlkV1VzWENKdGIzVnpaVndpT25SeWRXVXNYQ0ozYUdWbGJGd2lPbVpoYkhObExGd2lZWFYwYjNCc1lYbGNJanAwY25WbExGd2liRzl2Y0Z3aU9tWmhiSE5sTEZ3aWMyaDFabVpzWlZ3aU9tWmhiSE5sTEZ3aWNISmxiRzloWkZ3aU9qRXNYQ0p2ZG1WeVVHRjFjMlZjSWpwMGNuVmxMRndpWlc1a1VHRjFjMlZjSWpwbVlXeHpaU3hjSW1ocFpHVk1ZWGxsY25OY0lqcG1ZV3h6WlN4Y0ltUnBjbHdpT2x3aWFGd2lMRndpWTJWdWRHVnlRMjl1ZEhKdmJITmNJanBtWVd4elpTeGNJbWx1YzNSaGJuUlRhRzkzVEdGNVpYSnpYQ0k2Wm1Gc2MyVXNYQ0p6YTJsdVhDSTZYQ0p0Y3kxemEybHVMV3hwWjJoMExUTmNJaXhjSW0xelZHVnRjR3hoZEdWY0lqcGNJbk5zYVdSbGNpMTJaWEowYVdOaGJDMTBhSFZ0WW5OY0lpeGNJbTF6VkdWdGNHeGhkR1ZEYkdGemMxd2lPbHdpYlhNdGRHaDFiV0p6TFhSbGJYQnNZWFJsWENJc1hDSjFjMlZrUm05dWRITmNJanBjSWx3aWZTSjlMQ0pOVTFCaGJtVnNMbE5zYVdSbElqcDdJakVpT2lKN1hDSnBaRndpT2x3aU1Wd2lMRndpZEdsdFpXeHBibVZmYUZ3aU9qSXdNQ3hjSW1KblZHaDFiV0pjSWpwY0lpOHlNREUwTHpBMEx6WTVOalk1TmpVd05UZGZOMk15WWpBMU5EUTFNbDl2TFRFMU1IZ3hOVEF1YW5CblhDSXNYQ0owYUhWdFlrOXlaMmx1WVd4Y0lqcGNJaTh5TURFMEx6QTBMelk1TmpZNU5qVXdOVGRmTjJNeVlqQTFORFExTWw5dkxtcHdaMXdpTEZ3aWIzSmtaWEpjSWpvd0xGd2lZbWRjSWpwY0lpOHlNREUwTHpBMEx6WTVOalk1TmpVd05UZGZOMk15WWpBMU5EUTFNbDl2TG1wd1oxd2lMRndpWkhWeVlYUnBiMjVjSWpvekxGd2labWxzYkUxdlpHVmNJanBjSW1acGJHeGNJaXhjSW5Sb2RXMWlYQ0k2WENJdk1qQXhOQzh3TkM4Mk9UWTJPVFkxTURVM1h6ZGpNbUl3TlRRME5USmZieTB4TlRCNE1UVXdMbXB3WjF3aUxGd2lZbWQyWDJacGJHeHRiMlJsWENJNlhDSm1hV3hzWENJc1hDSmlaM1pmYkc5dmNGd2lPblJ5ZFdVc1hDSmlaM1pmYlhWMFpWd2lPblJ5ZFdVc1hDSmlaM1pmWVhWMGIzQmhkWE5sWENJNlptRnNjMlVzWENKc1lYbGxjbDlwWkhOY0lqcGJYWDBpTENJeUlqb2llMXdpYVdSY0lqb3lMRndpZEdsdFpXeHBibVZmYUZ3aU9qSXdNQ3hjSW1KblZHaDFiV0pjSWpwY0lpOHlNREUwTHpBMEx6WXhNamN5T0RJeE9UTmZOV0V4TVRRd09EUXpaVjl2TFRFMU1IZ3hOVEF1YW5CblhDSXNYQ0owYUhWdFlrOXlaMmx1WVd4Y0lqcGNJaTh5TURFMEx6QTBMell4TWpjeU9ESXhPVE5mTldFeE1UUXdPRFF6WlY5dkxtcHdaMXdpTEZ3aWIzSmtaWEpjSWpveExGd2lZbWRjSWpwY0lpOHlNREUwTHpBMEx6WXhNamN5T0RJeE9UTmZOV0V4TVRRd09EUXpaVjl2TG1wd1oxd2lMRndpWkhWeVlYUnBiMjVjSWpvekxGd2labWxzYkUxdlpHVmNJanBjSW1acGJHeGNJaXhjSW5Sb2RXMWlYQ0k2WENJdk1qQXhOQzh3TkM4Mk1USTNNamd5TVRrelh6VmhNVEUwTURnME0yVmZieTB4TlRCNE1UVXdMbXB3WjF3aUxGd2lZbWQyWDJacGJHeHRiMlJsWENJNlhDSm1hV3hzWENJc1hDSmlaM1pmYkc5dmNGd2lPblJ5ZFdVc1hDSmlaM1pmYlhWMFpWd2lPblJ5ZFdVc1hDSmlaM1pmWVhWMGIzQmhkWE5sWENJNlptRnNjMlVzWENKc1lYbGxjbDlwWkhOY0lqcGJYWDBpTENJeklqb2llMXdpYVdSY0lqb3pMRndpZEdsdFpXeHBibVZmYUZ3aU9qSXdNQ3hjSW1KblZHaDFiV0pjSWpwY0lpOHlNREUwTHpBMEx6WXdNVEkwTXpBMU56WmZOalprTkdFMU1EUmtPVjl2TFRFMU1IZ3hOVEF1YW5CblhDSXNYQ0owYUhWdFlrOXlaMmx1WVd4Y0lqcGNJaTh5TURFMEx6QTBMell3TVRJME16QTFOelpmTmpaa05HRTFNRFJrT1Y5dkxtcHdaMXdpTEZ3aWIzSmtaWEpjSWpveUxGd2lZbWRjSWpwY0lpOHlNREUwTHpBMEx6WXdNVEkwTXpBMU56WmZOalprTkdFMU1EUmtPVjl2TG1wd1oxd2lMRndpWkhWeVlYUnBiMjVjSWpvekxGd2labWxzYkUxdlpHVmNJanBjSW1acGJHeGNJaXhjSW5Sb2RXMWlYQ0k2WENJdk1qQXhOQzh3TkM4Mk1ERXlORE13TlRjMlh6WTJaRFJoTlRBMFpEbGZieTB4TlRCNE1UVXdMbXB3WjF3aUxGd2lZbWQyWDJacGJHeHRiMlJsWENJNlhDSm1hV3hzWENJc1hDSmlaM1pmYkc5dmNGd2lPblJ5ZFdVc1hDSmlaM1pmYlhWMFpWd2lPblJ5ZFdVc1hDSmlaM1pmWVhWMGIzQmhkWE5sWENJNlptRnNjMlVzWENKc1lYbGxjbDlwWkhOY0lqcGJYWDBpTENJMElqb2llMXdpYVdSY0lqbzBMRndpZEdsdFpXeHBibVZmYUZ3aU9qSXdNQ3hjSW1KblZHaDFiV0pjSWpwY0lpOHlNREUwTHpBMEx6VTVOek01TXpneU1qWmZOamxtWVRJek1qSXdaVjl2TFRFMU1IZ3hOVEF1YW5CblhDSXNYQ0owYUhWdFlrOXlaMmx1WVd4Y0lqcGNJaTh5TURFMEx6QTBMelU1TnpNNU16Z3lNalpmTmpsbVlUSXpNakl3WlY5dkxtcHdaMXdpTEZ3aWIzSmtaWEpjSWpvekxGd2lZbWRjSWpwY0lpOHlNREUwTHpBMEx6VTVOek01TXpneU1qWmZOamxtWVRJek1qSXdaVjl2TG1wd1oxd2lMRndpWkhWeVlYUnBiMjVjSWpvekxGd2labWxzYkUxdlpHVmNJanBjSW1acGJHeGNJaXhjSW5Sb2RXMWlYQ0k2WENJdk1qQXhOQzh3TkM4MU9UY3pPVE00TWpJMlh6WTVabUV5TXpJeU1HVmZieTB4TlRCNE1UVXdMbXB3WjF3aUxGd2lZbWQyWDJacGJHeHRiMlJsWENJNlhDSm1hV3hzWENJc1hDSmlaM1pmYkc5dmNGd2lPblJ5ZFdVc1hDSmlaM1pmYlhWMFpWd2lPblJ5ZFdVc1hDSmlaM1pmWVhWMGIzQmhkWE5sWENJNlptRnNjMlVzWENKc1lYbGxjbDlwWkhOY0lqcGJYWDBpTENJMUlqb2llMXdpYVdSY0lqbzFMRndpZEdsdFpXeHBibVZmYUZ3aU9qSXdNQ3hjSW1KblZHaDFiV0pjSWpwY0lpOHlNREUwTHpBMEx6VTVOak0xTmpZNE1EQmZaR1l5WWpaak5HVTBabDl2TFRFMU1IZ3hOVEF1YW5CblhDSXNYQ0owYUhWdFlrOXlaMmx1WVd4Y0lqcGNJaTh5TURFMEx6QTBMelU1TmpNMU5qWTRNREJmWkdZeVlqWmpOR1UwWmw5dkxtcHdaMXdpTEZ3aWIzSmtaWEpjSWpvMExGd2lZbWRjSWpwY0lpOHlNREUwTHpBMEx6VTVOak0xTmpZNE1EQmZaR1l5WWpaak5HVTBabDl2TG1wd1oxd2lMRndpWkhWeVlYUnBiMjVjSWpvekxGd2labWxzYkUxdlpHVmNJanBjSW1acGJHeGNJaXhjSW5Sb2RXMWlYQ0k2WENJdk1qQXhOQzh3TkM4MU9UWXpOVFkyT0RBd1gyUm1NbUkyWXpSbE5HWmZieTB4TlRCNE1UVXdMbXB3WjF3aUxGd2lZbWQyWDJacGJHeHRiMlJsWENJNlhDSm1hV3hzWENJc1hDSmlaM1pmYkc5dmNGd2lPblJ5ZFdVc1hDSmlaM1pmYlhWMFpWd2lPblJ5ZFdVc1hDSmlaM1pmWVhWMGIzQmhkWE5sWENJNlptRnNjMlVzWENKc1lYbGxjbDlwWkhOY0lqcGJYWDBpTENJMklqb2llMXdpYVdSY0lqbzJMRndpZEdsdFpXeHBibVZmYUZ3aU9qSXdNQ3hjSW1KblZHaDFiV0pjSWpwY0lpOHlNREUwTHpBMEx6VTNOekU0TmpFMU1qTmZOMlEyWkdJMU1qTTVPVjl2TFRFMU1IZ3hOVEF1YW5CblhDSXNYQ0owYUhWdFlrOXlaMmx1WVd4Y0lqcGNJaTh5TURFMEx6QTBMelUzTnpFNE5qRTFNak5mTjJRMlpHSTFNak01T1Y5dkxtcHdaMXdpTEZ3aWIzSmtaWEpjSWpvMUxGd2lZbWRjSWpwY0lpOHlNREUwTHpBMEx6VTNOekU0TmpFMU1qTmZOMlEyWkdJMU1qTTVPVjl2TG1wd1oxd2lMRndpWkhWeVlYUnBiMjVjSWpvekxGd2labWxzYkUxdlpHVmNJanBjSW1acGJHeGNJaXhjSW5Sb2RXMWlYQ0k2WENJdk1qQXhOQzh3TkM4MU56Y3hPRFl4TlRJelh6ZGtObVJpTlRJek9UbGZieTB4TlRCNE1UVXdMbXB3WjF3aUxGd2lZbWQyWDJacGJHeHRiMlJsWENJNlhDSm1hV3hzWENJc1hDSmlaM1pmYkc5dmNGd2lPblJ5ZFdVc1hDSmlaM1pmYlhWMFpWd2lPblJ5ZFdVc1hDSmlaM1pmWVhWMGIzQmhkWE5sWENJNlptRnNjMlVzWENKc1lYbGxjbDlwWkhOY0lqcGJYWDBpTENJM0lqb2llMXdpYVdSY0lqbzNMRndpZEdsdFpXeHBibVZmYUZ3aU9qSXdNQ3hjSW1KblZHaDFiV0pjSWpwY0lpOHlNREUwTHpBMEx6VTNORE0xT1RrME9UWmZZVGd5TjJWak5USXdaVjl2TFRFMU1IZ3hOVEF1YW5CblhDSXNYQ0owYUhWdFlrOXlaMmx1WVd4Y0lqcGNJaTh5TURFMEx6QTBMelUzTkRNMU9UazBPVFpmWVRneU4yVmpOVEl3WlY5dkxtcHdaMXdpTEZ3aWIzSmtaWEpjSWpvMkxGd2lZbWRjSWpwY0lpOHlNREUwTHpBMEx6VTNORE0xT1RrME9UWmZZVGd5TjJWak5USXdaVjl2TG1wd1oxd2lMRndpWkhWeVlYUnBiMjVjSWpvekxGd2labWxzYkUxdlpHVmNJanBjSW1acGJHeGNJaXhjSW5Sb2RXMWlYQ0k2WENJdk1qQXhOQzh3TkM4MU56UXpOVGs1TkRrMlgyRTRNamRsWXpVeU1HVmZieTB4TlRCNE1UVXdMbXB3WjF3aUxGd2lZbWQyWDJacGJHeHRiMlJsWENJNlhDSm1hV3hzWENJc1hDSmlaM1pmYkc5dmNGd2lPblJ5ZFdVc1hDSmlaM1pmYlhWMFpWd2lPblJ5ZFdVc1hDSmlaM1pmWVhWMGIzQmhkWE5sWENJNlptRnNjMlVzWENKc1lYbGxjbDlwWkhOY0lqcGJYWDBpTENJNElqb2llMXdpYVdSY0lqbzRMRndpZEdsdFpXeHBibVZmYUZ3aU9qSXdNQ3hjSW1KblZHaDFiV0pjSWpwY0lpOHlNREUwTHpBMEx6VTNNemN4TURZME1qTmZZalF3WVROaVpEWmhNVjl2TFRFMU1IZ3hOVEF1YW5CblhDSXNYQ0owYUhWdFlrOXlaMmx1WVd4Y0lqcGNJaTh5TURFMEx6QTBMelUzTXpjeE1EWTBNak5mWWpRd1lUTmlaRFpoTVY5dkxtcHdaMXdpTEZ3aWIzSmtaWEpjSWpvM0xGd2lZbWRjSWpwY0lpOHlNREUwTHpBMEx6VTNNemN4TURZME1qTmZZalF3WVROaVpEWmhNVjl2TG1wd1oxd2lMRndpWkhWeVlYUnBiMjVjSWpvekxGd2labWxzYkUxdlpHVmNJanBjSW1acGJHeGNJaXhjSW5Sb2RXMWlYQ0k2WENJdk1qQXhOQzh3TkM4MU56TTNNVEEyTkRJelgySTBNR0V6WW1RMllURmZieTB4TlRCNE1UVXdMbXB3WjF3aUxGd2lZbWQyWDJacGJHeHRiMlJsWENJNlhDSm1hV3hzWENJc1hDSmlaM1pmYkc5dmNGd2lPblJ5ZFdVc1hDSmlaM1pmYlhWMFpWd2lPblJ5ZFdVc1hDSmlaM1pmWVhWMGIzQmhkWE5sWENJNlptRnNjMlVzWENKc1lYbGxjbDlwWkhOY0lqcGJYWDBpTENJNUlqb2llMXdpYVdSY0lqbzVMRndpZEdsdFpXeHBibVZmYUZ3aU9qSXdNQ3hjSW1KblZHaDFiV0pjSWpwY0lpOHlNREUwTHpBMEx6VTNNak0wT0RjME1UaGZNREk1TXpCaU1qYzVObDl2TFRFMU1IZ3hOVEF1YW5CblhDSXNYQ0owYUhWdFlrOXlaMmx1WVd4Y0lqcGNJaTh5TURFMEx6QTBMelUzTWpNME9EYzBNVGhmTURJNU16QmlNamM1Tmw5dkxtcHdaMXdpTEZ3aWIzSmtaWEpjSWpvNExGd2lZbWRjSWpwY0lpOHlNREUwTHpBMEx6VTNNak0wT0RjME1UaGZNREk1TXpCaU1qYzVObDl2TG1wd1oxd2lMRndpWkhWeVlYUnBiMjVjSWpvekxGd2labWxzYkUxdlpHVmNJanBjSW1acGJHeGNJaXhjSW5Sb2RXMWlYQ0k2WENJdk1qQXhOQzh3TkM4MU56SXpORGczTkRFNFh6QXlPVE13WWpJM09UWmZieTB4TlRCNE1UVXdMbXB3WjF3aUxGd2lZbWQyWDJacGJHeHRiMlJsWENJNlhDSm1hV3hzWENJc1hDSmlaM1pmYkc5dmNGd2lPblJ5ZFdVc1hDSmlaM1pmYlhWMFpWd2lPblJ5ZFdVc1hDSmlaM1pmWVhWMGIzQmhkWE5sWENJNlptRnNjMlVzWENKc1lYbGxjbDlwWkhOY0lqcGJYWDBpTENJeE1DSTZJbnRjSW1sa1hDSTZNVEFzWENKMGFXMWxiR2x1WlY5b1hDSTZNakF3TEZ3aVltZFVhSFZ0WWx3aU9sd2lMekl3TVRRdk1EUXZOVFkzTmpZNE1qSXdNMTlsWWpnNE5qVmtNVFk0WDI4dE1UVXdlREUxTUM1cWNHZGNJaXhjSW5Sb2RXMWlUM0puYVc1aGJGd2lPbHdpTHpJd01UUXZNRFF2TlRZM05qWTRNakl3TTE5bFlqZzROalZrTVRZNFgyOHVhbkJuWENJc1hDSnZjbVJsY2x3aU9qa3NYQ0ppWjF3aU9sd2lMekl3TVRRdk1EUXZOVFkzTmpZNE1qSXdNMTlsWWpnNE5qVmtNVFk0WDI4dWFuQm5YQ0lzWENKa2RYSmhkR2x2Ymx3aU9qTXNYQ0ptYVd4c1RXOWtaVndpT2x3aVptbHNiRndpTEZ3aWRHaDFiV0pjSWpwY0lpOHlNREUwTHpBMEx6VTJOelkyT0RJeU1ETmZaV0k0T0RZMVpERTJPRjl2TFRFMU1IZ3hOVEF1YW5CblhDSXNYQ0ppWjNaZlptbHNiRzF2WkdWY0lqcGNJbVpwYkd4Y0lpeGNJbUpuZGw5c2IyOXdYQ0k2ZEhKMVpTeGNJbUpuZGw5dGRYUmxYQ0k2ZEhKMVpTeGNJbUpuZGw5aGRYUnZjR0YxYzJWY0lqcG1ZV3h6WlN4Y0lteGhlV1Z5WDJsa2Mxd2lPbHRkZlNJc0lqRXhJam9pZTF3aWFXUmNJam94TVN4Y0luUnBiV1ZzYVc1bFgyaGNJam95TURBc1hDSmlaMVJvZFcxaVhDSTZYQ0l2TWpBeE5DOHdOQzgxTmpZME9URTVNelkxWDJJeE1qbGlOVEl6T1RKZmJ5MHhOVEI0TVRVd0xtcHdaMXdpTEZ3aWRHaDFiV0pQY21kcGJtRnNYQ0k2WENJdk1qQXhOQzh3TkM4MU5qWTBPVEU1TXpZMVgySXhNamxpTlRJek9USmZieTVxY0dkY0lpeGNJbTl5WkdWeVhDSTZNVEFzWENKaVoxd2lPbHdpTHpJd01UUXZNRFF2TlRZMk5Ea3hPVE0yTlY5aU1USTVZalV5TXpreVgyOHVhbkJuWENJc1hDSmtkWEpoZEdsdmJsd2lPak1zWENKbWFXeHNUVzlrWlZ3aU9sd2labWxzYkZ3aUxGd2lkR2gxYldKY0lqcGNJaTh5TURFMEx6QTBMelUyTmpRNU1Ua3pOalZmWWpFeU9XSTFNak01TWw5dkxURTFNSGd4TlRBdWFuQm5YQ0lzWENKaVozWmZabWxzYkcxdlpHVmNJanBjSW1acGJHeGNJaXhjSW1KbmRsOXNiMjl3WENJNmRISjFaU3hjSW1KbmRsOXRkWFJsWENJNmRISjFaU3hjSW1KbmRsOWhkWFJ2Y0dGMWMyVmNJanBtWVd4elpTeGNJbXhoZVdWeVgybGtjMXdpT2x0ZGZTSXNJakV6SWpvaWUxd2lhV1JjSWpveE15eGNJblJwYldWc2FXNWxYMmhjSWpveU1EQXNYQ0ppWjFSb2RXMWlYQ0k2WENJdk1qQXhOQzh3TkM4MU5qRXpOelV4TXpJNFgyVTFNekU0TkRneE0yRmZieTB4TlRCNE1UVXdMbXB3WjF3aUxGd2lkR2gxYldKUGNtZHBibUZzWENJNlhDSXZNakF4TkM4d05DODFOakV6TnpVeE16STRYMlUxTXpFNE5EZ3hNMkZmYnk1cWNHZGNJaXhjSW05eVpHVnlYQ0k2TVRFc1hDSmlaMXdpT2x3aUx6SXdNVFF2TURRdk5UWXhNemMxTVRNeU9GOWxOVE14T0RRNE1UTmhYMjh1YW5CblhDSXNYQ0prZFhKaGRHbHZibHdpT2pNc1hDSm1hV3hzVFc5a1pWd2lPbHdpWm1sc2JGd2lMRndpZEdoMWJXSmNJanBjSWk4eU1ERTBMekEwTHpVMk1UTTNOVEV6TWpoZlpUVXpNVGcwT0RFellWOXZMVEUxTUhneE5UQXVhbkJuWENJc1hDSmlaM1pmWm1sc2JHMXZaR1ZjSWpwY0ltWnBiR3hjSWl4Y0ltSm5kbDlzYjI5d1hDSTZkSEoxWlN4Y0ltSm5kbDl0ZFhSbFhDSTZkSEoxWlN4Y0ltSm5kbDloZFhSdmNHRjFjMlZjSWpwbVlXeHpaU3hjSW14aGVXVnlYMmxrYzF3aU9sdGRmU0o5TENKTlUxQmhibVZzTGtOdmJuUnliMndpT25zaU1TSTZJbnRjSW1sa1hDSTZYQ0l4WENJc1hDSnNZV0psYkZ3aU9sd2lRWEp5YjNkelhDSXNYQ0p1WVcxbFhDSTZYQ0poY25KdmQzTmNJaXhjSW1GMWRHOUlhV1JsWENJNmRISjFaU3hjSW05MlpYSldhV1JsYjF3aU9uUnlkV1VzWENKcGJuTmxkRndpT25SeWRXVjlJaXdpTWlJNkludGNJbWxrWENJNk1peGNJbXhoWW1Wc1hDSTZYQ0pUWTNKdmJHeGlZWEpjSWl4Y0ltNWhiV1ZjSWpwY0luTmpjbTlzYkdKaGNsd2lMRndpWVhWMGIwaHBaR1ZjSWpwbVlXeHpaU3hjSW05MlpYSldhV1JsYjF3aU9uUnlkV1VzWENKdFlYSm5hVzVjSWpveE1DeGNJbVJwY2x3aU9sd2lhRndpTEZ3aVkyOXNiM0pjSWpwY0lpTXpSRE5FTTBSY0lpeGNJbmRwWkhSb1hDSTZOQ3hjSW1Gc2FXZHVYQ0k2WENKMGIzQmNJaXhjSW1sdWMyVjBYQ0k2ZEhKMVpYMGlMQ0l6SWpvaWUxd2lhV1JjSWpvekxGd2liR0ZpWld4Y0lqcGNJbFJvZFcxaWJHbHpkQzlVWVdKelhDSXNYQ0p1WVcxbFhDSTZYQ0owYUhWdFlteHBjM1JjSWl4Y0ltRjFkRzlJYVdSbFhDSTZabUZzYzJVc1hDSnZkbVZ5Vm1sa1pXOWNJanAwY25WbExGd2liV0Z5WjJsdVhDSTZOU3hjSW1ScGNsd2lPbHdpYUZ3aUxGd2ljM0JoWTJWY0lqbzFMRndpZEhsd1pWd2lPbHdpZEdoMWJXSnpYQ0lzWENKaGJHbG5ibHdpT2x3aWNtbG5hSFJjSWl4Y0ltbHVjMlYwWENJNlptRnNjMlY5SW4xOSIsInR5cGUiOiJjdXN0b20iLCJzbGlkZXNfbnVtIjoiMTIifX0sIm9yaWdpbl91cGxvYWRzX3VybCI6Imh0dHA6XC9cL2RlbW8uYXZlcnRhLm5ldFwvdGhlbWVzXC9sb3R1c1wvZHVtbXktYWdlbmN5XC93cC1jb250ZW50XC91cGxvYWRzIiwicHJlc2V0X3N0eWxlcyI6IiIsInByZXNldF9lZmZlY3RzIjoiIn0=',
			'image_dir' => '',
			'selected' 	=> '',
			'screenshot'=> MSWP_AVERTA_ADMIN_URL . '/assets/images/starters/slider-with-vertical-thumbs.jpg'
		),
		array(
			'label' 	=> __( 'Staff Carousel 1', MSWP_TEXT_DOMAIN ),
			'id' 		=> 'staff-carousel1',
			'slidertype'=> 'custom',
			'importdata'=> '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',
			'image_dir' => '',
			'selected' 	=> '',
			'screenshot'=> MSWP_AVERTA_ADMIN_URL . '/assets/images/starters/staff-carousel1.jpg'
		),
		array(
			'label' 	=> __( 'Staff Carousel 2', MSWP_TEXT_DOMAIN ),
			'id' 		=> 'staff-carousel2',
			'slidertype'=> 'custom',
			'importdata'=> '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',
			'image_dir' => '',
			'selected' 	=> '',
			'screenshot'=> MSWP_AVERTA_ADMIN_URL . '/assets/images/starters/staff-carousel2.jpg'
		),
		array(
			'label' 	=> __( 'Staff Carousel 3', MSWP_TEXT_DOMAIN ),
			'id' 		=> 'staff-carousel3',
			'slidertype'=> 'custom',
			'importdata'=> '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',
			'image_dir' => '',
			'selected' 	=> '',
			'screenshot'=> MSWP_AVERTA_ADMIN_URL . '/assets/images/starters/staff-carousel3.jpg'
		),
		array(
			'label' 	=> __( 'Staff Carousel 4', MSWP_TEXT_DOMAIN ),
			'id' 		=> 'staff-carousel4',
			'slidertype'=> 'custom',
			'importdata'=> 'eyJzbGlkZXJzX2RhdGEiOnsiMzQiOnsidGl0bGUiOiJTdGFmZiBDYXJvdXNlbCA0IiwicGFyYW1zIjoiZXlKdFpYUmhJanA3SWxObGRIUnBibWR6SVdsa2N5STZJakVpTENKVFpYUjBhVzVuY3lGdVpYaDBTV1FpT2pJc0lsTnNhV1JsSVdsa2N5STZJakVzTWl3ekxEUXNOU3cyTERjaUxDSlRiR2xrWlNGdVpYaDBTV1FpT2pnc0lrTnZiblJ5YjJ3aGFXUnpJam9pTlN3Mklpd2lRMjl1ZEhKdmJDRnVaWGgwU1dRaU9qZDlMQ0pOVTFCaGJtVnNMbE5sZEhScGJtZHpJanA3SWpFaU9pSjdYQ0pwWkZ3aU9sd2lNVndpTEZ3aWMyNWhjSEJwYm1kY0lqcDBjblZsTEZ3aWJtRnRaVndpT2x3aVUzUmhabVlnUTJGeWIzVnpaV3dnTkZ3aUxGd2lkMmxrZEdoY0lqb3lOREFzWENKb1pXbG5hSFJjSWpveU5EQXNYQ0ozY21Gd2NHVnlWMmxrZEdoY0lqb3hNREF3TEZ3aWQzSmhjSEJsY2xkcFpIUm9WVzVwZEZ3aU9sd2ljSGhjSWl4Y0ltRjFkRzlEY205d1hDSTZabUZzYzJVc1hDSnNZWGx2ZFhSY0lqcGNJbkJoY25ScFlXeDJhV1YzWENJc1hDSmhkWFJ2U0dWcFoyaDBYQ0k2Wm1Gc2MyVXNYQ0owY2xacFpYZGNJanBjSW1aaFpHVkNZWE5wWTF3aUxGd2ljM0JsWldSY0lqb3lNQ3hjSW5Od1lXTmxYQ0k2TUN4Y0luTjBZWEowWENJNk1TeGNJbWR5WVdKRGRYSnpiM0pjSWpwMGNuVmxMRndpYzNkcGNHVmNJanAwY25WbExGd2liVzkxYzJWY0lqcDBjblZsTEZ3aWQyaGxaV3hjSWpwMGNuVmxMRndpWVhWMGIzQnNZWGxjSWpwbVlXeHpaU3hjSW14dmIzQmNJanAwY25WbExGd2ljMmgxWm1ac1pWd2lPbVpoYkhObExGd2ljSEpsYkc5aFpGd2lPak1zWENKdmRtVnlVR0YxYzJWY0lqcDBjblZsTEZ3aVpXNWtVR0YxYzJWY0lqcG1ZV3h6WlN4Y0ltaHBaR1ZNWVhsbGNuTmNJanBtWVd4elpTeGNJbVJwY2x3aU9sd2lhRndpTEZ3aVkyVnVkR1Z5UTI5dWRISnZiSE5jSWpwMGNuVmxMRndpYVc1emRHRnVkRk5vYjNkTVlYbGxjbk5jSWpwbVlXeHpaU3hjSW5OcmFXNWNJanBjSW0xekxYTnJhVzR0WkdWbVlYVnNkRndpTEZ3aWJYTlVaVzF3YkdGMFpWd2lPbHdpYzNSaFptWXRNbHdpTEZ3aWJYTlVaVzF3YkdGMFpVTnNZWE56WENJNlhDSnRjeTF6ZEdGbVppMWpZWEp2ZFhObGJGd2lMRndpZFhObFpFWnZiblJ6WENJNlhDSmNJbjBpZlN3aVRWTlFZVzVsYkM1VGJHbGtaU0k2ZXlJeElqb2llMXdpYVdSY0lqcGNJakZjSWl4Y0luUnBiV1ZzYVc1bFgyaGNJam95TURBc1hDSmlaMVJvZFcxaVhDSTZYQ0l2TWpBeE5DOHdOQzl6WXpRdE1UVXdlREUxTUM1cWNHZGNJaXhjSW05eVpHVnlYQ0k2TUN4Y0ltSm5YQ0k2WENJdk1qQXhOQzh3TkM5ell6UXVhbkJuWENJc1hDSmtkWEpoZEdsdmJsd2lPak1zWENKbWFXeHNUVzlrWlZ3aU9sd2labWxzYkZ3aUxGd2lhVzVtYjF3aU9sd2lQR2d6SUhOMGVXeGxQVnhjWENKMFpYaDBMV0ZzYVdkdU9pQmpaVzUwWlhJN1hGeGNJajVNYVd4c2FXRnVJRmN1SUZKbFpXUThMMmd6UGp4a2FYWWdjM1I1YkdVOVhGeGNJblJsZUhRdFlXeHBaMjQ2SUdObGJuUmxjanRjWEZ3aVBreHZjbVZ0SUdsd2MzVnRJR1J2Ykc5eUlITnBkQ0JoYldWMExDQmpiMjV6WldOMFpYUjFjaUJoWkdsd2FYTnBZMmx1WnlCbGJHbDBMQ0J6WldRZ1pHOGdaV2wxYzIxdlpDQjBaVzF3YjNJZ1BHSnlJQzgrYVc1amFXUnBaSFZ1ZENCMWRDQnNZV0p2Y21VZ1pYUWdaRzlzYjNKbElHMWhaMjVoSUdGc2FYRjFZUzRnVlhRZ1pXNXBiU0JoWkNCdGFXNXBiU0IyWlc1cFlXMHVQQzlrYVhZK1hDSXNYQ0ppWjNaZlptbHNiRzF2WkdWY0lqcGNJbVpwYkd4Y0lpeGNJbUpuZGw5c2IyOXdYQ0k2ZEhKMVpTeGNJbUpuZGw5dGRYUmxYQ0k2ZEhKMVpTeGNJbUpuZGw5aGRYUnZjR0YxYzJWY0lqcG1ZV3h6WlN4Y0lteGhlV1Z5WDJsa2Mxd2lPbHRkZlNJc0lqSWlPaUo3WENKcFpGd2lPaklzWENKMGFXMWxiR2x1WlY5b1hDSTZNakF3TEZ3aVltZFVhSFZ0WWx3aU9sd2lMekl3TVRRdk1EUXZjMk15TFRFMU1IZ3hOVEF1YW5CblhDSXNYQ0p2Y21SbGNsd2lPalFzWENKaVoxd2lPbHdpTHpJd01UUXZNRFF2YzJNeUxtcHdaMXdpTEZ3aVpIVnlZWFJwYjI1Y0lqb3pMRndpWm1sc2JFMXZaR1ZjSWpwY0ltWnBiR3hjSWl4Y0ltbHVabTljSWpwY0lqeG9NeUJ6ZEhsc1pUMWNYRndpZEdWNGRDMWhiR2xuYmpvZ1kyVnVkR1Z5TzF4Y1hDSStUSFZwY3lCQkxpQkNkWFJqYUdWeVBDOW9NejQ4WkdsMklITjBlV3hsUFZ4Y1hDSjBaWGgwTFdGc2FXZHVPaUJqWlc1MFpYSTdYRnhjSWo1TWIzSmxiU0JwY0hOMWJTQmtiMnh2Y2lCemFYUWdZVzFsZEN3Z1kyOXVjMlZqZEdWMGRYSWdZV1JwY0dsemFXTnBibWNnWld4cGRDekNvSE5sWkNCa2J5QmxhWFZ6Ylc5a0lIUmxiWEJ2Y3NLZ1BHSnlJQzgrYVc1amFXUnBaSFZ1ZENCMWRDQnNZV0p2Y21VZ1pYUWdaRzlzYjNKbElHMWhaMjVoSUdGc2FYRjFZUzRnVlhRZ1pXNXBiU0JoWkNCdGFXNXBiU0IyWlc1cFlXMHVQQzlrYVhZK1hDSXNYQ0ppWjNaZlptbHNiRzF2WkdWY0lqcGNJbVpwYkd4Y0lpeGNJbUpuZGw5c2IyOXdYQ0k2ZEhKMVpTeGNJbUpuZGw5dGRYUmxYQ0k2ZEhKMVpTeGNJbUpuZGw5aGRYUnZjR0YxYzJWY0lqcG1ZV3h6WlN4Y0lteGhlV1Z5WDJsa2Mxd2lPbHRkZlNJc0lqTWlPaUo3WENKcFpGd2lPak1zWENKMGFXMWxiR2x1WlY5b1hDSTZNakF3TEZ3aVltZFVhSFZ0WWx3aU9sd2lMekl3TVRRdk1EUXZjMk0zTFRFMU1IZ3hOVEF1YW5CblhDSXNYQ0p2Y21SbGNsd2lPaklzWENKaVoxd2lPbHdpTHpJd01UUXZNRFF2YzJNM0xtcHdaMXdpTEZ3aVpIVnlZWFJwYjI1Y0lqb3pMRndpWm1sc2JFMXZaR1ZjSWpwY0ltWnBiR3hjSWl4Y0ltbHVabTljSWpwY0lqeG9NeUJ6ZEhsc1pUMWNYRndpZEdWNGRDMWhiR2xuYmpvZ1kyVnVkR1Z5TzF4Y1hDSStSMkZpY21sbGJDQkxMaUJYYjI5a1BDOW9NejQ4WkdsMklITjBlV3hsUFZ4Y1hDSjBaWGgwTFdGc2FXZHVPaUJqWlc1MFpYSTdYRnhjSWo1TWIzSmxiU0JwY0hOMWJTQmtiMnh2Y2lCemFYUWdZVzFsZEN3Z1kyOXVjMlZqZEdWMGRYSWdZV1JwY0dsemFXTnBibWNnWld4cGRDekNvSE5sWkNCa2J5QmxhWFZ6Ylc5a0lIUmxiWEJ2Y3NLZ1BHSnlJQzgrYVc1amFXUnBaSFZ1ZENCMWRDQnNZV0p2Y21VZ1pYUWdaRzlzYjNKbElHMWhaMjVoSUdGc2FYRjFZUzRnVlhRZ1pXNXBiU0JoWkNCdGFXNXBiU0IyWlc1cFlXMHVQQzlrYVhZK1hDSXNYQ0ppWjNaZlptbHNiRzF2WkdWY0lqcGNJbVpwYkd4Y0lpeGNJbUpuZGw5c2IyOXdYQ0k2ZEhKMVpTeGNJbUpuZGw5dGRYUmxYQ0k2ZEhKMVpTeGNJbUpuZGw5aGRYUnZjR0YxYzJWY0lqcG1ZV3h6WlN4Y0lteGhlV1Z5WDJsa2Mxd2lPbHRkZlNJc0lqUWlPaUo3WENKcFpGd2lPalFzWENKMGFXMWxiR2x1WlY5b1hDSTZNakF3TEZ3aVltZFVhSFZ0WWx3aU9sd2lMekl3TVRRdk1EUXZjMk16TFRFMU1IZ3hOVEF1YW5CblhDSXNYQ0p2Y21SbGNsd2lPakVzWENKaVoxd2lPbHdpTHpJd01UUXZNRFF2YzJNekxtcHdaMXdpTEZ3aVpIVnlZWFJwYjI1Y0lqb3pMRndpWm1sc2JFMXZaR1ZjSWpwY0ltWnBiR3hjSWl4Y0ltbHVabTljSWpwY0lqeG9NeUJ6ZEhsc1pUMWNYRndpZEdWNGRDMWhiR2xuYmpvZ1kyVnVkR1Z5TzF4Y1hDSStWR1Z5Y25rZ1R5NGdTbUZqYTNOdmJqd3ZhRE0rUEdScGRpQnpkSGxzWlQxY1hGd2lkR1Y0ZEMxaGJHbG5iam9nWTJWdWRHVnlPMXhjWENJK1RHOXlaVzBnYVhCemRXMGdaRzlzYjNJZ2MybDBJR0Z0WlhRc0lHTnZibk5sWTNSbGRIVnlJR0ZrYVhCcGMybGphVzVuSUdWc2FYUXN3cUJ6WldRZ1pHOGdaV2wxYzIxdlpDQjBaVzF3YjNMQ29EeGljaUF2UG1sdVkybGthV1IxYm5RZ2RYUWdiR0ZpYjNKbElHVjBJR1J2Ykc5eVpTQnRZV2R1WVNCaGJHbHhkV0V1SUZWMElHVnVhVzBnWVdRZ2JXbHVhVzBnZG1WdWFXRnRMand2WkdsMlBsd2lMRndpWW1kMlgyWnBiR3h0YjJSbFhDSTZYQ0ptYVd4c1hDSXNYQ0ppWjNaZmJHOXZjRndpT25SeWRXVXNYQ0ppWjNaZmJYVjBaVndpT25SeWRXVXNYQ0ppWjNaZllYVjBiM0JoZFhObFhDSTZabUZzYzJVc1hDSnNZWGxsY2w5cFpITmNJanBiWFgwaUxDSTFJam9pZTF3aWFXUmNJam8xTEZ3aWRHbHRaV3hwYm1WZmFGd2lPakl3TUN4Y0ltSm5WR2gxYldKY0lqcGNJaTh5TURFMEx6QTBMM05qTVMweE5UQjRNVFV3TG1wd1oxd2lMRndpYjNKa1pYSmNJam8xTEZ3aVltZGNJanBjSWk4eU1ERTBMekEwTDNOak1TNXFjR2RjSWl4Y0ltUjFjbUYwYVc5dVhDSTZNeXhjSW1acGJHeE5iMlJsWENJNlhDSm1hV3hzWENJc1hDSnBibVp2WENJNlhDSThhRE1nYzNSNWJHVTlYRnhjSW5SbGVIUXRZV3hwWjI0NklHTmxiblJsY2p0Y1hGd2lQa1ZrYVhSb0lFb3VJRk5vZFhOMFpYSThMMmd6UGp4a2FYWWdjM1I1YkdVOVhGeGNJblJsZUhRdFlXeHBaMjQ2SUdObGJuUmxjanRjWEZ3aVBreHZjbVZ0SUdsd2MzVnRJR1J2Ykc5eUlITnBkQ0JoYldWMExDQmpiMjV6WldOMFpYUjFjaUJoWkdsd2FYTnBZMmx1WnlCbGJHbDBMTUtnYzJWa0lHUnZJR1ZwZFhOdGIyUWdkR1Z0Y0c5eXdxQThZbklnTHo1cGJtTnBaR2xrZFc1MElIVjBJR3hoWW05eVpTQmxkQ0JrYjJ4dmNtVWdiV0ZuYm1FZ1lXeHBjWFZoTGlCVmRDQmxibWx0SUdGa0lHMXBibWx0SUhabGJtbGhiUzQ4TDJScGRqNWNJaXhjSW1KbmRsOW1hV3hzYlc5a1pWd2lPbHdpWm1sc2JGd2lMRndpWW1kMlgyeHZiM0JjSWpwMGNuVmxMRndpWW1kMlgyMTFkR1ZjSWpwMGNuVmxMRndpWW1kMlgyRjFkRzl3WVhWelpWd2lPbVpoYkhObExGd2liR0Y1WlhKZmFXUnpYQ0k2VzExOUlpd2lOaUk2SW50Y0ltbGtYQ0k2Tml4Y0luUnBiV1ZzYVc1bFgyaGNJam95TURBc1hDSmlaMVJvZFcxaVhDSTZYQ0l2TWpBeE5DOHdOQzl6WXpVdE1UVXdlREUxTUM1cWNHZGNJaXhjSW05eVpHVnlYQ0k2Tml4Y0ltSm5YQ0k2WENJdk1qQXhOQzh3TkM5ell6VXVhbkJuWENJc1hDSmtkWEpoZEdsdmJsd2lPak1zWENKbWFXeHNUVzlrWlZ3aU9sd2labWxzYkZ3aUxGd2lhVzVtYjF3aU9sd2lQR2d6SUhOMGVXeGxQVnhjWENKMFpYaDBMV0ZzYVdkdU9pQmpaVzUwWlhJN1hGeGNJajVLYjJodUlFd3VJRVJwWVhvOEwyZ3pQanhrYVhZZ2MzUjViR1U5WEZ4Y0luUmxlSFF0WVd4cFoyNDZJR05sYm5SbGNqdGNYRndpUGt4dmNtVnRJR2x3YzNWdElHUnZiRzl5SUhOcGRDQmhiV1YwTENCamIyNXpaV04wWlhSMWNpQmhaR2x3YVhOcFkybHVaeUJsYkdsMExNS2djMlZrSUdSdklHVnBkWE50YjJRZ2RHVnRjRzl5d3FBOFluSWdMejVwYm1OcFpHbGtkVzUwSUhWMElHeGhZbTl5WlNCbGRDQmtiMnh2Y21VZ2JXRm5ibUVnWVd4cGNYVmhMaUJWZENCbGJtbHRJR0ZrSUcxcGJtbHRJSFpsYm1saGJTNDhMMlJwZGo1Y0lpeGNJbUpuZGw5bWFXeHNiVzlrWlZ3aU9sd2labWxzYkZ3aUxGd2lZbWQyWDJ4dmIzQmNJanAwY25WbExGd2lZbWQyWDIxMWRHVmNJanAwY25WbExGd2lZbWQyWDJGMWRHOXdZWFZ6WlZ3aU9tWmhiSE5sTEZ3aWJHRjVaWEpmYVdSelhDSTZXMTE5SWl3aU55STZJbnRjSW1sa1hDSTZOeXhjSW5ScGJXVnNhVzVsWDJoY0lqb3lNREFzWENKaVoxUm9kVzFpWENJNlhDSXZNakF4TkM4d05DOXpZell0TVRVd2VERTFNQzVxY0dkY0lpeGNJbTl5WkdWeVhDSTZNeXhjSW1KblhDSTZYQ0l2TWpBeE5DOHdOQzl6WXpZdWFuQm5YQ0lzWENKa2RYSmhkR2x2Ymx3aU9qTXNYQ0ptYVd4c1RXOWtaVndpT2x3aVptbHNiRndpTEZ3aWFXNW1iMXdpT2x3aVBHZ3pJSE4wZVd4bFBWeGNYQ0owWlhoMExXRnNhV2R1T2lCalpXNTBaWEk3WEZ4Y0lqNU1iM0pwSUUwdUlGZGhiRzF6YkdWNVBDOW9NejQ4WkdsMklITjBlV3hsUFZ4Y1hDSjBaWGgwTFdGc2FXZHVPaUJqWlc1MFpYSTdYRnhjSWo1TWIzSmxiU0JwY0hOMWJTQmtiMnh2Y2lCemFYUWdZVzFsZEN3Z1kyOXVjMlZqZEdWMGRYSWdZV1JwY0dsemFXTnBibWNnWld4cGRDekNvSE5sWkNCa2J5QmxhWFZ6Ylc5a0lIUmxiWEJ2Y3NLZ1BHSnlJQzgrYVc1amFXUnBaSFZ1ZENCMWRDQnNZV0p2Y21VZ1pYUWdaRzlzYjNKbElHMWhaMjVoSUdGc2FYRjFZUzRnVlhRZ1pXNXBiU0JoWkNCdGFXNXBiU0IyWlc1cFlXMHVQQzlrYVhZK1hDSXNYQ0ppWjNaZlptbHNiRzF2WkdWY0lqcGNJbVpwYkd4Y0lpeGNJbUpuZGw5c2IyOXdYQ0k2ZEhKMVpTeGNJbUpuZGw5dGRYUmxYQ0k2ZEhKMVpTeGNJbUpuZGw5aGRYUnZjR0YxYzJWY0lqcG1ZV3h6WlN4Y0lteGhlV1Z5WDJsa2Mxd2lPbHRkZlNKOUxDSk5VMUJoYm1Wc0xrTnZiblJ5YjJ3aU9uc2lOU0k2SW50Y0ltbGtYQ0k2TlN4Y0lteGhZbVZzWENJNlhDSkJjbkp2ZDNOY0lpeGNJbTVoYldWY0lqcGNJbUZ5Y205M2Mxd2lMRndpWVhWMGIwaHBaR1ZjSWpwMGNuVmxMRndpYjNabGNsWnBaR1Z2WENJNmRISjFaU3hjSW1sdWMyVjBYQ0k2ZEhKMVpYMGlMQ0kySWpvaWUxd2lhV1JjSWpvMkxGd2liR0ZpWld4Y0lqcGNJbE5zYVdSbElFbHVabTljSWl4Y0ltNWhiV1ZjSWpwY0luTnNhV1JsYVc1bWIxd2lMRndpWVhWMGIwaHBaR1ZjSWpwbVlXeHpaU3hjSW05MlpYSldhV1JsYjF3aU9uUnlkV1VzWENKdFlYSm5hVzVjSWpveE1DeGNJbUZzYVdkdVhDSTZYQ0ppYjNSMGIyMWNJaXhjSW1sdWMyVjBYQ0k2Wm1Gc2MyVXNYQ0p6YVhwbFhDSTZNVFl3ZlNKOWZRPT0iLCJ0eXBlIjoiY3VzdG9tIiwic2xpZGVzX251bSI6IjcifX0sIm9yaWdpbl91cGxvYWRzX3VybCI6Imh0dHA6XC9cL2RlbW8uYXZlcnRhLm5ldFwvdGhlbWVzXC9sb3R1c1wvZHVtbXktYWdlbmN5XC93cC1jb250ZW50XC91cGxvYWRzIiwicHJlc2V0X3N0eWxlcyI6IiIsInByZXNldF9lZmZlY3RzIjoiIn0=',
			'image_dir' => '',
			'selected' 	=> '',
			'screenshot'=> MSWP_AVERTA_ADMIN_URL . '/assets/images/starters/staff-carousel4.jpg'
		),
		array(
			'label' 	=> __( 'Staff Carousel 5', MSWP_TEXT_DOMAIN ),
			'id' 		=> 'staff-carousel5',
			'slidertype'=> 'custom',
			'importdata'=> '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',
			'image_dir' => '',
			'selected' 	=> '',
			'screenshot'=> MSWP_AVERTA_ADMIN_URL . '/assets/images/starters/staff-carousel5.jpg'
		),
		array(
			'label' 	=> __( 'Staff Carousel 6', MSWP_TEXT_DOMAIN ),
			'id' 		=> 'staff-carousel6',
			'slidertype'=> 'custom',
			'importdata'=> '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',
			'image_dir' => '',
			'selected' 	=> '',
			'screenshot'=> MSWP_AVERTA_ADMIN_URL . '/assets/images/starters/staff-carousel6.jpg'
		),
		array(
			'label' 	=> __( 'Video Gallery Sample 1', MSWP_TEXT_DOMAIN ),
			'id' 		=> 'video-gallery-sample-1',
			'slidertype'=> 'custom',
			'importdata'=> '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',
			'image_dir' => '',
			'selected' 	=> '',
			'screenshot'=> MSWP_AVERTA_ADMIN_URL . '/assets/images/starters/video-gallery-sample1.jpg'
		),
		array(
			'label' 	=> __( 'Video Gallery Sample 2', MSWP_TEXT_DOMAIN ),
			'id' 		=> 'video-gallery-sample-2',
			'slidertype'=> 'custom',
			'importdata'=> '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',
			'image_dir' => '',
			'selected' 	=> '',
			'screenshot'=> MSWP_AVERTA_ADMIN_URL . '/assets/images/starters/video-gallery-sample2.jpg'
		),
		array(
			'label' 	=> __( 'Partial View Slider Version 1', MSWP_TEXT_DOMAIN ),
			'id' 		=> 'partial-view-slider-version-1',
			'slidertype'=> 'custom',
			'importdata'=> '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',
			'image_dir' => '',
			'selected' 	=> '',
			'screenshot'=> MSWP_AVERTA_ADMIN_URL . '/assets/images/starters/partial-view-slider-version-1.jpg'
		),
		array(
			'label' 	=> __( 'Partial View Slider Version 2', MSWP_TEXT_DOMAIN ),
			'id' 		=> 'partial-view-slider-version-2',
			'slidertype'=> 'custom',
			'importdata'=> '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',
			'image_dir' => '',
			'selected' 	=> '',
			'screenshot'=> MSWP_AVERTA_ADMIN_URL . '/assets/images/starters/partial-view-slider-version-2.jpg'
		),
		array(
			'label' 	=> __( 'Partial View Slider Version 3', MSWP_TEXT_DOMAIN ),
			'id' 		=> 'partial-view-slider-version-3',
			'slidertype'=> 'custom',
			'importdata'=> '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',
			'image_dir' => '',
			'selected' 	=> '',
			'screenshot'=> MSWP_AVERTA_ADMIN_URL . '/assets/images/starters/partial-view-slider-version-3.jpg'
		),
		array(
			'label' 	=> __( 'Sample Showcase Slider', MSWP_TEXT_DOMAIN ),
			'id' 		=> 'sample-showcase-slider-1',
			'slidertype'=> 'custom',
			'importdata'=> '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',
			'image_dir' => '',
			'selected' 	=> '',
			'screenshot'=> MSWP_AVERTA_ADMIN_URL . '/assets/images/starters/sample-showcase-slider.jpg'
		),
		array(
			'label' 	=> __( 'Vertical Direction Slider', MSWP_TEXT_DOMAIN ),
			'id' 		=> 'vertical-direction-slider1',
			'slidertype'=> 'custom',
			'importdata'=> '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',
			'image_dir' => '',
			'selected' 	=> '',
			'screenshot'=> MSWP_AVERTA_ADMIN_URL . '/assets/images/starters/vertical-direction-slider.jpg'
		),
		array(
			'label' 	=> __( 'Slider with Horizontal Thumbs', MSWP_TEXT_DOMAIN ),
			'id' 		=> 'slider-with-horizontal-thumbs',
			'slidertype'=> 'custom',
			'importdata'=> 'eyJzbGlkZXJzX2RhdGEiOnsiMzYiOnsidGl0bGUiOiJTbGlkZXIgd2l0aCBIb3Jpem9udGFsIFRodW1icyIsInBhcmFtcyI6ImV5SnRaWFJoSWpwN0lsTmxkSFJwYm1keklXbGtjeUk2SWpFaUxDSlRaWFIwYVc1bmN5RnVaWGgwU1dRaU9qSXNJbE5zYVdSbElXbGtjeUk2SWpFc01pd3pMRFFzTlN3MkxEY3NPQ3c1TERFd0xERXhMREV6SWl3aVUyeHBaR1VoYm1WNGRFbGtJam94TkN3aVEyOXVkSEp2YkNGcFpITWlPaUkwTERVc05pSXNJa052Ym5SeWIyd2hibVY0ZEVsa0lqbzNmU3dpVFZOUVlXNWxiQzVUWlhSMGFXNW5jeUk2ZXlJeElqb2llMXdpYVdSY0lqcGNJakZjSWl4Y0luTnVZWEJ3YVc1blhDSTZkSEoxWlN4Y0ltNWhiV1ZjSWpwY0lsTnNhV1JsY2lCM2FYUm9JRWh2Y21sNmIyNTBZV3dnVkdoMWJXSnpYQ0lzWENKM2FXUjBhRndpT2pFd01EQXNYQ0pvWldsbmFIUmNJam8xTURBc1hDSjNjbUZ3Y0dWeVYybGtkR2hjSWpveE1EQXdMRndpZDNKaGNIQmxjbGRwWkhSb1ZXNXBkRndpT2x3aWNIaGNJaXhjSW1GMWRHOURjbTl3WENJNlptRnNjMlVzWENKc1lYbHZkWFJjSWpwY0ltSnZlR1ZrWENJc1hDSmhkWFJ2U0dWcFoyaDBYQ0k2ZEhKMVpTeGNJblJ5Vm1sbGQxd2lPbHdpYzJOaGJHVmNJaXhjSW5Od1pXVmtYQ0k2TWpBc1hDSnpjR0ZqWlZ3aU9qQXNYQ0p6ZEdGeWRGd2lPakVzWENKbmNtRmlRM1Z5YzI5eVhDSTZkSEoxWlN4Y0luTjNhWEJsWENJNmRISjFaU3hjSW0xdmRYTmxYQ0k2ZEhKMVpTeGNJbmRvWldWc1hDSTZabUZzYzJVc1hDSmhkWFJ2Y0d4aGVWd2lPblJ5ZFdVc1hDSnNiMjl3WENJNlptRnNjMlVzWENKemFIVm1abXhsWENJNlptRnNjMlVzWENKd2NtVnNiMkZrWENJNk1TeGNJbTkyWlhKUVlYVnpaVndpT25SeWRXVXNYQ0psYm1SUVlYVnpaVndpT21aaGJITmxMRndpYUdsa1pVeGhlV1Z5YzF3aU9tWmhiSE5sTEZ3aVpHbHlYQ0k2WENKb1hDSXNYQ0pqWlc1MFpYSkRiMjUwY205c2Mxd2lPbVpoYkhObExGd2lhVzV6ZEdGdWRGTm9iM2RNWVhsbGNuTmNJanBtWVd4elpTeGNJbk5yYVc1Y0lqcGNJbTF6TFhOcmFXNHRiR2xuYUhRdE0xd2lMRndpYlhOVVpXMXdiR0YwWlZ3aU9sd2ljMnhwWkdWeUxXaHZjbWw2YjI1MFlXd3RkR2gxYldKelhDSXNYQ0p0YzFSbGJYQnNZWFJsUTJ4aGMzTmNJanBjSW0xekxYUm9kVzFpY3kxMFpXMXdiR0YwWlZ3aUxGd2lkWE5sWkVadmJuUnpYQ0k2WENKY0luMGlmU3dpVFZOUVlXNWxiQzVUYkdsa1pTSTZleUl4SWpvaWUxd2lhV1JjSWpwY0lqRmNJaXhjSW5ScGJXVnNhVzVsWDJoY0lqb3lNREFzWENKaVoxUm9kVzFpWENJNlhDSXZNakF4TkM4d05DODJPVFkyT1RZMU1EVTNYemRqTW1Jd05UUTBOVEpmYnkweE5UQjRNVFV3TG1wd1oxd2lMRndpZEdoMWJXSlBjbWRwYm1Gc1hDSTZYQ0l2TWpBeE5DOHdOQzgyT1RZMk9UWTFNRFUzWHpkak1tSXdOVFEwTlRKZmJ5NXFjR2RjSWl4Y0ltOXlaR1Z5WENJNk1DeGNJbUpuWENJNlhDSXZNakF4TkM4d05DODJPVFkyT1RZMU1EVTNYemRqTW1Jd05UUTBOVEpmYnk1cWNHZGNJaXhjSW1SMWNtRjBhVzl1WENJNk15eGNJbVpwYkd4TmIyUmxYQ0k2WENKbWFXeHNYQ0lzWENKMGFIVnRZbHdpT2x3aUx6SXdNVFF2TURRdk5qazJOamsyTlRBMU4xODNZekppTURVME5EVXlYMjh0TVRVd2VERTFNQzVxY0dkY0lpeGNJbUpuZGw5bWFXeHNiVzlrWlZ3aU9sd2labWxzYkZ3aUxGd2lZbWQyWDJ4dmIzQmNJanAwY25WbExGd2lZbWQyWDIxMWRHVmNJanAwY25WbExGd2lZbWQyWDJGMWRHOXdZWFZ6WlZ3aU9tWmhiSE5sTEZ3aWJHRjVaWEpmYVdSelhDSTZXMTE5SWl3aU1pSTZJbnRjSW1sa1hDSTZNaXhjSW5ScGJXVnNhVzVsWDJoY0lqb3lNREFzWENKaVoxUm9kVzFpWENJNlhDSXZNakF4TkM4d05DODJNVEkzTWpneU1Ua3pYelZoTVRFME1EZzBNMlZmYnkweE5UQjRNVFV3TG1wd1oxd2lMRndpZEdoMWJXSlBjbWRwYm1Gc1hDSTZYQ0l2TWpBeE5DOHdOQzgyTVRJM01qZ3lNVGt6WHpWaE1URTBNRGcwTTJWZmJ5NXFjR2RjSWl4Y0ltOXlaR1Z5WENJNk1TeGNJbUpuWENJNlhDSXZNakF4TkM4d05DODJNVEkzTWpneU1Ua3pYelZoTVRFME1EZzBNMlZmYnk1cWNHZGNJaXhjSW1SMWNtRjBhVzl1WENJNk15eGNJbVpwYkd4TmIyUmxYQ0k2WENKbWFXeHNYQ0lzWENKMGFIVnRZbHdpT2x3aUx6SXdNVFF2TURRdk5qRXlOekk0TWpFNU0xODFZVEV4TkRBNE5ETmxYMjh0TVRVd2VERTFNQzVxY0dkY0lpeGNJbUpuZGw5bWFXeHNiVzlrWlZ3aU9sd2labWxzYkZ3aUxGd2lZbWQyWDJ4dmIzQmNJanAwY25WbExGd2lZbWQyWDIxMWRHVmNJanAwY25WbExGd2lZbWQyWDJGMWRHOXdZWFZ6WlZ3aU9tWmhiSE5sTEZ3aWJHRjVaWEpmYVdSelhDSTZXMTE5SWl3aU15STZJbnRjSW1sa1hDSTZNeXhjSW5ScGJXVnNhVzVsWDJoY0lqb3lNREFzWENKaVoxUm9kVzFpWENJNlhDSXZNakF4TkM4d05DODJNREV5TkRNd05UYzJYelkyWkRSaE5UQTBaRGxmYnkweE5UQjRNVFV3TG1wd1oxd2lMRndpZEdoMWJXSlBjbWRwYm1Gc1hDSTZYQ0l2TWpBeE5DOHdOQzgyTURFeU5ETXdOVGMyWHpZMlpEUmhOVEEwWkRsZmJ5NXFjR2RjSWl4Y0ltOXlaR1Z5WENJNk1peGNJbUpuWENJNlhDSXZNakF4TkM4d05DODJNREV5TkRNd05UYzJYelkyWkRSaE5UQTBaRGxmYnk1cWNHZGNJaXhjSW1SMWNtRjBhVzl1WENJNk15eGNJbVpwYkd4TmIyUmxYQ0k2WENKbWFXeHNYQ0lzWENKMGFIVnRZbHdpT2x3aUx6SXdNVFF2TURRdk5qQXhNalF6TURVM05sODJObVEwWVRVd05HUTVYMjh0TVRVd2VERTFNQzVxY0dkY0lpeGNJbUpuZGw5bWFXeHNiVzlrWlZ3aU9sd2labWxzYkZ3aUxGd2lZbWQyWDJ4dmIzQmNJanAwY25WbExGd2lZbWQyWDIxMWRHVmNJanAwY25WbExGd2lZbWQyWDJGMWRHOXdZWFZ6WlZ3aU9tWmhiSE5sTEZ3aWJHRjVaWEpmYVdSelhDSTZXMTE5SWl3aU5DSTZJbnRjSW1sa1hDSTZOQ3hjSW5ScGJXVnNhVzVsWDJoY0lqb3lNREFzWENKaVoxUm9kVzFpWENJNlhDSXZNakF4TkM4d05DODFPVGN6T1RNNE1qSTJYelk1Wm1FeU16SXlNR1ZmYnkweE5UQjRNVFV3TG1wd1oxd2lMRndpZEdoMWJXSlBjbWRwYm1Gc1hDSTZYQ0l2TWpBeE5DOHdOQzgxT1Rjek9UTTRNakkyWHpZNVptRXlNekl5TUdWZmJ5NXFjR2RjSWl4Y0ltOXlaR1Z5WENJNk15eGNJbUpuWENJNlhDSXZNakF4TkM4d05DODFPVGN6T1RNNE1qSTJYelk1Wm1FeU16SXlNR1ZmYnk1cWNHZGNJaXhjSW1SMWNtRjBhVzl1WENJNk15eGNJbVpwYkd4TmIyUmxYQ0k2WENKbWFXeHNYQ0lzWENKMGFIVnRZbHdpT2x3aUx6SXdNVFF2TURRdk5UazNNemt6T0RJeU5sODJPV1poTWpNeU1qQmxYMjh0TVRVd2VERTFNQzVxY0dkY0lpeGNJbUpuZGw5bWFXeHNiVzlrWlZ3aU9sd2labWxzYkZ3aUxGd2lZbWQyWDJ4dmIzQmNJanAwY25WbExGd2lZbWQyWDIxMWRHVmNJanAwY25WbExGd2lZbWQyWDJGMWRHOXdZWFZ6WlZ3aU9tWmhiSE5sTEZ3aWJHRjVaWEpmYVdSelhDSTZXMTE5SWl3aU5TSTZJbnRjSW1sa1hDSTZOU3hjSW5ScGJXVnNhVzVsWDJoY0lqb3lNREFzWENKaVoxUm9kVzFpWENJNlhDSXZNakF4TkM4d05DODFPVFl6TlRZMk9EQXdYMlJtTW1JMll6UmxOR1pmYnkweE5UQjRNVFV3TG1wd1oxd2lMRndpZEdoMWJXSlBjbWRwYm1Gc1hDSTZYQ0l2TWpBeE5DOHdOQzgxT1RZek5UWTJPREF3WDJSbU1tSTJZelJsTkdaZmJ5NXFjR2RjSWl4Y0ltOXlaR1Z5WENJNk5DeGNJbUpuWENJNlhDSXZNakF4TkM4d05DODFPVFl6TlRZMk9EQXdYMlJtTW1JMll6UmxOR1pmYnk1cWNHZGNJaXhjSW1SMWNtRjBhVzl1WENJNk15eGNJbVpwYkd4TmIyUmxYQ0k2WENKbWFXeHNYQ0lzWENKMGFIVnRZbHdpT2x3aUx6SXdNVFF2TURRdk5UazJNelUyTmpnd01GOWtaakppTm1NMFpUUm1YMjh0TVRVd2VERTFNQzVxY0dkY0lpeGNJbUpuZGw5bWFXeHNiVzlrWlZ3aU9sd2labWxzYkZ3aUxGd2lZbWQyWDJ4dmIzQmNJanAwY25WbExGd2lZbWQyWDIxMWRHVmNJanAwY25WbExGd2lZbWQyWDJGMWRHOXdZWFZ6WlZ3aU9tWmhiSE5sTEZ3aWJHRjVaWEpmYVdSelhDSTZXMTE5SWl3aU5pSTZJbnRjSW1sa1hDSTZOaXhjSW5ScGJXVnNhVzVsWDJoY0lqb3lNREFzWENKaVoxUm9kVzFpWENJNlhDSXZNakF4TkM4d05DODFOemN4T0RZeE5USXpYemRrTm1SaU5USXpPVGxmYnkweE5UQjRNVFV3TG1wd1oxd2lMRndpZEdoMWJXSlBjbWRwYm1Gc1hDSTZYQ0l2TWpBeE5DOHdOQzgxTnpjeE9EWXhOVEl6WHpka05tUmlOVEl6T1RsZmJ5NXFjR2RjSWl4Y0ltOXlaR1Z5WENJNk5TeGNJbUpuWENJNlhDSXZNakF4TkM4d05DODFOemN4T0RZeE5USXpYemRrTm1SaU5USXpPVGxmYnk1cWNHZGNJaXhjSW1SMWNtRjBhVzl1WENJNk15eGNJbVpwYkd4TmIyUmxYQ0k2WENKbWFXeHNYQ0lzWENKMGFIVnRZbHdpT2x3aUx6SXdNVFF2TURRdk5UYzNNVGcyTVRVeU0xODNaRFprWWpVeU16azVYMjh0TVRVd2VERTFNQzVxY0dkY0lpeGNJbUpuZGw5bWFXeHNiVzlrWlZ3aU9sd2labWxzYkZ3aUxGd2lZbWQyWDJ4dmIzQmNJanAwY25WbExGd2lZbWQyWDIxMWRHVmNJanAwY25WbExGd2lZbWQyWDJGMWRHOXdZWFZ6WlZ3aU9tWmhiSE5sTEZ3aWJHRjVaWEpmYVdSelhDSTZXMTE5SWl3aU55STZJbnRjSW1sa1hDSTZOeXhjSW5ScGJXVnNhVzVsWDJoY0lqb3lNREFzWENKaVoxUm9kVzFpWENJNlhDSXZNakF4TkM4d05DODFOelF6TlRrNU5EazJYMkU0TWpkbFl6VXlNR1ZmYnkweE5UQjRNVFV3TG1wd1oxd2lMRndpZEdoMWJXSlBjbWRwYm1Gc1hDSTZYQ0l2TWpBeE5DOHdOQzgxTnpRek5UazVORGsyWDJFNE1qZGxZelV5TUdWZmJ5NXFjR2RjSWl4Y0ltOXlaR1Z5WENJNk5peGNJbUpuWENJNlhDSXZNakF4TkM4d05DODFOelF6TlRrNU5EazJYMkU0TWpkbFl6VXlNR1ZmYnk1cWNHZGNJaXhjSW1SMWNtRjBhVzl1WENJNk15eGNJbVpwYkd4TmIyUmxYQ0k2WENKbWFXeHNYQ0lzWENKMGFIVnRZbHdpT2x3aUx6SXdNVFF2TURRdk5UYzBNelU1T1RRNU5sOWhPREkzWldNMU1qQmxYMjh0TVRVd2VERTFNQzVxY0dkY0lpeGNJbUpuZGw5bWFXeHNiVzlrWlZ3aU9sd2labWxzYkZ3aUxGd2lZbWQyWDJ4dmIzQmNJanAwY25WbExGd2lZbWQyWDIxMWRHVmNJanAwY25WbExGd2lZbWQyWDJGMWRHOXdZWFZ6WlZ3aU9tWmhiSE5sTEZ3aWJHRjVaWEpmYVdSelhDSTZXMTE5SWl3aU9DSTZJbnRjSW1sa1hDSTZPQ3hjSW5ScGJXVnNhVzVsWDJoY0lqb3lNREFzWENKaVoxUm9kVzFpWENJNlhDSXZNakF4TkM4d05DODFOek0zTVRBMk5ESXpYMkkwTUdFelltUTJZVEZmYnkweE5UQjRNVFV3TG1wd1oxd2lMRndpZEdoMWJXSlBjbWRwYm1Gc1hDSTZYQ0l2TWpBeE5DOHdOQzgxTnpNM01UQTJOREl6WDJJME1HRXpZbVEyWVRGZmJ5NXFjR2RjSWl4Y0ltOXlaR1Z5WENJNk55eGNJbUpuWENJNlhDSXZNakF4TkM4d05DODFOek0zTVRBMk5ESXpYMkkwTUdFelltUTJZVEZmYnk1cWNHZGNJaXhjSW1SMWNtRjBhVzl1WENJNk15eGNJbVpwYkd4TmIyUmxYQ0k2WENKbWFXeHNYQ0lzWENKMGFIVnRZbHdpT2x3aUx6SXdNVFF2TURRdk5UY3pOekV3TmpReU0xOWlOREJoTTJKa05tRXhYMjh0TVRVd2VERTFNQzVxY0dkY0lpeGNJbUpuZGw5bWFXeHNiVzlrWlZ3aU9sd2labWxzYkZ3aUxGd2lZbWQyWDJ4dmIzQmNJanAwY25WbExGd2lZbWQyWDIxMWRHVmNJanAwY25WbExGd2lZbWQyWDJGMWRHOXdZWFZ6WlZ3aU9tWmhiSE5sTEZ3aWJHRjVaWEpmYVdSelhDSTZXMTE5SWl3aU9TSTZJbnRjSW1sa1hDSTZPU3hjSW5ScGJXVnNhVzVsWDJoY0lqb3lNREFzWENKaVoxUm9kVzFpWENJNlhDSXZNakF4TkM4d05DODFOekl6TkRnM05ERTRYekF5T1RNd1lqSTNPVFpmYnkweE5UQjRNVFV3TG1wd1oxd2lMRndpZEdoMWJXSlBjbWRwYm1Gc1hDSTZYQ0l2TWpBeE5DOHdOQzgxTnpJek5EZzNOREU0WHpBeU9UTXdZakkzT1RaZmJ5NXFjR2RjSWl4Y0ltOXlaR1Z5WENJNk9DeGNJbUpuWENJNlhDSXZNakF4TkM4d05DODFOekl6TkRnM05ERTRYekF5T1RNd1lqSTNPVFpmYnk1cWNHZGNJaXhjSW1SMWNtRjBhVzl1WENJNk15eGNJbVpwYkd4TmIyUmxYQ0k2WENKbWFXeHNYQ0lzWENKMGFIVnRZbHdpT2x3aUx6SXdNVFF2TURRdk5UY3lNelE0TnpReE9GOHdNamt6TUdJeU56azJYMjh0TVRVd2VERTFNQzVxY0dkY0lpeGNJbUpuZGw5bWFXeHNiVzlrWlZ3aU9sd2labWxzYkZ3aUxGd2lZbWQyWDJ4dmIzQmNJanAwY25WbExGd2lZbWQyWDIxMWRHVmNJanAwY25WbExGd2lZbWQyWDJGMWRHOXdZWFZ6WlZ3aU9tWmhiSE5sTEZ3aWJHRjVaWEpmYVdSelhDSTZXMTE5SWl3aU1UQWlPaUo3WENKcFpGd2lPakV3TEZ3aWRHbHRaV3hwYm1WZmFGd2lPakl3TUN4Y0ltSm5WR2gxYldKY0lqcGNJaTh5TURFMEx6QTBMelUyTnpZMk9ESXlNRE5mWldJNE9EWTFaREUyT0Y5dkxURTFNSGd4TlRBdWFuQm5YQ0lzWENKMGFIVnRZazl5WjJsdVlXeGNJanBjSWk4eU1ERTBMekEwTHpVMk56WTJPREl5TUROZlpXSTRPRFkxWkRFMk9GOXZMbXB3WjF3aUxGd2liM0prWlhKY0lqbzVMRndpWW1kY0lqcGNJaTh5TURFMEx6QTBMelUyTnpZMk9ESXlNRE5mWldJNE9EWTFaREUyT0Y5dkxtcHdaMXdpTEZ3aVpIVnlZWFJwYjI1Y0lqb3pMRndpWm1sc2JFMXZaR1ZjSWpwY0ltWnBiR3hjSWl4Y0luUm9kVzFpWENJNlhDSXZNakF4TkM4d05DODFOamMyTmpneU1qQXpYMlZpT0RnMk5XUXhOamhmYnkweE5UQjRNVFV3TG1wd1oxd2lMRndpWW1kMlgyWnBiR3h0YjJSbFhDSTZYQ0ptYVd4c1hDSXNYQ0ppWjNaZmJHOXZjRndpT25SeWRXVXNYQ0ppWjNaZmJYVjBaVndpT25SeWRXVXNYQ0ppWjNaZllYVjBiM0JoZFhObFhDSTZabUZzYzJVc1hDSnNZWGxsY2w5cFpITmNJanBiWFgwaUxDSXhNU0k2SW50Y0ltbGtYQ0k2TVRFc1hDSjBhVzFsYkdsdVpWOW9YQ0k2TWpBd0xGd2lZbWRVYUhWdFlsd2lPbHdpTHpJd01UUXZNRFF2TlRZMk5Ea3hPVE0yTlY5aU1USTVZalV5TXpreVgyOHRNVFV3ZURFMU1DNXFjR2RjSWl4Y0luUm9kVzFpVDNKbmFXNWhiRndpT2x3aUx6SXdNVFF2TURRdk5UWTJORGt4T1RNMk5WOWlNVEk1WWpVeU16a3lYMjh1YW5CblhDSXNYQ0p2Y21SbGNsd2lPakV3TEZ3aVltZGNJanBjSWk4eU1ERTBMekEwTHpVMk5qUTVNVGt6TmpWZllqRXlPV0kxTWpNNU1sOXZMbXB3WjF3aUxGd2laSFZ5WVhScGIyNWNJam96TEZ3aVptbHNiRTF2WkdWY0lqcGNJbVpwYkd4Y0lpeGNJblJvZFcxaVhDSTZYQ0l2TWpBeE5DOHdOQzgxTmpZME9URTVNelkxWDJJeE1qbGlOVEl6T1RKZmJ5MHhOVEI0TVRVd0xtcHdaMXdpTEZ3aVltZDJYMlpwYkd4dGIyUmxYQ0k2WENKbWFXeHNYQ0lzWENKaVozWmZiRzl2Y0Z3aU9uUnlkV1VzWENKaVozWmZiWFYwWlZ3aU9uUnlkV1VzWENKaVozWmZZWFYwYjNCaGRYTmxYQ0k2Wm1Gc2MyVXNYQ0pzWVhsbGNsOXBaSE5jSWpwYlhYMGlMQ0l4TXlJNkludGNJbWxrWENJNk1UTXNYQ0owYVcxbGJHbHVaVjlvWENJNk1qQXdMRndpWW1kVWFIVnRZbHdpT2x3aUx6SXdNVFF2TURRdk5UWXhNemMxTVRNeU9GOWxOVE14T0RRNE1UTmhYMjh0TVRVd2VERTFNQzVxY0dkY0lpeGNJblJvZFcxaVQzSm5hVzVoYkZ3aU9sd2lMekl3TVRRdk1EUXZOVFl4TXpjMU1UTXlPRjlsTlRNeE9EUTRNVE5oWDI4dWFuQm5YQ0lzWENKdmNtUmxjbHdpT2pFeExGd2lZbWRjSWpwY0lpOHlNREUwTHpBMEx6VTJNVE0zTlRFek1qaGZaVFV6TVRnME9ERXpZVjl2TG1wd1oxd2lMRndpWkhWeVlYUnBiMjVjSWpvekxGd2labWxzYkUxdlpHVmNJanBjSW1acGJHeGNJaXhjSW5Sb2RXMWlYQ0k2WENJdk1qQXhOQzh3TkM4MU5qRXpOelV4TXpJNFgyVTFNekU0TkRneE0yRmZieTB4TlRCNE1UVXdMbXB3WjF3aUxGd2lZbWQyWDJacGJHeHRiMlJsWENJNlhDSm1hV3hzWENJc1hDSmlaM1pmYkc5dmNGd2lPblJ5ZFdVc1hDSmlaM1pmYlhWMFpWd2lPblJ5ZFdVc1hDSmlaM1pmWVhWMGIzQmhkWE5sWENJNlptRnNjMlVzWENKc1lYbGxjbDlwWkhOY0lqcGJYWDBpZlN3aVRWTlFZVzVsYkM1RGIyNTBjbTlzSWpwN0lqUWlPaUo3WENKcFpGd2lPalFzWENKc1lXSmxiRndpT2x3aVFYSnliM2R6WENJc1hDSnVZVzFsWENJNlhDSmhjbkp2ZDNOY0lpeGNJbUYxZEc5SWFXUmxYQ0k2ZEhKMVpTeGNJbTkyWlhKV2FXUmxiMXdpT25SeWRXVXNYQ0pwYm5ObGRGd2lPblJ5ZFdWOUlpd2lOU0k2SW50Y0ltbGtYQ0k2TlN4Y0lteGhZbVZzWENJNlhDSlRZM0p2Ykd4aVlYSmNJaXhjSW01aGJXVmNJanBjSW5OamNtOXNiR0poY2x3aUxGd2lZWFYwYjBocFpHVmNJanBtWVd4elpTeGNJbTkyWlhKV2FXUmxiMXdpT25SeWRXVXNYQ0p0WVhKbmFXNWNJam94TUN4Y0ltUnBjbHdpT2x3aWFGd2lMRndpWTI5c2IzSmNJanBjSWlNelJETkVNMFJjSWl4Y0luZHBaSFJvWENJNk5DeGNJbUZzYVdkdVhDSTZYQ0owYjNCY0lpeGNJbWx1YzJWMFhDSTZkSEoxWlgwaUxDSTJJam9pZTF3aWFXUmNJam8yTEZ3aWJHRmlaV3hjSWpwY0lsUm9kVzFpYkdsemRDOVVZV0p6WENJc1hDSnVZVzFsWENJNlhDSjBhSFZ0WW14cGMzUmNJaXhjSW1GMWRHOUlhV1JsWENJNlptRnNjMlVzWENKdmRtVnlWbWxrWlc5Y0lqcDBjblZsTEZ3aWJXRnlaMmx1WENJNk5TeGNJbVJwY2x3aU9sd2lhRndpTEZ3aWMzQmhZMlZjSWpvMUxGd2lkMmxrZEdoY0lqb3hNamNzWENKb1pXbG5hSFJjSWpveE16Y3NYQ0poYkdsbmJsd2lPbHdpWW05MGRHOXRYQ0lzWENKcGJuTmxkRndpT21aaGJITmxmU0o5ZlE9PSIsInR5cGUiOiJjdXN0b20iLCJzbGlkZXNfbnVtIjoiMTIifX0sIm9yaWdpbl91cGxvYWRzX3VybCI6Imh0dHA6XC9cL2RlbW8uYXZlcnRhLm5ldFwvdGhlbWVzXC9sb3R1c1wvZHVtbXktYWdlbmN5XC93cC1jb250ZW50XC91cGxvYWRzIiwicHJlc2V0X3N0eWxlcyI6IiIsInByZXNldF9lZmZlY3RzIjoiIn0=',
			'image_dir' => '',
			'selected' 	=> '',
			'screenshot'=> MSWP_AVERTA_ADMIN_URL . '/assets/images/starters/slider-with-horizontal-thumbs.jpg'
		),
		array(
			'label' 	=> __( 'Fullscreen with Background Video', MSWP_TEXT_DOMAIN ),
			'id' 		=> 'fullscreen-screen-slider-1',
			'slidertype'=> 'custom',
			'importdata'=> 'eyJzbGlkZXJzX2RhdGEiOnsiNDMiOnsidGl0bGUiOiJGdWxsc2NyZWVuIFNsaWRlciB3aWR0aCBCYWNrZ3JvdW5kIFZpZGVvIiwicGFyYW1zIjoiZXlKdFpYUmhJanA3SWxObGRIUnBibWR6SVdsa2N5STZJakVpTENKVFpYUjBhVzVuY3lGdVpYaDBTV1FpT2pJc0lsTnNhV1JsSVdsa2N5STZJaklzTXl3MExEWXNOeUlzSWxOc2FXUmxJVzVsZUhSSlpDSTZPQ3dpVTNSNWJHVWhhV1J6SWpvaU1Td3lMRE1zTkN3MUxEWXNPQ3c1TERFd0xERXhJaXdpVTNSNWJHVWhibVY0ZEVsa0lqb3hOQ3dpUldabVpXTjBJV2xrY3lJNklqRXNNaXd6TERRc05TdzJMRGNzT0N3NUxERXdMREV4TERFeUxERTFMREUyTERFM0xERTRMREU1TERJd0xESXhMREl5SWl3aVJXWm1aV04wSVc1bGVIUkpaQ0k2TWpjc0lreGhlV1Z5SVdsa2N5STZJakVzTWl3ekxEUXNOU3cyTERnc09Td3hNQ3d4TVNJc0lreGhlV1Z5SVc1bGVIUkpaQ0k2TVRSOUxDSk5VMUJoYm1Wc0xsTmxkSFJwYm1keklqcDdJakVpT2lKN1hDSnBaRndpT2x3aU1Wd2lMRndpYzI1aGNIQnBibWRjSWpwMGNuVmxMRndpYm1GdFpWd2lPbHdpUm5Wc2JITmpjbVZsYmlCVGJHbGtaWElnZDJsa2RHZ2dRbUZqYTJkeWIzVnVaQ0JXYVdSbGIxd2lMRndpZDJsa2RHaGNJam94TURBd0xGd2lhR1ZwWjJoMFhDSTZOVEF3TEZ3aWQzSmhjSEJsY2xkcFpIUm9YQ0k2TVRBd01DeGNJbmR5WVhCd1pYSlhhV1IwYUZWdWFYUmNJanBjSW5CNFhDSXNYQ0poZFhSdlEzSnZjRndpT21aaGJITmxMRndpZEhsd1pWd2lPbHdpWTNWemRHOXRYQ0lzWENKc1lYbHZkWFJjSWpwY0ltWjFiR3h6WTNKbFpXNWNJaXhjSW1GMWRHOUlaV2xuYUhSY0lqcG1ZV3h6WlN4Y0luUnlWbWxsZDF3aU9sd2lZbUZ6YVdOY0lpeGNJbk53WldWa1hDSTZNakFzWENKemNHRmpaVndpT2pBc1hDSnpkR0Z5ZEZ3aU9qRXNYQ0puY21GaVEzVnljMjl5WENJNmRISjFaU3hjSW5OM2FYQmxYQ0k2ZEhKMVpTeGNJbTF2ZFhObFhDSTZkSEoxWlN4Y0luZG9aV1ZzWENJNlptRnNjMlVzWENKaGRYUnZjR3hoZVZ3aU9tWmhiSE5sTEZ3aWJHOXZjRndpT25SeWRXVXNYQ0p6YUhWbVpteGxYQ0k2Wm1Gc2MyVXNYQ0p3Y21Wc2IyRmtYQ0k2TVN4Y0ltOTJaWEpRWVhWelpWd2lPblJ5ZFdVc1hDSmxibVJRWVhWelpWd2lPbVpoYkhObExGd2lhR2xrWlV4aGVXVnljMXdpT21aaGJITmxMRndpWkdseVhDSTZYQ0pvWENJc1hDSmpaVzUwWlhKRGIyNTBjbTlzYzF3aU9uUnlkV1VzWENKcGJuTjBZVzUwVTJodmQweGhlV1Z5YzF3aU9tWmhiSE5sTEZ3aWMydHBibHdpT2x3aWJYTXRjMnRwYmkxa1pXWmhkV3gwWENJc1hDSnRjMVJsYlhCc1lYUmxYQ0k2WENKamRYTjBiMjFjSWl4Y0ltMXpWR1Z0Y0d4aGRHVkRiR0Z6YzF3aU9sd2lYQ0lzWENKMWMyVmtSbTl1ZEhOY0lqcGNJa3hoZEc4Nk16QXdMRGN3TUN3eE1EQmNJbjBpZlN3aVRWTlFZVzVsYkM1VGJHbGtaU0k2ZXlJeUlqb2llMXdpYVdSY0lqb3lMRndpZEdsdFpXeHBibVZmYUZ3aU9qSXdNQ3hjSW1KblZHaDFiV0pjSWpwY0lpOHlNREUwTHpBMEx6VXlNall5T1RBeE1UWmZOR00wTm1ZMVpUQXlNMTl2TVMweE5UQjRNVFV3TG1wd1oxd2lMRndpYjNKa1pYSmNJam93TEZ3aVltZGNJanBjSWk4eU1ERTBMekEwTHpVeU1qWXlPVEF4TVRaZk5HTTBObVkxWlRBeU0xOXZNUzVxY0dkY0lpeGNJbVIxY21GMGFXOXVYQ0k2TXl4Y0ltWnBiR3hOYjJSbFhDSTZYQ0ptYVd4c1hDSXNYQ0ppWjNaZlptbHNiRzF2WkdWY0lqcGNJbVpwYkd4Y0lpeGNJbUpuZGw5c2IyOXdYQ0k2ZEhKMVpTeGNJbUpuZGw5dGRYUmxYQ0k2ZEhKMVpTeGNJbUpuZGw5aGRYUnZjR0YxYzJWY0lqcG1ZV3h6WlN4Y0lteGhlV1Z5WDJsa2Mxd2lPbHN5TERNc05sMTlJaXdpTXlJNkludGNJbWxrWENJNk15eGNJblJwYldWc2FXNWxYMmhjSWpveE16UXNYQ0ppWjFSb2RXMWlYQ0k2WENJdk1qQXhOQzh3TkM4MU56UTBOamd6TkRFMVgyWXpZemM0TVdFelpqaGZiekV0TVRVd2VERTFNQzVxY0dkY0lpeGNJbTl5WkdWeVhDSTZNaXhjSW1KblhDSTZYQ0l2TWpBeE5DOHdOQzgxTnpRME5qZ3pOREUxWDJZell6YzRNV0V6WmpoZmJ6RXVhbkJuWENJc1hDSmtkWEpoZEdsdmJsd2lPak1zWENKbWFXeHNUVzlrWlZ3aU9sd2labWxzYkZ3aUxGd2lZbWQyWDJacGJHeHRiMlJsWENJNlhDSm1hV3hzWENJc1hDSmlaM1pmYkc5dmNGd2lPblJ5ZFdVc1hDSmlaM1pmYlhWMFpWd2lPblJ5ZFdVc1hDSmlaM1pmWVhWMGIzQmhkWE5sWENJNlptRnNjMlVzWENKc1lYbGxjbDlwWkhOY0lqcGJOQ3cxWFgwaUxDSTBJam9pZTF3aWFXUmNJam8wTEZ3aWRHbHRaV3hwYm1WZmFGd2lPakl3TUN4Y0ltSm5WR2gxYldKY0lqcGNJaTh5TURFMEx6QTBMelUzT0RjeU1ESXpOalZmTlRjME9ETTBPREkyTkY5dk1TMHhOVEI0TVRVd0xtcHdaMXdpTEZ3aWIzSmtaWEpjSWpveExGd2lZbWRjSWpwY0lpOHlNREUwTHpBMEx6VTNPRGN5TURJek5qVmZOVGMwT0RNME9ESTJORjl2TVM1cWNHZGNJaXhjSW1SMWNtRjBhVzl1WENJNk15eGNJbVpwYkd4TmIyUmxYQ0k2WENKbWFXeHNYQ0lzWENKaVozWmZabWxzYkcxdlpHVmNJanBjSW1acGJHeGNJaXhjSW1KbmRsOXNiMjl3WENJNmRISjFaU3hjSW1KbmRsOXRkWFJsWENJNmRISjFaU3hjSW1KbmRsOWhkWFJ2Y0dGMWMyVmNJanBtWVd4elpTeGNJbXhoZVdWeVgybGtjMXdpT2xzNExEa3NNVEJkZlNJc0lqWWlPaUo3WENKcFpGd2lPallzWENKMGFXMWxiR2x1WlY5b1hDSTZNVE0xTEZ3aVltZFVhSFZ0WWx3aU9sd2lMekl3TVRRdk1EUXZPRFEzTURJM01UWTRNVjh6TlRJeU5tSXlNalZqWDJzeExURTFNSGd4TlRBdWFuQm5YQ0lzWENKdmNtUmxjbHdpT2pNc1hDSmlaMXdpT2x3aUx6SXdNVFF2TURRdk9EUTNNREkzTVRZNE1WOHpOVEl5Tm1JeU1qVmpYMnN4TG1wd1oxd2lMRndpWkhWeVlYUnBiMjVjSWpvekxGd2labWxzYkUxdlpHVmNJanBjSW1acGJHeGNJaXhjSW1KbmRsOW1hV3hzYlc5a1pWd2lPbHdpWm1sc2JGd2lMRndpWW1kMlgyeHZiM0JjSWpwMGNuVmxMRndpWW1kMlgyMTFkR1ZjSWpwMGNuVmxMRndpWW1kMlgyRjFkRzl3WVhWelpWd2lPbVpoYkhObExGd2liR0Y1WlhKZmFXUnpYQ0k2VzF3aU1Wd2lYWDBpTENJM0lqb2llMXdpYVdSY0lqbzNMRndpZEdsdFpXeHBibVZmYUZ3aU9qRXlPQ3hjSW05eVpHVnlYQ0k2TkN4Y0ltUjFjbUYwYVc5dVhDSTZNeXhjSW1acGJHeE5iMlJsWENJNlhDSm1hV3hzWENJc1hDSmlaM1pmYlhBMFhDSTZYQ0pvZEhSd09pOHZkM2QzTG0xaGMzUmxjbk5zYVdSbGNpNWpiMjB2Wm1WaGRIVnlaWE12ZEdWdGNHeGhkR1Z6TDIxekwyWjFiR3h6WTNKbFpXNHZkbWxrWlc4dmRtbGtaVzh1YlhBMFhDSXNYQ0ppWjNaZmIyZG5YQ0k2WENKY0lpeGNJbUpuZGw5M1pXSnRYQ0k2WENKY0lpeGNJbUpuZGw5bWFXeHNiVzlrWlZ3aU9sd2labWxzYkZ3aUxGd2lZbWQyWDJ4dmIzQmNJanAwY25WbExGd2lZbWQyWDIxMWRHVmNJanAwY25WbExGd2lZbWQyWDJGMWRHOXdZWFZ6WlZ3aU9tWmhiSE5sTEZ3aWJHRjVaWEpmYVdSelhDSTZXekV4WFgwaWZTd2lUVk5RWVc1bGJDNVRkSGxzWlNJNmV5SXhJam9pZTF3aWFXUmNJanBjSWpGY0lpeGNJblI1Y0dWY0lqcGNJbU4xYzNSdmJWd2lMRndpWTJ4aGMzTk9ZVzFsWENJNlhDSnRjM0F0WTI0dE1qa3dMVEZjSWl4Y0ltSmhZMnRuY205MWJtUkRiMnh2Y2x3aU9sd2ljbWRpWVNneExDQXhNaklzSURFME9Td2dNQzQzTlNsY0lpeGNJbkJoWkdScGJtZFViM0JjSWpveE5TeGNJbkJoWkdScGJtZFNhV2RvZEZ3aU9qTXdMRndpY0dGa1pHbHVaMEp2ZEhSdmJWd2lPakUxTEZ3aWNHRmtaR2x1WjB4bFpuUmNJam96TUN4Y0ltWnZiblJHWVcxcGJIbGNJanBjSWt4aGRHOWNJaXhjSW1admJuUlhaV2xuYUhSY0lqcGNJak13TUZ3aUxGd2labTl1ZEZOcGVtVmNJam96TlN4Y0lteHBibVZJWldsbmFIUmNJanBjSW01dmNtMWhiRndpTEZ3aVkyOXNiM0pjSWpwY0lpTm1abVptWm1aY0luMGlMQ0l5SWpvaWUxd2lhV1JjSWpveUxGd2lkSGx3WlZ3aU9sd2lZM1Z6ZEc5dFhDSXNYQ0pqYkdGemMwNWhiV1ZjSWpwY0ltMXpjQzFqYmkweU9UQXRNbHdpTEZ3aVltRmphMmR5YjNWdVpFTnZiRzl5WENJNlhDSnlaMkpoS0RJMU5Td2dNalUxTENBeU5UVXNJREF1TnpVcFhDSXNYQ0p3WVdSa2FXNW5WRzl3WENJNk1UVXNYQ0p3WVdSa2FXNW5VbWxuYUhSY0lqb3hOakFzWENKd1lXUmthVzVuUW05MGRHOXRYQ0k2TVRVc1hDSndZV1JrYVc1blRHVm1kRndpT2pNd0xGd2labTl1ZEVaaGJXbHNlVndpT2x3aVRHRjBiMXdpTEZ3aVptOXVkRmRsYVdkb2RGd2lPbHdpTXpBd1hDSXNYQ0ptYjI1MFUybDZaVndpT2pRMUxGd2liR2x1WlVobGFXZG9kRndpT2x3aWJtOXliV0ZzWENJc1hDSmpiMnh2Y2x3aU9sd2lJelEwTkRRME5Gd2lmU0lzSWpNaU9pSjdYQ0pwWkZ3aU9qTXNYQ0owZVhCbFhDSTZYQ0pqZFhOMGIyMWNJaXhjSW1Oc1lYTnpUbUZ0WlZ3aU9sd2liWE53TFdOdUxUSTVNQzB6WENJc1hDSmlZV05yWjNKdmRXNWtRMjlzYjNKY0lqcGNJbkpuWW1Fb01Dd2dNQ3dnTUN3Z01DNDNOU2xjSWl4Y0luQmhaR1JwYm1kVWIzQmNJam94TlN4Y0luQmhaR1JwYm1kU2FXZG9kRndpT2pNd0xGd2ljR0ZrWkdsdVowSnZkSFJ2YlZ3aU9qRTFMRndpY0dGa1pHbHVaMHhsWm5SY0lqb3pNQ3hjSW1admJuUkdZVzFwYkhsY0lqcGNJa3hoZEc5Y0lpeGNJbVp2Ym5SWFpXbG5hSFJjSWpwY0lqTXdNRndpTEZ3aVptOXVkRk5wZW1WY0lqb3lOU3hjSW14cGJtVklaV2xuYUhSY0lqcGNJbTV2Y20xaGJGd2lMRndpWTI5c2IzSmNJanBjSWlObVptWm1abVpjSW4waUxDSTBJam9pZTF3aWFXUmNJam8wTEZ3aWRIbHdaVndpT2x3aVkzVnpkRzl0WENJc1hDSmpiR0Z6YzA1aGJXVmNJanBjSW0xemNDMWpiaTB5T1RBdE5Gd2lMRndpWW1GamEyZHliM1Z1WkVOdmJHOXlYQ0k2WENKeVoySmhLREFzSURBc0lEQXNJREF1TnpVcFhDSXNYQ0p3WVdSa2FXNW5WRzl3WENJNk1UVXNYQ0p3WVdSa2FXNW5VbWxuYUhSY0lqb3pNQ3hjSW5CaFpHUnBibWRDYjNSMGIyMWNJam94TlN4Y0luQmhaR1JwYm1kTVpXWjBYQ0k2TXpBc1hDSm1iMjUwUm1GdGFXeDVYQ0k2WENKTVlYUnZYQ0lzWENKbWIyNTBWMlZwWjJoMFhDSTZYQ0l6TURCY0lpeGNJbVp2Ym5SVGFYcGxYQ0k2TWpBc1hDSnNhVzVsU0dWcFoyaDBYQ0k2WENKdWIzSnRZV3hjSWl4Y0ltTnZiRzl5WENJNlhDSWpabVptWm1abVhDSjlJaXdpTlNJNkludGNJbWxrWENJNk5TeGNJblI1Y0dWY0lqcGNJbU4xYzNSdmJWd2lMRndpWTJ4aGMzTk9ZVzFsWENJNlhDSnRjM0F0WTI0dE1qa3dMVFZjSWl4Y0ltSmhZMnRuY205MWJtUkRiMnh2Y2x3aU9sd2ljbWRpWVNnNE9Dd2dNVEl5TENBNU5Td2dNQzQzTlNsY0lpeGNJbkJoWkdScGJtZFViM0JjSWpveE5TeGNJbkJoWkdScGJtZFNhV2RvZEZ3aU9qTXdMRndpY0dGa1pHbHVaMEp2ZEhSdmJWd2lPakUxTEZ3aWNHRmtaR2x1WjB4bFpuUmNJam96TUN4Y0ltWnZiblJHWVcxcGJIbGNJanBjSWt4aGRHOWNJaXhjSW1admJuUlhaV2xuYUhSY0lqcGNJak13TUZ3aUxGd2labTl1ZEZOcGVtVmNJam96TUN4Y0lteHBibVZJWldsbmFIUmNJanBjSW01dmNtMWhiRndpTEZ3aVkyOXNiM0pjSWpwY0lpTm1abVptWm1aY0luMGlMQ0kySWpvaWUxd2lhV1JjSWpvMkxGd2labTl1ZEZkbGFXZG9kRndpT2x3aWJtOXliV0ZzWENJc1hDSnNhVzVsU0dWcFoyaDBYQ0k2WENKdWIzSnRZV3hjSW4waUxDSTRJam9pZTF3aWFXUmNJam80TEZ3aWRIbHdaVndpT2x3aVkzVnpkRzl0WENJc1hDSmpiR0Z6YzA1aGJXVmNJanBjSW0xemNDMWpiaTB5T1RBdE9Gd2lMRndpWm05dWRFWmhiV2xzZVZ3aU9sd2lUR0YwYjF3aUxGd2labTl1ZEZkbGFXZG9kRndpT2x3aU56QXdYQ0lzWENKbWIyNTBVMmw2WlZ3aU9qSTFMRndpYkdsdVpVaGxhV2RvZEZ3aU9sd2libTl5YldGc1hDSXNYQ0pqYjJ4dmNsd2lPbHdpSTJabVptWm1abHdpZlNJc0lqa2lPaUo3WENKcFpGd2lPamtzWENKbWIyNTBWMlZwWjJoMFhDSTZYQ0p1YjNKdFlXeGNJaXhjSW14cGJtVklaV2xuYUhSY0lqcGNJbTV2Y20xaGJGd2lmU0lzSWpFd0lqb2llMXdpYVdSY0lqb3hNQ3hjSW5SNWNHVmNJanBjSW1OMWMzUnZiVndpTEZ3aVkyeGhjM05PWVcxbFhDSTZYQ0p0YzNBdFkyNHRNamt3TFRFd1hDSXNYQ0ptYjI1MFJtRnRhV3g1WENJNlhDSk1ZWFJ2WENJc1hDSm1iMjUwVjJWcFoyaDBYQ0k2WENJeE1EQmNJaXhjSW1admJuUlRhWHBsWENJNk5UQXNYQ0pzYVc1bFNHVnBaMmgwWENJNlhDSnViM0p0WVd4Y0lpeGNJbU52Ykc5eVhDSTZYQ0lqWm1abVptWm1YQ0o5SWl3aU1URWlPaUo3WENKcFpGd2lPakV4TEZ3aWRIbHdaVndpT2x3aVkzVnpkRzl0WENJc1hDSmpiR0Z6YzA1aGJXVmNJanBjSW0xemNDMWpiaTB5T1RBdE1URmNJaXhjSW5CaFpHUnBibWRVYjNCY0lqb3hOU3hjSW5CaFpHUnBibWRTYVdkb2RGd2lPak13TEZ3aWNHRmtaR2x1WjBKdmRIUnZiVndpT2pFMUxGd2ljR0ZrWkdsdVoweGxablJjSWpvek1DeGNJbUp2Y21SbGNsUnZjRndpT2pJc1hDSmliM0prWlhKU2FXZG9kRndpT2pJc1hDSmliM0prWlhKQ2IzUjBiMjFjSWpveUxGd2lZbTl5WkdWeVRHVm1kRndpT2pJc1hDSmliM0prWlhKVGRIbHNaVndpT2x3aWMyOXNhV1JjSWl4Y0ltWnZiblJHWVcxcGJIbGNJanBjSWt4aGRHOWNJaXhjSW1admJuUlhaV2xuYUhSY0lqcGNJamN3TUZ3aUxGd2labTl1ZEZOcGVtVmNJam8xTUN4Y0lteHBibVZJWldsbmFIUmNJanBjSW01dmNtMWhiRndpTEZ3aVkyOXNiM0pjSWpwY0lpTm1abVptWm1aY0luMGlmU3dpVFZOUVlXNWxiQzVGWm1abFkzUWlPbnNpTVNJNkludGNJbWxrWENJNlhDSXhYQ0lzWENKbVlXUmxYQ0k2ZEhKMVpTeGNJblJ5WVc1emJHRjBaVnBjSWpvMU1EQXNYQ0p5YjNSaGRHVmNJam90TVRCOUlpd2lNaUk2SW50Y0ltbGtYQ0k2TWl4Y0ltWmhaR1ZjSWpwMGNuVmxmU0lzSWpNaU9pSjdYQ0pwWkZ3aU9qTXNYQ0ptWVdSbFhDSTZkSEoxWlN4Y0luUnlZVzV6YkdGMFpWbGNJam90TVRVd0xGd2ljbTkwWVhSbFdGd2lPamN3ZlNJc0lqUWlPaUo3WENKcFpGd2lPalFzWENKbVlXUmxYQ0k2ZEhKMVpYMGlMQ0kxSWpvaWUxd2lhV1JjSWpvMUxGd2labUZrWlZ3aU9uUnlkV1VzWENKMGNtRnVjMnhoZEdWWlhDSTZNVFV3ZlNJc0lqWWlPaUo3WENKcFpGd2lPallzWENKbVlXUmxYQ0k2ZEhKMVpYMGlMQ0kzSWpvaWUxd2lhV1JjSWpvM0xGd2labUZrWlZ3aU9uUnlkV1VzWENKMGNtRnVjMnhoZEdWWVhDSTZNQ3hjSW5SeVlXNXpiR0YwWlZsY0lqb3ROakFzWENKeWIzUmhkR1ZZWENJNk5qVXNYQ0p5YjNSaGRHVmFYQ0k2TUN4Y0luTnJaWGRaWENJNkxURTFmU0lzSWpnaU9pSjdYQ0pwWkZ3aU9qZ3NYQ0ptWVdSbFhDSTZkSEoxWlgwaUxDSTVJam9pZTF3aWFXUmNJam81TEZ3aVptRmtaVndpT25SeWRXVXNYQ0owY21GdWMyeGhkR1ZaWENJNkxUWXdMRndpY205MFlYUmxXRndpT2pZMUxGd2ljMnRsZDFsY0lqb3RNVFY5SWl3aU1UQWlPaUo3WENKcFpGd2lPakV3TEZ3aVptRmtaVndpT25SeWRXVjlJaXdpTVRFaU9pSjdYQ0pwWkZ3aU9qRXhMRndpWm1Ga1pWd2lPblJ5ZFdVc1hDSnpZMkZzWlZoY0lqb3hMalVzWENKelkyRnNaVmxjSWpveExqVjlJaXdpTVRJaU9pSjdYQ0pwWkZ3aU9qRXlMRndpWm1Ga1pWd2lPblJ5ZFdWOUlpd2lNVFVpT2lKN1hDSnBaRndpT2pFMUxGd2labUZrWlZ3aU9uUnlkV1VzWENKMGNtRnVjMnhoZEdWWVhDSTZMVEkxTUN4Y0luTnJaWGRZWENJNkxUSTFmU0lzSWpFMklqb2llMXdpYVdSY0lqb3hOaXhjSW1aaFpHVmNJanAwY25WbGZTSXNJakUzSWpvaWUxd2lhV1JjSWpveE55eGNJbVpoWkdWY0lqcDBjblZsTEZ3aWRISmhibk5zWVhSbFdWd2lPakUxTUgwaUxDSXhPQ0k2SW50Y0ltbGtYQ0k2TVRnc1hDSm1ZV1JsWENJNmRISjFaWDBpTENJeE9TSTZJbnRjSW1sa1hDSTZNVGtzWENKbVlXUmxYQ0k2ZEhKMVpTeGNJblJ5WVc1emJHRjBaVmhjSWpveE5UQjlJaXdpTWpBaU9pSjdYQ0pwWkZ3aU9qSXdMRndpWm1Ga1pWd2lPblJ5ZFdWOUlpd2lNakVpT2lKN1hDSnBaRndpT2pJeExGd2labUZrWlZ3aU9uUnlkV1VzWENKMGNtRnVjMnhoZEdWWlhDSTZNVFV3TEZ3aWMyTmhiR1ZaWENJNk1DNDJOWDBpTENJeU1pSTZJbnRjSW1sa1hDSTZNaklzWENKbVlXUmxYQ0k2ZEhKMVpYMGlmU3dpVFZOUVlXNWxiQzVNWVhsbGNpSTZleUl4SWpvaWUxd2lhV1JjSWpwY0lqRmNJaXhjSW01aGJXVmNJanBjSW5SNGRGd2lMRndpYVhOTWIyTnJaV1JjSWpwbVlXeHpaU3hjSW1selNHbGtaV1JjSWpwbVlXeHpaU3hjSW1selUyOXNiMlZrWENJNlptRnNjMlVzWENKemFHOTNWSEpoYm5ObWIzSnRYQ0k2WENKd1pYSnpjR1ZqZEdsMlpTZ3lNREF3Y0hncElIUnlZVzV6YkdGMFpWb29OVEF3Y0hncGNtOTBZWFJsS0MweE1HUmxaeWtnWENJc1hDSnphRzkzVDNKcFoybHVYQ0k2WENJMU1DVWdOVEFsSURCd2VGd2lMRndpYzJodmQwWmhaR1ZjSWpwMGNuVmxMRndpYUdsa1pWUnlZVzV6Wm05eWJWd2lPbHdpWENJc1hDSm9hV1JsVDNKcFoybHVYQ0k2WENKY0lpeGNJbWhwWkdWR1lXUmxYQ0k2ZEhKMVpTeGNJbTl5WkdWeVhDSTZNQ3hjSW5SNWNHVmNJanBjSW5SbGVIUmNJaXhjSW1OdmJuUmxiblJjSWpwY0lrWlZURXdnVTBOU1JVVk9JRUpCUTB0SFVrOVZUa1FnVTFWUVVFOVNWRndpTEZ3aWRtbGtaVzljSWpwY0ltaDBkSEE2THk5d2JHRjVaWEl1ZG1sdFpXOHVZMjl0TDNacFpHVnZMekV4TnpJeE1qUXlYQ0lzWENKaGJHbG5ibHdpT2x3aWRHOXdYQ0lzWENKdlptWnpaWFJZWENJNk1UVXdMRndpYjJabWMyVjBXVndpT2pReU9TeGNJbkpsYzJsNlpWd2lPblJ5ZFdVc1hDSjNhV1IwYUd4cGJXbDBYQ0k2WENJd1hDSXNYQ0pqYkdGemMwNWhiV1ZjSWpwY0ltMXpjQzFqYmkweU9UQXRNVndpTEZ3aWMyaHZkMFIxY21GMGFXOXVYQ0k2TWl4Y0luTm9iM2RFWld4aGVWd2lPakFzWENKemFHOTNSV0Z6WlZ3aU9sd2laV0Z6WlU5MWRFSmhZMnRjSWl4Y0luTm9iM2RGWm1aR2RXNWpYQ0k2WENKMEtIUnlkV1VzYml4dUxEVXdNQ3d0TVRBc2JpeHVMRzRzYml4dUxHNHNiaXh1TEc0c2JpbGNJaXhjSW5WelpVaHBaR1ZjSWpwbVlXeHpaU3hjSW1ocFpHVkVkWEpoZEdsdmJsd2lPakVzWENKb2FXUmxSR1ZzWVhsY0lqb3hMRndpYUdsa1pVVmhjMlZjSWpwY0ltVmhjMlZQZFhSUmRXbHVkRndpTEZ3aWMyeHBaR1ZjSWpvMkxGd2ljM1I1YkdWTmIyUmxiRndpT2x3aU1Wd2lMRndpYzJodmQwVm1abVZqZEZ3aU9sd2lNVndpTEZ3aWFHbGtaVVZtWm1WamRGd2lPako5SWl3aU1pSTZJbnRjSW1sa1hDSTZNaXhjSW01aGJXVmNJanBjSW5SNGRGd2lMRndpYVhOTWIyTnJaV1JjSWpwbVlXeHpaU3hjSW1selNHbGtaV1JjSWpwbVlXeHpaU3hjSW1selUyOXNiMlZrWENJNlptRnNjMlVzWENKemFHOTNWSEpoYm5ObWIzSnRYQ0k2WENKd1pYSnpjR1ZqZEdsMlpTZ3lNREF3Y0hncElIUnlZVzV6YkdGMFpWa29MVEUxTUhCNEtTQnliM1JoZEdWWUtEY3daR1ZuS1NCY0lpeGNJbk5vYjNkUGNtbG5hVzVjSWpwY0lqVXdKU0ExTUNVZ01IQjRYQ0lzWENKemFHOTNSbUZrWlZ3aU9uUnlkV1VzWENKb2FXUmxWSEpoYm5ObWIzSnRYQ0k2WENKY0lpeGNJbWhwWkdWUGNtbG5hVzVjSWpwY0lsd2lMRndpYUdsa1pVWmhaR1ZjSWpwMGNuVmxMRndpYjNKa1pYSmNJam94TEZ3aWRIbHdaVndpT2x3aWRHVjRkRndpTEZ3aVkyOXVkR1Z1ZEZ3aU9sd2lSbFZNVEZORFVrVkZUbHdpTEZ3aWRtbGtaVzljSWpwY0ltaDBkSEE2THk5d2JHRjVaWEl1ZG1sdFpXOHVZMjl0TDNacFpHVnZMekV4TnpJeE1qUXlYQ0lzWENKaGJHbG5ibHdpT2x3aWRHOXdYQ0lzWENKdlptWnpaWFJZWENJNk5ESTRMRndpYjJabWMyVjBXVndpT2pNMU1peGNJbkpsYzJsNlpWd2lPblJ5ZFdVc1hDSjNhV1IwYUd4cGJXbDBYQ0k2WENJd1hDSXNYQ0pqYkdGemMwNWhiV1ZjSWpwY0ltMXpjQzFqYmkweU9UQXRNbHdpTEZ3aWMyaHZkMFIxY21GMGFXOXVYQ0k2TVM0MUxGd2ljMmh2ZDBSbGJHRjVYQ0k2TUN4Y0luTm9iM2RGWVhObFhDSTZYQ0psWVhObFNXNVBkWFJSZFdGeWRGd2lMRndpYzJodmQwVm1aa1oxYm1OY0lqcGNJblFvZEhKMVpTeHVMQzB4TlRBc2JpeHVMRGN3TEc0c2JpeHVMRzRzYml4dUxHNHNiaXh1S1Z3aUxGd2lkWE5sU0dsa1pWd2lPbVpoYkhObExGd2lhR2xrWlVSMWNtRjBhVzl1WENJNk1TeGNJbWhwWkdWRVpXeGhlVndpT2pFc1hDSm9hV1JsUldGelpWd2lPbHdpWldGelpVOTFkRkYxYVc1MFhDSXNYQ0p6Ykdsa1pWd2lPaklzWENKemRIbHNaVTF2WkdWc1hDSTZNaXhjSW5Ob2IzZEZabVpsWTNSY0lqb3pMRndpYUdsa1pVVm1abVZqZEZ3aU9qUjlJaXdpTXlJNkludGNJbWxrWENJNk15eGNJbTVoYldWY0lqcGNJblI0ZEZ3aUxGd2lhWE5NYjJOclpXUmNJanBtWVd4elpTeGNJbWx6U0dsa1pXUmNJanBtWVd4elpTeGNJbWx6VTI5c2IyVmtYQ0k2Wm1Gc2MyVXNYQ0p6YUc5M1ZISmhibk5tYjNKdFhDSTZYQ0p3WlhKemNHVmpkR2wyWlNneU1EQXdjSGdwSUhSeVlXNXpiR0YwWlZrb01UVXdjSGdwSUZ3aUxGd2ljMmh2ZDA5eWFXZHBibHdpT2x3aU5UQWxJRFV3SlNBd2NIaGNJaXhjSW5Ob2IzZEdZV1JsWENJNmRISjFaU3hjSW1ocFpHVlVjbUZ1YzJadmNtMWNJanBjSWx3aUxGd2lhR2xrWlU5eWFXZHBibHdpT2x3aVhDSXNYQ0pvYVdSbFJtRmtaVndpT25SeWRXVXNYQ0p2Y21SbGNsd2lPakFzWENKMGVYQmxYQ0k2WENKMFpYaDBYQ0lzWENKamIyNTBaVzUwWENJNlhDSlVSVTFRVEVGVVJWd2lMRndpZG1sa1pXOWNJanBjSW1oMGRIQTZMeTl3YkdGNVpYSXVkbWx0Wlc4dVkyOXRMM1pwWkdWdkx6RXhOekl4TWpReVhDSXNYQ0poYkdsbmJsd2lPbHdpZEc5d1hDSXNYQ0p2Wm1aelpYUllYQ0k2TkRJNExGd2liMlptYzJWMFdWd2lPalF6Tml4Y0luSmxjMmw2WlZ3aU9uUnlkV1VzWENKM2FXUjBhR3hwYldsMFhDSTZYQ0l3WENJc1hDSmpiR0Z6YzA1aGJXVmNJanBjSW0xemNDMWpiaTB5T1RBdE0xd2lMRndpYzJodmQwUjFjbUYwYVc5dVhDSTZNQzQ1TlN4Y0luTm9iM2RFWld4aGVWd2lPakF1TnpZeU5TeGNJbk5vYjNkRllYTmxYQ0k2WENKbFlYTmxUM1YwVVhWcGJuUmNJaXhjSW5Ob2IzZEZabVpHZFc1alhDSTZYQ0owS0hSeWRXVXNiaXd4TlRBc2JpeHVMRzRzYml4dUxHNHNiaXh1TEc0c2JpeHVMRzRwWENJc1hDSjFjMlZJYVdSbFhDSTZabUZzYzJVc1hDSm9hV1JsUkhWeVlYUnBiMjVjSWpveExGd2lhR2xrWlVSbGJHRjVYQ0k2TVN4Y0ltaHBaR1ZGWVhObFhDSTZYQ0psWVhObFQzVjBVWFZwYm5SY0lpeGNJbk5zYVdSbFhDSTZNaXhjSW5OMGVXeGxUVzlrWld4Y0lqb3pMRndpYzJodmQwVm1abVZqZEZ3aU9qVXNYQ0pvYVdSbFJXWm1aV04wWENJNk5uMGlMQ0kwSWpvaWUxd2lhV1JjSWpvMExGd2libUZ0WlZ3aU9sd2lkSGgwWENJc1hDSnBjMHh2WTJ0bFpGd2lPbVpoYkhObExGd2lhWE5JYVdSbFpGd2lPbVpoYkhObExGd2lhWE5UYjJ4dlpXUmNJanBtWVd4elpTeGNJbk5vYjNkVWNtRnVjMlp2Y20xY0lqcGNJbkJsY25Od1pXTjBhWFpsS0RJd01EQndlQ2tnZEhKaGJuTnNZWFJsV0Nnd2NIZ3BJSFJ5WVc1emJHRjBaVmtvTFRZd2NIZ3BJSEp2ZEdGMFpWZ29OalZrWldjcElISnZkR0YwWlZvb01HUmxaeWtnYzJ0bGQxa29MVEUxWkdWbktTQmNJaXhjSW5Ob2IzZFBjbWxuYVc1Y0lqcGNJalV3SlNBMU1DVWdNSEI0WENJc1hDSnphRzkzUm1Ga1pWd2lPblJ5ZFdVc1hDSm9hV1JsVkhKaGJuTm1iM0p0WENJNlhDSmNJaXhjSW1ocFpHVlBjbWxuYVc1Y0lqcGNJbHdpTEZ3aWFHbGtaVVpoWkdWY0lqcDBjblZsTEZ3aWIzSmtaWEpjSWpveExGd2lkSGx3WlZ3aU9sd2lkR1Y0ZEZ3aUxGd2lZMjl1ZEdWdWRGd2lPbHdpVmxWTVVGVlVRVlJGSUZaRlRFbFVYQ0lzWENKMmFXUmxiMXdpT2x3aWFIUjBjRG92TDNCc1lYbGxjaTUyYVcxbGJ5NWpiMjB2ZG1sa1pXOHZNVEUzTWpFeU5ESmNJaXhjSW1Gc2FXZHVYQ0k2WENKMGIzQmNJaXhjSW05bVpuTmxkRmhjSWpveU1ETXNYQ0p2Wm1aelpYUlpYQ0k2TWpVMExGd2ljbVZ6YVhwbFhDSTZkSEoxWlN4Y0luZHBaSFJvYkdsdGFYUmNJanBjSWpCY0lpeGNJbU5zWVhOelRtRnRaVndpT2x3aWJYTndMV051TFRJNU1DMDBYQ0lzWENKemFHOTNSSFZ5WVhScGIyNWNJam95TEZ3aWMyaHZkMFZoYzJWY0lqcGNJbVZoYzJWUGRYUkZlSEJ2WENJc1hDSnphRzkzUldabVJuVnVZMXdpT2x3aWRDaDBjblZsTERBc0xUWXdMRzRzYml3Mk5TeHVMREFzYml4dUxHNHNMVEUxTEc0c2JpeHVLVndpTEZ3aWRYTmxTR2xrWlZ3aU9tWmhiSE5sTEZ3aWFHbGtaVVIxY21GMGFXOXVYQ0k2TVN4Y0ltaHBaR1ZFWld4aGVWd2lPakVzWENKb2FXUmxSV0Z6WlZ3aU9sd2laV0Z6WlU5MWRGRjFhVzUwWENJc1hDSnpiR2xrWlZ3aU9qTXNYQ0p6ZEhsc1pVMXZaR1ZzWENJNk5DeGNJbk5vYjNkRlptWmxZM1JjSWpvM0xGd2lhR2xrWlVWbVptVmpkRndpT2poOUlpd2lOU0k2SW50Y0ltbGtYQ0k2TlN4Y0ltNWhiV1ZjSWpwY0luUjRkRndpTEZ3aWFYTk1iMk5yWldSY0lqcG1ZV3h6WlN4Y0ltbHpTR2xrWldSY0lqcG1ZV3h6WlN4Y0ltbHpVMjlzYjJWa1hDSTZabUZzYzJVc1hDSnphRzkzVkhKaGJuTm1iM0p0WENJNlhDSndaWEp6Y0dWamRHbDJaU2d5TURBd2NIZ3BJSFJ5WVc1emJHRjBaVmtvTFRZd2NIZ3BJSEp2ZEdGMFpWZ29OalZrWldjcElITnJaWGRaS0MweE5XUmxaeWtnWENJc1hDSnphRzkzVDNKcFoybHVYQ0k2WENJMU1DVWdOVEFsSURCd2VGd2lMRndpYzJodmQwWmhaR1ZjSWpwMGNuVmxMRndpYUdsa1pWUnlZVzV6Wm05eWJWd2lPbHdpWENJc1hDSm9hV1JsVDNKcFoybHVYQ0k2WENKY0lpeGNJbWhwWkdWR1lXUmxYQ0k2ZEhKMVpTeGNJbTl5WkdWeVhDSTZNQ3hjSW5SNWNHVmNJanBjSW5SbGVIUmNJaXhjSW1OdmJuUmxiblJjSWpwY0lrTlBUbE5GVVZWQlZDQldSVXdnUmtWVlIwbEJWRndpTEZ3aWRtbGtaVzljSWpwY0ltaDBkSEE2THk5d2JHRjVaWEl1ZG1sdFpXOHVZMjl0TDNacFpHVnZMekV4TnpJeE1qUXlYQ0lzWENKaGJHbG5ibHdpT2x3aWRHOXdYQ0lzWENKdlptWnpaWFJZWENJNk1DeGNJbTltWm5ObGRGbGNJam96TURrc1hDSnlaWE5wZW1WY0lqcDBjblZsTEZ3aWQybGtkR2hzYVcxcGRGd2lPbHdpTUZ3aUxGd2lZMnhoYzNOT1lXMWxYQ0k2WENKdGMzQXRZMjR0TWprd0xUVmNJaXhjSW5Ob2IzZEVkWEpoZEdsdmJsd2lPaklzWENKemFHOTNSR1ZzWVhsY0lqb3dMalF6TnpVc1hDSnphRzkzUldGelpWd2lPbHdpWldGelpVOTFkRVY0Y0c5Y0lpeGNJbk5vYjNkRlptWkdkVzVqWENJNlhDSjBLSFJ5ZFdVc2Jpd3ROakFzYml4dUxEWTFMRzRzYml4dUxHNHNiaXd0TVRVc2JpeHVMRzRwWENJc1hDSjFjMlZJYVdSbFhDSTZabUZzYzJVc1hDSm9hV1JsUkhWeVlYUnBiMjVjSWpveExGd2lhR2xrWlVSbGJHRjVYQ0k2TVN4Y0ltaHBaR1ZGWVhObFhDSTZYQ0psWVhObFQzVjBVWFZwYm5SY0lpeGNJbk5zYVdSbFhDSTZNeXhjSW5OMGVXeGxUVzlrWld4Y0lqbzFMRndpYzJodmQwVm1abVZqZEZ3aU9qa3NYQ0pvYVdSbFJXWm1aV04wWENJNk1UQjlJaXdpTmlJNkludGNJbWxrWENJNk5peGNJbTVoYldWY0lqcGNJbUowYmx3aUxGd2lhWE5NYjJOclpXUmNJanBtWVd4elpTeGNJbWx6U0dsa1pXUmNJanBtWVd4elpTeGNJbWx6VTI5c2IyVmtYQ0k2Wm1Gc2MyVXNYQ0p6YUc5M1ZISmhibk5tYjNKdFhDSTZYQ0p3WlhKemNHVmpkR2wyWlNneU1EQXdjSGdwSUhOallXeGxXQ2d4TGpVcElITmpZV3hsV1NneExqVXBJRndpTEZ3aWMyaHZkMDl5YVdkcGJsd2lPbHdpTlRBbElEVXdKU0F3Y0hoY0lpeGNJbk5vYjNkR1lXUmxYQ0k2ZEhKMVpTeGNJbWhwWkdWVWNtRnVjMlp2Y20xY0lqcGNJbHdpTEZ3aWFHbGtaVTl5YVdkcGJsd2lPbHdpWENJc1hDSm9hV1JsUm1Ga1pWd2lPblJ5ZFdVc1hDSnBiV2RVYUhWdFlsd2lPbHdpTHpJd01UUXZNRFF2WW5SdUxYSmxaQzV3Ym1kY0lpeGNJbTl5WkdWeVhDSTZNaXhjSW5SNWNHVmNJanBjSW1sdFlXZGxYQ0lzWENKamIyNTBaVzUwWENJNlhDSk1iM0psYlNCSmNITjFiVndpTEZ3aWFXMW5YQ0k2WENJdk1qQXhOQzh3TkM5aWRHNHRjbVZrTG5CdVoxd2lMRndpZG1sa1pXOWNJanBjSW1oMGRIQTZMeTl3YkdGNVpYSXVkbWx0Wlc4dVkyOXRMM1pwWkdWdkx6RXhOekl4TWpReVhDSXNYQ0poYkdsbmJsd2lPbHdpZEc5d1hDSXNYQ0p2Wm1aelpYUllYQ0k2TnpZd0xGd2liMlptYzJWMFdWd2lPak00TVN4Y0luSmxjMmw2WlZ3aU9uUnlkV1VzWENKM2FXUjBhR3hwYldsMFhDSTZYQ0l3WENJc1hDSnphRzkzUkhWeVlYUnBiMjVjSWpveExqVXNYQ0p6YUc5M1JHVnNZWGxjSWpvd0xqVXNYQ0p6YUc5M1JXRnpaVndpT2x3aVpXRnpaVWx1VDNWMFVYVmhjblJjSWl4Y0luTm9iM2RGWm1aR2RXNWpYQ0k2WENKMEtIUnlkV1VzYml4dUxHNHNiaXh1TEc0c2Jpd3hMalVzTVM0MUxHNHNiaXh1TEc0c2JpbGNJaXhjSW5WelpVaHBaR1ZjSWpwbVlXeHpaU3hjSW1ocFpHVkVkWEpoZEdsdmJsd2lPakVzWENKb2FXUmxSR1ZzWVhsY0lqb3hMRndpYUdsa1pVVmhjMlZjSWpwY0ltVmhjMlZQZFhSUmRXbHVkRndpTEZ3aWMyeHBaR1ZjSWpveUxGd2ljM1I1YkdWTmIyUmxiRndpT2pZc1hDSnphRzkzUldabVpXTjBYQ0k2TVRFc1hDSm9hV1JsUldabVpXTjBYQ0k2TVRKOUlpd2lPQ0k2SW50Y0ltbGtYQ0k2T0N4Y0ltNWhiV1ZjSWpwY0luUjRkRndpTEZ3aWFYTk1iMk5yWldSY0lqcG1ZV3h6WlN4Y0ltbHpTR2xrWldSY0lqcG1ZV3h6WlN4Y0ltbHpVMjlzYjJWa1hDSTZabUZzYzJVc1hDSnphRzkzVkhKaGJuTm1iM0p0WENJNlhDSndaWEp6Y0dWamRHbDJaU2d5TURBd2NIZ3BJSFJ5WVc1emJHRjBaVmdvTFRJMU1IQjRLU0J6YTJWM1dDZ3RNalZrWldjcElGd2lMRndpYzJodmQwOXlhV2RwYmx3aU9sd2lOVEFsSURVd0pTQXdjSGhjSWl4Y0luTm9iM2RHWVdSbFhDSTZkSEoxWlN4Y0ltaHBaR1ZVY21GdWMyWnZjbTFjSWpwY0lsd2lMRndpYUdsa1pVOXlhV2RwYmx3aU9sd2lYQ0lzWENKb2FXUmxSbUZrWlZ3aU9uUnlkV1VzWENKdmNtUmxjbHdpT2pBc1hDSjBlWEJsWENJNlhDSjBaWGgwWENJc1hDSmpiMjUwWlc1MFhDSTZYQ0pDVEVGT1JFbFVJRkJGVWtGRlUwVk9WRndpTEZ3aWRtbGtaVzljSWpwY0ltaDBkSEE2THk5d2JHRjVaWEl1ZG1sdFpXOHVZMjl0TDNacFpHVnZMekV4TnpJeE1qUXlYQ0lzWENKaGJHbG5ibHdpT2x3aWRHOXdYQ0lzWENKdlptWnpaWFJZWENJNk5EZ3hMRndpYjJabWMyVjBXVndpT2pRek5DeGNJbkpsYzJsNlpWd2lPblJ5ZFdVc1hDSjNhV1IwYUd4cGJXbDBYQ0k2WENJd1hDSXNYQ0pqYkdGemMwNWhiV1ZjSWpwY0ltMXpjQzFqYmkweU9UQXRPRndpTEZ3aWMyaHZkMFIxY21GMGFXOXVYQ0k2TVM0eE1USTFMRndpYzJodmQwUmxiR0Y1WENJNk1DNHpOelVzWENKemFHOTNSV0Z6WlZ3aU9sd2laV0Z6WlU5MWRGRjFhVzUwWENJc1hDSnphRzkzUldabVJuVnVZMXdpT2x3aWRDaDBjblZsTEMweU5UQXNiaXh1TEc0c2JpeHVMRzRzYml4dUxDMHlOU3h1TEc0c2JpeHVLVndpTEZ3aWRYTmxTR2xrWlZ3aU9tWmhiSE5sTEZ3aWFHbGtaVVIxY21GMGFXOXVYQ0k2TVN4Y0ltaHBaR1ZFWld4aGVWd2lPakVzWENKb2FXUmxSV0Z6WlZ3aU9sd2laV0Z6WlU5MWRGRjFhVzUwWENJc1hDSnpiR2xrWlZ3aU9qUXNYQ0p6ZEhsc1pVMXZaR1ZzWENJNk9DeGNJbk5vYjNkRlptWmxZM1JjSWpveE5TeGNJbWhwWkdWRlptWmxZM1JjSWpveE5uMGlMQ0k1SWpvaWUxd2lhV1JjSWpvNUxGd2libUZ0WlZ3aU9sd2lZblJ1WENJc1hDSnBjMHh2WTJ0bFpGd2lPbVpoYkhObExGd2lhWE5JYVdSbFpGd2lPbVpoYkhObExGd2lhWE5UYjJ4dlpXUmNJanBtWVd4elpTeGNJbk5vYjNkVWNtRnVjMlp2Y20xY0lqcGNJbkJsY25Od1pXTjBhWFpsS0RJd01EQndlQ2tnZEhKaGJuTnNZWFJsV1NneE5UQndlQ2tnWENJc1hDSnphRzkzVDNKcFoybHVYQ0k2WENJMU1DVWdOVEFsSURCd2VGd2lMRndpYzJodmQwWmhaR1ZjSWpwMGNuVmxMRndpYUdsa1pWUnlZVzV6Wm05eWJWd2lPbHdpWENJc1hDSm9hV1JsVDNKcFoybHVYQ0k2WENKY0lpeGNJbWhwWkdWR1lXUmxYQ0k2ZEhKMVpTeGNJbWx0WjFSb2RXMWlYQ0k2WENJdk1qQXhOQzh3TkM5aWRHNHRZbXgxWlM1d2JtZGNJaXhjSW05eVpHVnlYQ0k2TVN4Y0luUjVjR1ZjSWpwY0ltbHRZV2RsWENJc1hDSmpiMjUwWlc1MFhDSTZYQ0pNYjNKbGJTQkpjSE4xYlZ3aUxGd2lhVzFuWENJNlhDSXZNakF4TkM4d05DOWlkRzR0WW14MVpTNXdibWRjSWl4Y0luWnBaR1Z2WENJNlhDSm9kSFJ3T2k4dmNHeGhlV1Z5TG5acGJXVnZMbU52YlM5MmFXUmxieTh4TVRjeU1USTBNbHdpTEZ3aVlXeHBaMjVjSWpwY0luUnZjRndpTEZ3aWIyWm1jMlYwV0Z3aU9qUTRNaXhjSW05bVpuTmxkRmxjSWpvME56SXNYQ0p5WlhOcGVtVmNJanAwY25WbExGd2lkMmxrZEdoc2FXMXBkRndpT2x3aU1Gd2lMRndpYzJodmQwUjFjbUYwYVc5dVhDSTZNUzR4TVRJMUxGd2ljMmh2ZDBSbGJHRjVYQ0k2TUM0eU1USTFMRndpYzJodmQwVmhjMlZjSWpwY0ltVmhjMlZQZFhSUmRXbHVkRndpTEZ3aWMyaHZkMFZtWmtaMWJtTmNJanBjSW5Rb2RISjFaU3h1TERFMU1DeHVMRzRzYml4dUxHNHNiaXh1TEc0c2JpeHVMRzRzYmlsY0lpeGNJblZ6WlVocFpHVmNJanBtWVd4elpTeGNJbWhwWkdWRWRYSmhkR2x2Ymx3aU9qRXNYQ0pvYVdSbFJHVnNZWGxjSWpveExGd2lhR2xrWlVWaGMyVmNJanBjSW1WaGMyVlBkWFJSZFdsdWRGd2lMRndpYzJ4cFpHVmNJam8wTEZ3aWMzUjViR1ZOYjJSbGJGd2lPamtzWENKemFHOTNSV1ptWldOMFhDSTZNVGNzWENKb2FXUmxSV1ptWldOMFhDSTZNVGg5SWl3aU1UQWlPaUo3WENKcFpGd2lPakV3TEZ3aWJtRnRaVndpT2x3aWRIaDBYQ0lzWENKcGMweHZZMnRsWkZ3aU9tWmhiSE5sTEZ3aWFYTklhV1JsWkZ3aU9tWmhiSE5sTEZ3aWFYTlRiMnh2WldSY0lqcG1ZV3h6WlN4Y0luTm9iM2RVY21GdWMyWnZjbTFjSWpwY0luQmxjbk53WldOMGFYWmxLREl3TURCd2VDa2dkSEpoYm5Oc1lYUmxXQ2d4TlRCd2VDa2dYQ0lzWENKemFHOTNUM0pwWjJsdVhDSTZYQ0kxTUNVZ05UQWxJREJ3ZUZ3aUxGd2ljMmh2ZDBaaFpHVmNJanAwY25WbExGd2lhR2xrWlZSeVlXNXpabTl5YlZ3aU9sd2lYQ0lzWENKb2FXUmxUM0pwWjJsdVhDSTZYQ0pjSWl4Y0ltaHBaR1ZHWVdSbFhDSTZkSEoxWlN4Y0ltOXlaR1Z5WENJNk1peGNJblI1Y0dWY0lqcGNJblJsZUhSY0lpeGNJbU52Ym5SbGJuUmNJanBjSWtWVFUwVWdUVTlNUlZOVVNVVmNJaXhjSW5acFpHVnZYQ0k2WENKb2RIUndPaTh2Y0d4aGVXVnlMblpwYldWdkxtTnZiUzkyYVdSbGJ5OHhNVGN5TVRJME1sd2lMRndpWVd4cFoyNWNJanBjSW5SdmNGd2lMRndpYjJabWMyVjBXRndpT2pRM055eGNJbTltWm5ObGRGbGNJam96TnpVc1hDSnlaWE5wZW1WY0lqcDBjblZsTEZ3aWQybGtkR2hzYVcxcGRGd2lPbHdpTUZ3aUxGd2lZMnhoYzNOT1lXMWxYQ0k2WENKdGMzQXRZMjR0TWprd0xURXdYQ0lzWENKemFHOTNSSFZ5WVhScGIyNWNJam94TEZ3aWMyaHZkMFJsYkdGNVhDSTZNQzR5TXpjMUxGd2ljMmh2ZDBWaGMyVmNJanBjSW1WaGMyVlBkWFJSZFdsdWRGd2lMRndpYzJodmQwVm1aa1oxYm1OY0lqcGNJblFvZEhKMVpTd3hOVEFzYml4dUxHNHNiaXh1TEc0c2JpeHVMRzRzYml4dUxHNHNiaWxjSWl4Y0luVnpaVWhwWkdWY0lqcG1ZV3h6WlN4Y0ltaHBaR1ZFZFhKaGRHbHZibHdpT2pFc1hDSm9hV1JsUkdWc1lYbGNJam94TEZ3aWFHbGtaVVZoYzJWY0lqcGNJbVZoYzJWUGRYUlJkV2x1ZEZ3aUxGd2ljMnhwWkdWY0lqbzBMRndpYzNSNWJHVk5iMlJsYkZ3aU9qRXdMRndpYzJodmQwVm1abVZqZEZ3aU9qRTVMRndpYUdsa1pVVm1abVZqZEZ3aU9qSXdmU0lzSWpFeElqb2llMXdpYVdSY0lqb3hNU3hjSW01aGJXVmNJanBjSW5SNGRGd2lMRndpYVhOTWIyTnJaV1JjSWpwbVlXeHpaU3hjSW1selNHbGtaV1JjSWpwbVlXeHpaU3hjSW1selUyOXNiMlZrWENJNlptRnNjMlVzWENKemFHOTNWSEpoYm5ObWIzSnRYQ0k2WENKd1pYSnpjR1ZqZEdsMlpTZ3lNREF3Y0hncElIUnlZVzV6YkdGMFpWa29NVFV3Y0hncElITmpZV3hsV1Nnd0xqWTFLU0JjSWl4Y0luTm9iM2RQY21sbmFXNWNJanBjSWpVd0pTQTFNQ1VnTUhCNFhDSXNYQ0p6YUc5M1JtRmtaVndpT25SeWRXVXNYQ0pvYVdSbFZISmhibk5tYjNKdFhDSTZYQ0pjSWl4Y0ltaHBaR1ZQY21sbmFXNWNJanBjSWx3aUxGd2lhR2xrWlVaaFpHVmNJanAwY25WbExGd2liM0prWlhKY0lqb3dMRndpZEhsd1pWd2lPbHdpZEdWNGRGd2lMRndpWTI5dWRHVnVkRndpT2x3aVNFUWdRa0ZEUzBkU1QxVk9SQ0JXU1VSRlQxTmNJaXhjSW5acFpHVnZYQ0k2WENKb2RIUndPaTh2Y0d4aGVXVnlMblpwYldWdkxtTnZiUzkyYVdSbGJ5OHhNVGN5TVRJME1sd2lMRndpWVd4cFoyNWNJanBjSW5SdmNGd2lMRndpYjJabWMyVjBXRndpT2pFMU5DNDFMRndpYjJabWMyVjBXVndpT2pNMU1DeGNJbkpsYzJsNlpWd2lPblJ5ZFdVc1hDSjNhV1IwYUd4cGJXbDBYQ0k2WENJd1hDSXNYQ0pqYkdGemMwNWhiV1ZjSWpwY0ltMXpjQzFqYmkweU9UQXRNVEZjSWl4Y0luTm9iM2RFZFhKaGRHbHZibHdpT2pFc1hDSnphRzkzUkdWc1lYbGNJam93TEZ3aWMyaHZkMFZoYzJWY0lqcGNJbVZoYzJWUGRYUlJkV2x1ZEZ3aUxGd2ljMmh2ZDBWbVprWjFibU5jSWpwY0luUW9kSEoxWlN4dUxERTFNQ3h1TEc0c2JpeHVMRzRzYml3d0xqWTFMRzRzYml4dUxHNHNiaWxjSWl4Y0luVnpaVWhwWkdWY0lqcG1ZV3h6WlN4Y0ltaHBaR1ZFZFhKaGRHbHZibHdpT2pFc1hDSm9hV1JsUkdWc1lYbGNJam94TEZ3aWFHbGtaVVZoYzJWY0lqcGNJbVZoYzJWUGRYUlJkV2x1ZEZ3aUxGd2ljMnhwWkdWY0lqbzNMRndpYzNSNWJHVk5iMlJsYkZ3aU9qRXhMRndpYzJodmQwVm1abVZqZEZ3aU9qSXhMRndpYUdsa1pVVm1abVZqZEZ3aU9qSXlmU0o5ZlE9PSIsInR5cGUiOiJjdXN0b20iLCJzbGlkZXNfbnVtIjoiNSJ9fSwib3JpZ2luX3VwbG9hZHNfdXJsIjoiaHR0cDpcL1wvZGVtby5hdmVydGEubmV0XC90aGVtZXNcL2xvdHVzXC9kdW1teS1hZ2VuY3lcL3dwLWNvbnRlbnRcL3VwbG9hZHMiLCJwcmVzZXRfc3R5bGVzIjoiIiwicHJlc2V0X2VmZmVjdHMiOiIifQ==',
			'image_dir' => '',
			'selected' 	=> '',
			'screenshot'=> MSWP_AVERTA_ADMIN_URL . '/assets/images/starters/fullscreen-slider-1.jpg'
		),
		array(
			'label' 	=> __( 'Slider in Tablet', MSWP_TEXT_DOMAIN ),
			'id' 		=> 'slider-in-tablet',
			'slidertype'=> 'custom',
			'importdata'=> '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',
			'image_dir' => '',
			'selected' 	=> '',
			'screenshot'=> MSWP_AVERTA_ADMIN_URL . '/assets/images/starters/slider-in-tablet.jpg'
		),
		array(
			'label' 	=> __( 'Slider in Flat Tablet', MSWP_TEXT_DOMAIN ),
			'id' 		=> 'slider-in-flat-tablet',
			'slidertype'=> 'custom',
			'importdata'=> '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',
			'image_dir' => '',
			'selected' 	=> '',
			'screenshot'=> MSWP_AVERTA_ADMIN_URL . '/assets/images/starters/slider-in-flat-tablet.jpg'
		),
		array(
			'label' 	=> __( 'Slider in Landscape Tablet', MSWP_TEXT_DOMAIN ),
			'id' 		=> 'slider-in-landscape-tablet',
			'slidertype'=> 'custom',
			'importdata'=> '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',
			'image_dir' => '',
			'selected' 	=> '',
			'screenshot'=> MSWP_AVERTA_ADMIN_URL . '/assets/images/starters/slider-in-landscape-tablet.jpg'
		),
		array(
			'label' 	=> __( 'Slider in Flat Landscape Tablet', MSWP_TEXT_DOMAIN ),
			'id' 		=> 'slider-in-flat-landscape-tablet',
			'slidertype'=> 'custom',
			'importdata'=> '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',
			'image_dir' => '',
			'selected' 	=> '',
			'screenshot'=> MSWP_AVERTA_ADMIN_URL . '/assets/images/starters/slider-in-flat-landscape-tablet.jpg'
		),
		array(
			'label' 	=> __( 'Slider in Smartphone', MSWP_TEXT_DOMAIN ),
			'id' 		=> 'slider-in-smartphone',
			'slidertype'=> 'custom',
			'importdata'=> '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',
			'image_dir' => '',
			'selected' 	=> '',
			'screenshot'=> MSWP_AVERTA_ADMIN_URL . '/assets/images/starters/slider-in-smartphone.jpg'
		),
		array(
			'label' 	=> __( 'Slider in Flat Smartphone', MSWP_TEXT_DOMAIN ),
			'id' 		=> 'slider-in-flat-smartphone',
			'slidertype'=> 'custom',
			'importdata'=> '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',
			'image_dir' => '',
			'selected' 	=> '',
			'screenshot'=> MSWP_AVERTA_ADMIN_URL . '/assets/images/starters/slider-in-flat-smartphone.jpg'
		),
		array(
			'label' 	=> __( 'Slider in Landscape Smartphone', MSWP_TEXT_DOMAIN ),
			'id' 		=> 'slider-in-landscape-smartphone',
			'slidertype'=> 'custom',
			'importdata'=> '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',
			'image_dir' => '',
			'selected' 	=> '',
			'screenshot'=> MSWP_AVERTA_ADMIN_URL . '/assets/images/starters/slider-in-landscape-smartphone.jpg'
		),
		array(
			'label' 	=> __( 'Slider in Flat Landscape Smartphone', MSWP_TEXT_DOMAIN ),
			'id' 		=> 'slider-in-flat-landscape-smartphone',
			'slidertype'=> 'custom',
			'importdata'=> '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',
			'image_dir' => '',
			'selected' 	=> '',
			'screenshot'=> MSWP_AVERTA_ADMIN_URL . '/assets/images/starters/slider-in-flat-landscape-smartphone.jpg'
		),
		array(
			'label' 	=> __( 'Parallax Swipe Effect', MSWP_TEXT_DOMAIN ),
			'id' 		=> 'slider-in-parallax-swipe-1',
			'slidertype'=> 'custom',
			'importdata'=> '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',
			'image_dir' => '',
			'selected' 	=> '',
			'screenshot'=> MSWP_AVERTA_ADMIN_URL . '/assets/images/starters/parallax-swipe-1.jpg'
		),
		array(
			'label' 	=> __( 'Parallax Follow Mouse', MSWP_TEXT_DOMAIN ),
			'id' 		=> 'slider-in-parallax-mouse-1',
			'slidertype'=> 'custom',
			'importdata'=> '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',
			'image_dir' => '',
			'selected' 	=> '',
			'screenshot'=> MSWP_AVERTA_ADMIN_URL . '/assets/images/starters/parallax-follow-mouse.jpg'
		)
	);


	$starters['masterslider_dynamic_group'] = array(

		array(
			'label' 	=> __( 'Post Slider Boxed Layout', MSWP_TEXT_DOMAIN ),
			'id' 		=> 'post-slider-boxed-1',
			'slidertype'=> 'custom',
			'importdata'=> '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',
			'image_dir' => '',
			'selected' 	=> '',
			'screenshot'=> MSWP_AVERTA_ADMIN_URL . '/assets/images/starters/post-slider-boxed-layout.jpg'
		),
		array(
			'label' 	=> __( 'Post Slider With Excerpt', MSWP_TEXT_DOMAIN ),
			'id' 		=> 'post-slider-excerpt-1',
			'slidertype'=> 'custom',
			'importdata'=> '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',
			'image_dir' => '',
			'selected' 	=> '',
			'screenshot'=> MSWP_AVERTA_ADMIN_URL . '/assets/images/starters/post-slider-with-excerpt.jpg'
		),
		array(
			'label' 	=> __( 'Post Slider With Partial View', MSWP_TEXT_DOMAIN ),
			'id' 		=> 'post-slider-partial-1',
			'slidertype'=> 'custom',
			'importdata'=> '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',
			'image_dir' => '',
			'selected' 	=> '',
			'screenshot'=> MSWP_AVERTA_ADMIN_URL . '/assets/images/starters/post-slider-with-partial-view.jpg'
		)
	);
	
	
	return apply_filters( 'masterslider_starter_fields', $starters );
}



function msp_get_slider_starter_field( $field_id ){
	$fields_in_sections = msp_get_slider_starter_fields();

	foreach ( $fields_in_sections as $fields_in_section ) {
		foreach ($fields_in_section as $the_field ) {
			if ( isset( $the_field['id'] ) &&  $the_field['id'] == $field_id ){
				return $the_field;
			}
		}
	}

	return null;
}