import { Icon } from '@wordpress/components';
import { __ } from '@wordpress/i18n';
import { helpFilled } from '@wordpress/icons';
import { useGlobalSyncStore } from '@help-center/state/globals-sync';

export const AdminBar = () => {
	const { setVisibility } = useGlobalSyncStore();
	return (
		<button
			type="button"
			data-test="help-center-adminbar-button"
			onClick={() => setVisibility('open')}
			className="m-1.5 -mt-1 inline-flex h-6 cursor-pointer items-center justify-center gap-1 rounded-sm border-0 bg-wp-theme-main p-1 px-2 leading-extra-tight text-white ring-offset-1 ring-offset-wp-theme-bg focus:outline-none focus:ring-wp focus:ring-wp-theme-main">
			{__('Help', 'extendify-local')}
			<Icon
				icon={helpFilled}
				width={18}
				height={18}
				className="fill-design-text"
			/>
		</button>
	);
};
